/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.CollectionUDF;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.expression.function.CollectionUDF.AppendCore;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class MapAppendFunctionImpl
extends ImplementorUDF {
    public MapAppendFunctionImpl() {
        super(new MapAppendImplementor(), NullPolicy.ALL);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return sqlOperatorBinding -> {
            RelDataTypeFactory typeFactory = sqlOperatorBinding.getTypeFactory();
            return typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.ANY));
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }

    public static Object mapAppend(Object map1, Object map2) {
        if (map1 == null && map2 == null) {
            return null;
        }
        if (map1 == null) {
            return MapAppendFunctionImpl.mapAppendImpl(MapAppendFunctionImpl.verifyMap(map2));
        }
        if (map2 == null) {
            return MapAppendFunctionImpl.mapAppendImpl(MapAppendFunctionImpl.verifyMap(map1));
        }
        return MapAppendFunctionImpl.mapAppendImpl(MapAppendFunctionImpl.verifyMap(map1), MapAppendFunctionImpl.verifyMap(map2));
    }

    private static Map<String, Object> verifyMap(Object map) {
        if (!(map instanceof Map)) {
            throw new IllegalArgumentException("MAP_APPEND function requires both arguments to be MAP type");
        }
        return (Map)map;
    }

    static Map<String, Object> mapAppendImpl(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            result.put(key, AppendCore.collectElements(map.get(key)));
        }
        return result;
    }

    static Map<String, Object> mapAppendImpl(Map<String, Object> firstMap, Map<String, Object> secondMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : MapAppendFunctionImpl.mergeKeys(firstMap, secondMap)) {
            result.put(key, AppendCore.collectElements(firstMap.get(key), secondMap.get(key)));
        }
        return result;
    }

    private static Set<String> mergeKeys(Map<String, Object> firstMap, Map<String, Object> secondMap) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(firstMap.keySet());
        keys.addAll(secondMap.keySet());
        return keys;
    }

    public static class MapAppendImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            if (translatedOperands.size() != 2) {
                throw new IllegalArgumentException("MAP_APPEND function requires exactly 2 arguments");
            }
            return Expressions.call((Method)Types.lookupMethod(MapAppendFunctionImpl.class, (String)"mapAppend", (Class[])new Class[]{Object.class, Object.class}), (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1)});
        }
    }
}

