/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.analysis;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.analysis.FieldResolutionResult;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class FieldResolutionContext {
    private final Map<UnresolvedPlan, FieldResolutionResult> results = new IdentityHashMap<UnresolvedPlan, FieldResolutionResult>();
    private final Deque<FieldResolutionResult> requirementsStack = new ArrayDeque<FieldResolutionResult>();

    public FieldResolutionContext() {
        this.requirementsStack.push(new FieldResolutionResult(Set.of(), "*"));
    }

    public void pushRequirements(FieldResolutionResult result) {
        this.requirementsStack.push(result);
    }

    public FieldResolutionResult popRequirements() {
        return this.requirementsStack.pop();
    }

    public FieldResolutionResult getCurrentRequirements() {
        if (this.requirementsStack.isEmpty()) {
            throw new RuntimeException("empty stack");
        }
        return this.requirementsStack.peek();
    }

    public void setResult(UnresolvedPlan relation, FieldResolutionResult result) {
        this.results.put(relation, result);
    }

    public Set<Relation> getRelations() {
        return this.results.keySet().stream().filter(k -> k instanceof Relation).map(k -> (Relation)k).collect(Collectors.toSet());
    }

    public static String mergeWildcardPatterns(Set<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        if (patterns.size() == 1) {
            return patterns.iterator().next();
        }
        return String.join((CharSequence)" | ", patterns.stream().sorted().toList());
    }

    public String toString() {
        return "FieldResolutionContext{relationResults=" + String.valueOf(this.results) + "}";
    }

    @Generated
    public Map<UnresolvedPlan, FieldResolutionResult> getResults() {
        return this.results;
    }
}

