/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/opensearch/commons/notifications/model/Sns;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "topicArn", "", "roleArn", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getTopicArn", "()Ljava/lang/String;", "getRoleArn", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nSns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sns.kt\norg/opensearch/commons/notifications/model/Sns\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class Sns
implements BaseConfigData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String topicArn;
    @Nullable
    private final String roleArn;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(Sns.class);
    private static final Pattern SNS_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:sns:([a-zA-Z0-9-]+):([0-9]{12}):([a-zA-Z_0-9+=,.@\\-_/]+)$");
    @NotNull
    private static final Writeable.Reader<Sns> reader = Sns::reader$lambda$0;
    @NotNull
    private static final XParser<Sns> xParser = Sns::xParser$lambda$0;

    public Sns(@NotNull String topicArn, @Nullable String roleArn) {
        Intrinsics.checkNotNullParameter((Object)topicArn, (String)"topicArn");
        this.topicArn = topicArn;
        this.roleArn = roleArn;
        if (!SNS_ARN_REGEX.matcher(this.topicArn).find()) {
            boolean bl = false;
            String string = "Invalid AWS SNS topic ARN: " + this.topicArn;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.roleArn != null) {
            ValidationHelpersKt.validateIamRoleArn(this.roleArn);
        }
    }

    @NotNull
    public final String getTopicArn() {
        return this.topicArn;
    }

    @Nullable
    public final String getRoleArn() {
        return this.roleArn;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field("topic_arn", this.topicArn);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(xContentBuilder, "role_arn", this.roleArn).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    public Sns(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this(string, input.readOptionalString());
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.topicArn);
        out.writeOptionalString(this.roleArn);
    }

    @NotNull
    public final String component1() {
        return this.topicArn;
    }

    @Nullable
    public final String component2() {
        return this.roleArn;
    }

    @NotNull
    public final Sns copy(@NotNull String topicArn, @Nullable String roleArn) {
        Intrinsics.checkNotNullParameter((Object)topicArn, (String)"topicArn");
        return new Sns(topicArn, roleArn);
    }

    public static /* synthetic */ Sns copy$default(Sns sns, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = sns.topicArn;
        }
        if ((n & 2) != 0) {
            string2 = sns.roleArn;
        }
        return sns.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Sns(topicArn=" + this.topicArn + ", roleArn=" + this.roleArn + ")";
    }

    public int hashCode() {
        int result = this.topicArn.hashCode();
        result = result * 31 + (this.roleArn == null ? 0 : this.roleArn.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Sns)) {
            return false;
        }
        Sns sns = (Sns)other;
        if (!Intrinsics.areEqual((Object)this.topicArn, (Object)sns.topicArn)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.roleArn, (Object)sns.roleArn);
    }

    private static final Sns reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new Sns(it);
    }

    private static final Sns xParser$lambda$0(XContentParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.parse(it);
    }

    @JvmStatic
    @NotNull
    public static final Sns parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/commons/notifications/model/Sns$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "SNS_ARN_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/Sns;", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "xParser", "Lorg/opensearch/commons/notifications/model/XParser;", "getXParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "parse", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<Sns> getReader() {
            return reader;
        }

        @NotNull
        public final XParser<Sns> getXParser() {
            return xParser;
        }

        @JvmStatic
        @NotNull
        public final Sns parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String topicArn = null;
            String roleArn = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"topic_arn")) {
                    topicArn = xcp.textOrNull();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"role_arn")) {
                    roleArn = xcp.textOrNull();
                    continue;
                }
                xcp.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing SNS destination");
            }
            if (topicArn == null) {
                throw new IllegalArgumentException("topic_arn field absent");
            }
            return new Sns(topicArn, roleArn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

