/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PercentilesBucketAggregation
extends PipelineAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, PercentilesBucketAggregation> {
    @Nonnull
    private final List<Double> percents;
    public static final JsonpDeserializer<PercentilesBucketAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesBucketAggregation::setupPercentilesBucketAggregationDeserializer);

    private PercentilesBucketAggregation(Builder builder) {
        super(builder);
        this.percents = ApiTypeHelper.unmodifiable(builder.percents);
    }

    public static PercentilesBucketAggregation of(Function<Builder, ObjectBuilder<PercentilesBucketAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.PercentilesBucket;
    }

    @Nonnull
    public final List<Double> percents() {
        return this.percents;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.percents)) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPercentilesBucketAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PercentilesBucketAggregation.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.percents);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PercentilesBucketAggregation other = (PercentilesBucketAggregation)o;
        return Objects.equals(this.percents, other.percents);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PercentilesBucketAggregation> {
        @Nullable
        private List<Double> percents;

        public Builder() {
        }

        private Builder(PercentilesBucketAggregation o) {
            super(o);
            this.percents = Builder._listCopy(o.percents);
        }

        private Builder(Builder o) {
            super(o);
            this.percents = Builder._listCopy(o.percents);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder percents(List<Double> list) {
            this.percents = Builder._listAddAll(this.percents, list);
            return this;
        }

        @Nonnull
        public final Builder percents(Double value, Double ... values) {
            this.percents = Builder._listAdd(this.percents, value, values);
            return this;
        }

        @Override
        @Nonnull
        public PercentilesBucketAggregation build() {
            this._checkSingleUse();
            return new PercentilesBucketAggregation(this);
        }
    }
}

