"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = exports.getMapSavedObjects = void 0;
var _common = require("../../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getStats = mapsSavedObjects => {
  const totalLayersCountByType = buildLayerTypesCountObject();
  let totalLayersFiltersCount = 0;
  const mapsList = [];
  mapsSavedObjects.saved_objects.forEach(mapRes => {
    var _mapRes$attributes, _mapRes$attributes2;
    const layersCountByType = buildLayerTypesCountObject();
    let layersFiltersCount = 0;
    const layerList = mapRes !== null && mapRes !== void 0 && (_mapRes$attributes = mapRes.attributes) !== null && _mapRes$attributes !== void 0 && _mapRes$attributes.layerList ? JSON.parse(mapRes === null || mapRes === void 0 || (_mapRes$attributes2 = mapRes.attributes) === null || _mapRes$attributes2 === void 0 ? void 0 : _mapRes$attributes2.layerList) : [];
    layerList.forEach(layer => {
      var _layer$source$filters, _layer$source;
      if (layer.type === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
        layersCountByType[layer.source.customType]++;
        totalLayersCountByType[layer.source.customType]++;
      } else {
        layersCountByType[layer.type]++;
        totalLayersCountByType[layer.type]++;
      }
      // @ts-ignore
      const layerFiltersCount = (_layer$source$filters = (_layer$source = layer.source) === null || _layer$source === void 0 || (_layer$source = _layer$source.filters) === null || _layer$source === void 0 ? void 0 : _layer$source.length) !== null && _layer$source$filters !== void 0 ? _layer$source$filters : 0;
      layersFiltersCount += layerFiltersCount;
      totalLayersFiltersCount += layerFiltersCount;
    });
    mapsList.push({
      id: mapRes === null || mapRes === void 0 ? void 0 : mapRes.id,
      layers_filters_total: layersFiltersCount,
      layers_total: {
        ...layersCountByType
      }
    });
  });
  return {
    maps_total: mapsSavedObjects.total,
    layers_filters_total: totalLayersFiltersCount,
    layers_total: {
      ...totalLayersCountByType
    },
    maps_list: mapsList
  };
};
exports.getStats = getStats;
const buildLayerTypesCountObject = () => {
  const layersCountByType = {};
  Object.values(_common.DASHBOARDS_MAPS_LAYER_TYPE).forEach(layerType => {
    if (layerType === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
      Object.values(_common.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE).forEach(customLayerType => {
        layersCountByType[customLayerType] = 0;
      });
    } else {
      layersCountByType[layerType] = 0;
    }
  });
  return layersCountByType;
};
const getMapSavedObjects = async (savedObjectsClient, perPage) => {
  const mapsSavedObjects = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
    type: _common.MAP_SAVED_OBJECT_TYPE,
    perPage
  }));
  // If there are more than perPage of maps, we need to make additional requests to get all maps.
  if (mapsSavedObjects.total > perPage) {
    const iterations = Math.ceil(mapsSavedObjects.total / perPage);
    for (let i = 1; i < iterations; i++) {
      const mapsSavedObjectsPage = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
        type: _common.MAP_SAVED_OBJECT_TYPE,
        perPage,
        page: i + 1
      }));
      mapsSavedObjects.saved_objects = [...mapsSavedObjects.saved_objects, ...mapsSavedObjectsPage.saved_objects];
    }
  }
  return mapsSavedObjects;
};
exports.getMapSavedObjects = getMapSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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