/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class VirtualThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    final ThreadFactory delegate;
    final @Nullable BiConsumer<Thread, Throwable> uncaughtExceptionHandler;

    VirtualThreadFactory(String name, boolean inheritThreadLocals, @Nullable BiConsumer<Thread, Throwable> uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.delegate = Thread.ofVirtual().name(name, 1L).uncaughtExceptionHandler(this).inheritInheritableThreadLocals(inheritThreadLocals).factory();
    }

    @Override
    public final Thread newThread(@NonNull Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.uncaughtExceptionHandler == null) {
            return;
        }
        this.uncaughtExceptionHandler.accept(t, e);
    }
}

