/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.X500RDN;
import oracle.security.pki.util.Utils;

public class CRLDistPointName
implements Externalizable,
ASN1Object {
    private ArrayList<GeneralName> a;
    private X500RDN b;
    private transient ASN1Object c;

    public CRLDistPointName() {
    }

    public CRLDistPointName(GeneralName generalName) {
        this.a = new ArrayList();
        this.a.add(generalName);
    }

    public CRLDistPointName(List<? extends GeneralName> list) {
        this.a = list == null ? null : new ArrayList<GeneralName>(list);
    }

    public CRLDistPointName(X500RDN x500RDN) {
        this.b = x500RDN;
    }

    public CRLDistPointName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void a(GeneralName generalName) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.add(generalName);
    }

    public ArrayList<GeneralName> a() {
        return this.a;
    }

    public X500RDN b() {
        return this.b;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        int n2 = ASN1Utils.d(n);
        if (n2 == 0) {
            pushbackInputStream.unread((n & 0x20) + 16);
            if (this.a == null) {
                this.a = new ArrayList();
            } else {
                this.a.clear();
            }
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(pushbackInputStream);
            while (aSN1SequenceInputStream.a()) {
                this.a.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.b();
            this.b = null;
        } else if (n2 == 1) {
            pushbackInputStream.unread((n & 0x20) + 17);
            this.a = null;
            this.b = new X500RDN(pushbackInputStream);
        }
        if ((this.a == null || this.a.size() == 0) && this.b == null) {
            throw new ASN1FormatException("No name elements found in CRLDistPointName");
        }
    }

    private ASN1Object c() {
        if (this.c == null) {
            this.c = this.a != null ? new ASN1GenericConstructed(this.a, 0) : ASN1Utils.a(this.b, 1);
        }
        return this.c;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    @Override
    public int length() {
        return this.c().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

