<?php
/**
 * @license GPL-2.0-or-later
 * @file
 */

use MediaWiki\Language\LanguageConverter;
use Wikimedia\ReplacementArray;

/**
 * Gan Chinese specific code.
 *
 * @ingroup Languages
 */
class GanConverter extends LanguageConverter {

	public function getMainCode(): string {
		return 'gan';
	}

	public function getLanguageVariants(): array {
		return [ 'gan', 'gan-hans', 'gan-hant' ];
	}

	public function getVariantsFallbacks(): array {
		return [
			'gan' => [ 'gan-hans', 'gan-hant' ],
			'gan-hans' => [ 'gan' ],
			'gan-hant' => [ 'gan' ],
		];
	}

	/**
	 * Get manual level limit for supported variants.
	 * @since 1.36
	 *
	 * @return array
	 */
	protected function getAdditionalManualLevel(): array {
		return [ 'gan' => 'disable' ];
	}

	public function getDescVarSeparator(): string {
		return '; ';
	}

	public function getVariantNames(): array {
		$names = [
			'gan' => '原文',
			'gan-hans' => '简体',
			'gan-hant' => '繁體',
		];
		return array_merge( parent::getVariantNames(), $names );
	}

	protected function loadDefaultTables(): array {
		return [
			'gan-hans' => new ReplacementArray( MediaWiki\Languages\Data\ZhConversion::ZH_TO_HANS ),
			'gan-hant' => new ReplacementArray( MediaWiki\Languages\Data\ZhConversion::ZH_TO_HANT ),
			'gan' => new ReplacementArray
		];
	}

	/** @inheritDoc */
	public function convertCategoryKey( $key ) {
		return $this->autoConvert( $key, 'gan' );
	}
}
