/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.infinispan.commons.util.AbstractImmutableIntSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

class OffsetIntSet
extends AbstractImmutableIntSet {
    private final int start;
    private final int end;

    OffsetIntSet(int start, int exclusiveEnd) {
        assert (exclusiveEnd >= start) : "End should be greater or equal than start";
        this.start = start;
        this.end = exclusiveEnd;
    }

    @Override
    public boolean contains(int i) {
        return i >= this.start && i < this.end;
    }

    @Override
    public boolean containsAll(IntSet set) {
        if (set instanceof OffsetIntSet) {
            OffsetIntSet other = (OffsetIntSet)set;
            return other.start >= this.start && other.end <= this.end;
        }
        PrimitiveIterator.OfInt it = set.iterator();
        while (it.hasNext()) {
            if (this.contains(it.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.intStream().iterator();
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.start + i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof IntSet) {
            return this.containsAll((IntSet)c);
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntStream intStream() {
        return IntStream.range(this.start, this.end);
    }

    @Override
    public byte[] toBitSet() {
        int size = this.size();
        if (size == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        BitSet bs = new BitSet();
        bs.flip(this.start, this.end);
        return bs.toByteArray();
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex <= this.start) {
            return this.start;
        }
        if (fromIndex >= this.end) {
            return -1;
        }
        return fromIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)obj;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "{" + this.start + "-" + this.end + "}";
    }
}

