/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.Build;
import org.keycloak.quarkus.runtime.cli.command.DryRunMixin;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public abstract class AbstractAutoBuildCommand
extends AbstractCommand {
    public static final String OPTIMIZED_BUILD_OPTION_LONG = "--optimized";
    public static final int FEATURE_DISABLED_EXIT_CODE = 4;
    public static final int REBUILT_EXIT_CODE = 10;
    @CommandLine.Mixin
    DryRunMixin dryRunMixin = new DryRunMixin();
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    protected Optional<Integer> callCommand() {
        if (Environment.isRebuildCheck()) {
            if (AbstractAutoBuildCommand.requiresReAugmentation()) {
                this.runReAugmentation();
                return Optional.of(10);
            }
            String profile = org.keycloak.common.util.Environment.getProfile();
            Environment.setRebuildCheck(false);
            String runtimeProfile = this.getInitProfile();
            if (!Objects.equals(profile, runtimeProfile)) {
                Environment.setProfile(runtimeProfile);
                Configuration.resetConfig();
            }
        }
        return Optional.empty();
    }

    static boolean requiresReAugmentation() {
        Map<String, String> rawPersistedProperties = Configuration.getRawPersistedProperties();
        if (rawPersistedProperties.isEmpty()) {
            return true;
        }
        Properties current = Picocli.getNonPersistedBuildTimeOptions();
        String key = "kc.optimized";
        Optional.ofNullable(rawPersistedProperties.get(key)).ifPresentOrElse(value -> current.put(key, value), () -> current.remove(key));
        return !rawPersistedProperties.equals(current);
    }

    private void runReAugmentation() {
        if (!Environment.isDevMode()) {
            this.spec.commandLine().getOut().println("Changes detected in configuration. Updating the server image.");
            if (Configuration.isOptimized()) {
                this.picocli.checkChangesInBuildOptionsDuringAutoBuild(this.spec.commandLine().getOut());
            }
        }
        this.directBuild();
        if (!Environment.isDevMode()) {
            this.spec.commandLine().getOut().printf("Next time you run the server, just run:%n%n\t%s %s %s%n%n", Environment.getCommand(), String.join((CharSequence)" ", AbstractAutoBuildCommand.getSanitizedRuntimeCliOptions()), OPTIMIZED_BUILD_OPTION_LONG);
        }
    }

    void directBuild() {
        Build build = new Build();
        build.dryRunMixin = this.dryRunMixin;
        build.setPicocli(this.picocli);
        build.spec = this.spec;
        build.runCommand();
    }

    private static List<String> getSanitizedRuntimeCliOptions() {
        ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(ConfigArgsConfigSource.getAllCliArgs(), (key, value) -> {
            PropertyMapper<?> mapper = PropertyMappers.getMapperByCliKey(key);
            if (mapper == null || mapper.isRunTime()) {
                properties.add(key + "=" + PropertyMappers.maskValue(value, mapper));
            }
        }, properties::add);
        return properties;
    }

    @Override
    protected void runCommand() {
        this.doBeforeRun();
        this.validateConfig();
        if (Environment.isDevProfile()) {
            this.picocli.getOutWriter().println(this.picocli.getColorMode().string("@|bold,red Running the server in development mode. DO NOT use this configuration in production.|@"));
        }
        if (this.shouldStart() && !Boolean.TRUE.equals(this.dryRunMixin.dryRun)) {
            this.picocli.start();
        }
    }

    protected void doBeforeRun() {
    }

    @Override
    public boolean isHelpAll() {
        return this.helpAllMixin != null ? this.helpAllMixin.allOptions : false;
    }

    protected abstract OptimizedMixin getOptimizedMixin();

    @Override
    public boolean isOptimized() {
        return Optional.ofNullable(this.getOptimizedMixin()).map(o -> o.optimized).orElse(false);
    }

    @Override
    public boolean shouldStart() {
        return true;
    }
}

