/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BytecodeLogging;
import org.hibernate.bytecode.enhance.spi.interceptor.AbstractInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementHelper;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class EnhancementAsProxyLazinessInterceptor
extends AbstractInterceptor
implements BytecodeLazyAttributeInterceptor {
    private final EntityKey entityKey;
    private final EntityRelatedState meta;
    private Set<String> writtenFieldNames;
    private Status status;

    public EnhancementAsProxyLazinessInterceptor(EntityRelatedState meta, EntityKey entityKey, SharedSessionContractImplementor session) {
        this.entityKey = entityKey;
        this.meta = meta;
        this.status = Status.UNINITIALIZED;
        this.setSession(session);
    }

    @Override
    public String getEntityName() {
        return this.meta.entityName;
    }

    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    protected Object handleRead(Object target, String attributeName, Object value) {
        if (this.isInitialized()) {
            throw new IllegalStateException("EnhancementAsProxyLazinessInterceptor interception on an initialized instance");
        }
        if (this.meta.identifierAttributeNames.contains(attributeName)) {
            return this.extractIdValue(target, attributeName);
        }
        return EnhancementHelper.performWork(this, (session, isTempSession) -> this.read(target, attributeName, (SharedSessionContractImplementor)session, (Boolean)isTempSession), this.getEntityName(), attributeName);
    }

    private Object read(Object target, String attributeName, SharedSessionContractImplementor session, Boolean isTempSession) {
        AttributeMapping[] writtenAttributeMappings;
        Object[] writtenAttributeValues;
        if (this.writtenFieldNames != null && !this.writtenFieldNames.isEmpty()) {
            EntityPersister entityPersister = this.meta.persister;
            if (this.writtenFieldNames.contains(attributeName)) {
                return entityPersister.getPropertyValue(target, attributeName);
            }
            writtenAttributeValues = new Object[this.writtenFieldNames.size()];
            writtenAttributeMappings = new AttributeMapping[this.writtenFieldNames.size()];
            int index = 0;
            for (String writtenFieldName : this.writtenFieldNames) {
                writtenAttributeMappings[index] = entityPersister.findAttributeMapping(writtenFieldName);
                writtenAttributeValues[index] = writtenAttributeMappings[index].getValue(target);
                ++index;
            }
        } else {
            writtenAttributeValues = null;
            writtenAttributeMappings = null;
        }
        Object initializedValue = this.forceInitialize(target, attributeName, session, isTempSession);
        this.setInitialized();
        if (writtenAttributeValues != null) {
            for (int i = 0; i < writtenAttributeMappings.length; ++i) {
                AttributeMapping attribute = writtenAttributeMappings[i];
                attribute.setValue(target, writtenAttributeValues[i]);
                if (!this.meta.inLineDirtyChecking) continue;
                ManagedTypeHelper.asSelfDirtinessTracker(target).$$_hibernate_trackChange(attribute.getAttributeName());
            }
            this.writtenFieldNames.clear();
        }
        return initializedValue;
    }

    private Object extractIdValue(Object target, String attributeName) {
        CompositeType nonAggregatedCidMapper = this.meta.nonAggregatedCidMapper;
        if (nonAggregatedCidMapper == null) {
            return this.getIdentifier();
        }
        return nonAggregatedCidMapper.getPropertyValue(target, nonAggregatedCidMapper.getPropertyIndex(attributeName), this.getLinkedSession());
    }

    public Object forceInitialize(Object target, String attributeName) {
        if (BytecodeLogging.LOGGER.isTraceEnabled()) {
            BytecodeLogging.LOGGER.tracef("EnhancementAsProxyLazinessInterceptor#forceInitialize : %s#%s -> %s )", (Object)this.entityKey.getEntityName(), this.entityKey.getIdentifier(), (Object)attributeName);
        }
        return EnhancementHelper.performWork(this, (session, isTemporarySession) -> this.forceInitialize(target, attributeName, (SharedSessionContractImplementor)session, (boolean)isTemporarySession), this.getEntityName(), attributeName);
    }

    public Object forceInitialize(Object target, String attributeName, SharedSessionContractImplementor session, boolean isTemporarySession) {
        if (BytecodeLogging.LOGGER.isTraceEnabled()) {
            BytecodeLogging.LOGGER.tracef("EnhancementAsProxyLazinessInterceptor#forceInitialize : %s#%s -> %s )", (Object)this.entityKey.getEntityName(), this.entityKey.getIdentifier(), (Object)attributeName);
        }
        if (isTemporarySession) {
            session.getPersistenceContext().addEnhancedProxy(this.entityKey, ManagedTypeHelper.asPersistentAttributeInterceptable(target));
        }
        return this.meta.persister.initializeEnhancedEntityUsedAsProxy(target, attributeName, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object handleWrite(Object target, String attributeName, Object oldValue, Object newValue) {
        if (this.isInitialized()) {
            throw new IllegalStateException("EnhancementAsProxyLazinessInterceptor interception on an initialized instance");
        }
        if (this.meta.identifierAttributeNames.contains(attributeName)) {
            boolean changed;
            if (this.meta.nonAggregatedCidMapper == null) {
                changed = !this.entityKey.getPersister().getIdentifierType().isEqual(oldValue, newValue);
            } else {
                int subAttrIndex = this.meta.nonAggregatedCidMapper.getPropertyIndex(attributeName);
                Type subAttrType = this.meta.nonAggregatedCidMapper.getSubtypes()[subAttrIndex];
                boolean bl = changed = !subAttrType.isEqual(oldValue, newValue);
            }
            if (changed) {
                throw new HibernateException("identifier of an instance of " + this.entityKey.getEntityName() + " was altered from " + String.valueOf(oldValue) + " to " + String.valueOf(newValue));
            }
            return newValue;
        }
        if (this.meta.initializeBeforeWrite || this.meta.collectionAttributeNames != null && this.meta.collectionAttributeNames.contains(attributeName)) {
            try {
                this.forceInitialize(target, attributeName);
            }
            finally {
                this.setInitialized();
            }
            if (this.meta.inLineDirtyChecking) {
                ManagedTypeHelper.asSelfDirtinessTracker(target).$$_hibernate_trackChange(attributeName);
            }
        } else {
            if (this.writtenFieldNames == null) {
                this.writtenFieldNames = new HashSet<String>();
            }
            this.writtenFieldNames.add(attributeName);
            ManagedTypeHelper.asSelfDirtinessTracker(target).$$_hibernate_trackChange(attributeName);
        }
        return newValue;
    }

    @Override
    public Set<String> getInitializedLazyAttributeNames() {
        return Collections.emptySet();
    }

    @Override
    public void attributeInitialized(String name) {
        if (this.status == Status.INITIALIZED) {
            throw new UnsupportedOperationException("Expected call to EnhancementAsProxyLazinessInterceptor#attributeInitialized");
        }
    }

    @Override
    public boolean isAttributeLoaded(String fieldName) {
        if (this.isInitialized()) {
            throw new UnsupportedOperationException("Call to EnhancementAsProxyLazinessInterceptor#isAttributeLoaded on an interceptor which is marked as initialized");
        }
        return this.meta.identifierAttributeNames.contains(fieldName);
    }

    @Override
    public boolean hasAnyUninitializedAttributes() {
        if (this.isInitialized()) {
            throw new UnsupportedOperationException("Call to EnhancementAsProxyLazinessInterceptor#hasAnyUninitializedAttributes on an interceptor which is marked as initialized");
        }
        return true;
    }

    @Override
    public Object getIdentifier() {
        return this.entityKey.getIdentifier();
    }

    public boolean isInitializing() {
        return this.status == Status.INITIALIZING;
    }

    public void setInitializing() {
        this.status = Status.INITIALIZING;
    }

    public boolean isInitialized() {
        return this.status == Status.INITIALIZED;
    }

    private void setInitialized() {
        this.status = Status.INITIALIZED;
    }

    public boolean hasWrittenFieldNames() {
        return this.writtenFieldNames != null && !this.writtenFieldNames.isEmpty();
    }

    protected boolean isIdentifier(String attributeName) {
        return this.meta.identifierAttributeNames.contains(attributeName);
    }

    public static class EntityRelatedState {
        private final String entityName;
        private final CompositeType nonAggregatedCidMapper;
        private final Set<String> identifierAttributeNames;
        private final Set<String> collectionAttributeNames;
        private final boolean initializeBeforeWrite;
        private final boolean inLineDirtyChecking;
        private final EntityPersister persister;

        public EntityRelatedState(EntityPersister persister, CompositeType nonAggregatedCidMapper, Set<String> identifierAttributeNames) {
            this.identifierAttributeNames = identifierAttributeNames;
            this.entityName = persister.getEntityName();
            this.nonAggregatedCidMapper = nonAggregatedCidMapper;
            this.persister = persister;
            assert (nonAggregatedCidMapper != null || identifierAttributeNames.size() == 1);
            if (persister.hasCollections()) {
                HashSet<String> tmpCollectionAttributeNames = new HashSet<String>();
                Type[] propertyTypes = persister.getPropertyTypes();
                String[] propertyNames = persister.getPropertyNames();
                for (int i = 0; i < propertyTypes.length; ++i) {
                    Type propertyType = propertyTypes[i];
                    if (!(propertyType instanceof CollectionType)) continue;
                    tmpCollectionAttributeNames.add(propertyNames[i]);
                }
                this.collectionAttributeNames = CollectionHelper.toSmallSet(Collections.unmodifiableSet(tmpCollectionAttributeNames));
            } else {
                this.collectionAttributeNames = Collections.emptySet();
            }
            this.inLineDirtyChecking = ManagedTypeHelper.isSelfDirtinessTrackerType(persister.getMappedClass());
            this.initializeBeforeWrite = !this.inLineDirtyChecking || !persister.getEntityMetamodel().isDynamicUpdate() || persister.isVersioned();
        }
    }

    private static enum Status {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

