/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.internal.CaseStatementDiscriminatorMappingImpl;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.model.ast.ColumnWriteFragment;

public class TableGroupHelper
extends AbstractSqlAstWalker {
    public static final int REAL_TABLE_GROUP_REQUIRED = Integer.MAX_VALUE;
    public static final int NO_TABLE_GROUP_REQUIRED = -1;
    private final String primaryQualifier;
    private final Map<String, Integer> qualifiers;
    private final String[] qualifierFragments;
    private Integer usedTableReferenceJoinIndex;

    private TableGroupHelper(String primaryQualifier, Map<String, Integer> qualifiers) {
        this.primaryQualifier = primaryQualifier;
        this.qualifiers = qualifiers;
        String[] qualifierFragments = new String[qualifiers.size()];
        for (Map.Entry<String, Integer> entry : qualifiers.entrySet()) {
            qualifierFragments[entry.getValue().intValue()] = entry.getKey() + ".";
        }
        this.qualifierFragments = qualifierFragments;
    }

    public static int findReferenceJoinForPredicateSwap(TableGroup tableGroup, Predicate predicate) {
        if (predicate != null && !tableGroup.getTableReferenceJoins().isEmpty()) {
            TableReference primaryTableReference = tableGroup.getPrimaryTableReference();
            HashMap<String, Integer> qualifiers = CollectionHelper.mapOfSize(tableGroup.getTableReferenceJoins().size());
            List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
            for (int i = 0; i < tableReferenceJoins.size(); ++i) {
                TableReferenceJoin tableReferenceJoin = tableReferenceJoins.get(i);
                if (!tableGroup.canUseInnerJoins() && !TableGroupHelper.isSimplePredicate(tableGroup, i)) {
                    return Integer.MAX_VALUE;
                }
                qualifiers.put(tableReferenceJoin.getJoinedTableReference().getIdentificationVariable(), i);
            }
            TableGroupHelper qualifierCollector = new TableGroupHelper(primaryTableReference.getIdentificationVariable(), qualifiers);
            try {
                predicate.accept(qualifierCollector);
                if (qualifierCollector.usedTableReferenceJoinIndex == null) {
                    return -1;
                }
                if (qualifierCollector.usedTableReferenceJoinIndex != -1 && !tableGroup.canUseInnerJoins() && !TableGroupHelper.isSimpleTableReference(primaryTableReference)) {
                    return Integer.MAX_VALUE;
                }
                return qualifierCollector.usedTableReferenceJoinIndex;
            }
            catch (MultipleUsesFoundException ex) {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    private static boolean isSimpleTableReference(TableReference tableReference) {
        return tableReference instanceof NamedTableReference && !tableReference.getTableId().startsWith("(select");
    }

    private static boolean isSimplePredicate(TableGroup tableGroup, int index) {
        TableReference primaryTableReference = tableGroup.getPrimaryTableReference();
        TableReferenceJoin tableReferenceJoin = tableGroup.getTableReferenceJoins().get(index);
        NamedTableReference joinedTableReference = tableReferenceJoin.getJoinedTableReference();
        Predicate predicate = tableReferenceJoin.getPredicate();
        if (predicate instanceof Junction) {
            Junction junction = (Junction)predicate;
            if (junction.getNature() == Junction.Nature.CONJUNCTION) {
                for (Predicate subPredicate : junction.getPredicates()) {
                    if (TableGroupHelper.isComparison(subPredicate, primaryTableReference, joinedTableReference)) continue;
                    return false;
                }
                return true;
            }
        } else {
            return TableGroupHelper.isComparison(predicate, primaryTableReference, joinedTableReference);
        }
        return false;
    }

    private static boolean isComparison(Predicate predicate, TableReference table1, TableReference table2) {
        if (predicate instanceof ComparisonPredicate) {
            SqlTupleContainer tupleContainer;
            SqlTuple lhsTuple;
            ComparisonPredicate comparisonPredicate = (ComparisonPredicate)predicate;
            Expression lhs = comparisonPredicate.getLeftHandExpression();
            Expression rhs = comparisonPredicate.getRightHandExpression();
            if (lhs instanceof SqlTupleContainer && (lhsTuple = (tupleContainer = (SqlTupleContainer)((Object)lhs)).getSqlTuple()) != null) {
                SqlTuple rhsTuple = ((SqlTupleContainer)((Object)rhs)).getSqlTuple();
                List<? extends Expression> lhsExpressions = lhsTuple.getExpressions();
                List<? extends Expression> rhsExpressions = rhsTuple.getExpressions();
                for (int i = 0; i < lhsExpressions.size(); ++i) {
                    ColumnReference rhsColumn;
                    ColumnReference lhsColumn = lhsExpressions.get(i).getColumnReference();
                    if (TableGroupHelper.isComparison(table1, table2, lhsColumn, rhsColumn = rhsExpressions.get(i).getColumnReference())) continue;
                    return false;
                }
                return true;
            }
            return TableGroupHelper.isComparison(table1, table2, lhs.getColumnReference(), rhs.getColumnReference());
        }
        return false;
    }

    private static boolean isComparison(TableReference table1, TableReference table2, ColumnReference column1, ColumnReference column2) {
        if (column1 != null && column2 != null) {
            String column1Qualifier = column1.getQualifier();
            String column2Qualifier = column2.getQualifier();
            String table1Qualifier = table1.getIdentificationVariable();
            String table2Qualifier = table2.getIdentificationVariable();
            return column1Qualifier.equals(table1Qualifier) && column2Qualifier.equals(table2Qualifier) || column1Qualifier.equals(table2Qualifier) && column2Qualifier.equals(table1Qualifier);
        }
        return false;
    }

    private void checkQualifier(String qualifier) {
        if (this.primaryQualifier.equals(qualifier)) {
            if (this.usedTableReferenceJoinIndex != null && this.usedTableReferenceJoinIndex != -1) {
                throw new MultipleUsesFoundException();
            }
            this.usedTableReferenceJoinIndex = -1;
        } else {
            Integer index = this.qualifiers.get(qualifier);
            if (index != null) {
                if (this.usedTableReferenceJoinIndex != null && this.usedTableReferenceJoinIndex.intValue() != index.intValue()) {
                    throw new MultipleUsesFoundException();
                }
                this.usedTableReferenceJoinIndex = index;
            }
        }
    }

    private void checkSql(String sql) {
        if (sql.contains(this.primaryQualifier + ".")) {
            if (this.usedTableReferenceJoinIndex != null && this.usedTableReferenceJoinIndex != -1) {
                throw new MultipleUsesFoundException();
            }
            this.usedTableReferenceJoinIndex = -1;
        } else {
            for (int i = 0; i < this.qualifierFragments.length; ++i) {
                if (!sql.contains(this.qualifierFragments[i])) continue;
                if (this.usedTableReferenceJoinIndex != null && this.usedTableReferenceJoinIndex != i) {
                    throw new MultipleUsesFoundException();
                }
                this.usedTableReferenceJoinIndex = i;
            }
        }
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        if (expression instanceof SelfRenderingSqlFragmentExpression) {
            SelfRenderingSqlFragmentExpression selfRenderingSqlFragmentExpression = (SelfRenderingSqlFragmentExpression)expression;
            this.checkSql(selfRenderingSqlFragmentExpression.getExpression());
        } else if (expression instanceof CaseStatementDiscriminatorMappingImpl.CaseStatementDiscriminatorExpression) {
            CaseStatementDiscriminatorMappingImpl.CaseStatementDiscriminatorExpression caseStatementDiscriminatorExpression = (CaseStatementDiscriminatorMappingImpl.CaseStatementDiscriminatorExpression)expression;
            for (TableReference usedTableReference : caseStatementDiscriminatorExpression.getUsedTableReferences()) {
                usedTableReference.accept(this);
            }
        } else {
            super.visitSelfRenderingExpression(expression);
        }
    }

    @Override
    public void visitNamedTableReference(NamedTableReference tableReference) {
        this.checkQualifier(tableReference.getIdentificationVariable());
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        this.checkQualifier(columnReference.getQualifier());
    }

    @Override
    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        this.checkQualifier(aggregateColumnWriteExpression.getAggregateColumnReference().getQualifier());
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        for (FilterPredicate.FilterFragmentPredicate fragment : filterPredicate.getFragments()) {
            this.visitFilterFragmentPredicate(fragment);
        }
    }

    @Override
    public void visitFilterFragmentPredicate(FilterPredicate.FilterFragmentPredicate fragmentPredicate) {
        this.checkSql(fragmentPredicate.getSqlFragment());
    }

    @Override
    public void visitSqlFragmentPredicate(SqlFragmentPredicate predicate) {
        this.checkSql(predicate.getSqlFragment());
    }

    @Override
    public void visitColumnWriteFragment(ColumnWriteFragment columnWriteFragment) {
        this.checkSql(columnWriteFragment.getFragment());
    }

    private static class MultipleUsesFoundException
    extends RuntimeException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

