/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

public class SubscriptionCount {
    public final int byNameCount;
    public final int byRegexCount;

    public SubscriptionCount(int byNameCount, int byRegexCount) {
        this.byNameCount = byNameCount;
        this.byRegexCount = byRegexCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionCount that = (SubscriptionCount)o;
        if (this.byNameCount != that.byNameCount) {
            return false;
        }
        return this.byRegexCount == that.byRegexCount;
    }

    public int hashCode() {
        int result = this.byNameCount;
        result = 31 * result + this.byRegexCount;
        return result;
    }

    public String toString() {
        return "SubscriptionCount(byNameCount=" + this.byNameCount + ", byRegexCount=" + this.byRegexCount + ")";
    }

    public static SubscriptionCount incNameCount(String key, SubscriptionCount count) {
        if (count == null) {
            return new SubscriptionCount(1, 0);
        }
        return new SubscriptionCount(count.byNameCount + 1, count.byRegexCount);
    }

    public static SubscriptionCount decNameCount(String key, SubscriptionCount count) {
        if (count == null || count.byNameCount == 1 && count.byRegexCount == 0) {
            return null;
        }
        return new SubscriptionCount(count.byNameCount - 1, count.byRegexCount);
    }

    public static SubscriptionCount incRegexCount(String key, SubscriptionCount count) {
        if (count == null) {
            return new SubscriptionCount(0, 1);
        }
        return new SubscriptionCount(count.byNameCount, count.byRegexCount + 1);
    }

    public static SubscriptionCount decRegexCount(String key, SubscriptionCount count) {
        if (count == null || count.byRegexCount == 1 && count.byNameCount == 0) {
            return null;
        }
        return new SubscriptionCount(count.byNameCount, count.byRegexCount - 1);
    }
}

