/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.tools.Utils;

public class ArrowPaintHelper {
    private final double sin;
    private final double cos;
    private final double length;

    public ArrowPaintHelper(double radians, double length) {
        this.sin = Math.sin(radians);
        this.cos = Math.cos(radians);
        this.length = length;
    }

    public void paintArrowAt(MapPath2D path, MapViewState.MapViewPoint point, MapViewState.MapViewPoint fromDirection) {
        double dy;
        double x = point.getInViewX();
        double y = point.getInViewY();
        double dx = fromDirection.getInViewX() - x;
        double norm = Math.sqrt(dx * dx + (dy = fromDirection.getInViewY() - y) * dy);
        if (norm > 1.0E-10) {
            path.moveTo(x + (dx *= this.length / norm) * this.cos + (dy *= this.length / norm) * this.sin, y + dx * -this.sin + dy * this.cos);
            if (!Utils.equalsEpsilon(this.cos, 0.0)) {
                path.lineTo(point);
            }
            path.lineTo(x + dx * this.cos + dy * -this.sin, y + dx * this.sin + dy * this.cos);
        }
    }

    public double getOnLineLength() {
        return this.length * this.cos;
    }
}

