import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { uniqueId } from 'lodash';
import { useCallback } from 'react';
import { toOption } from '@grafana/data';
import { useStyles2, Select, Button } from '@grafana/ui';
import { EditorField } from '../EditorField.js';
import { QueryEditorExpressionType } from '../expressions.js';
import '../types.js';
import { createFunctionField } from '../utils/sql.utils.js';
import { EditorStack } from '../EditorStack.js';

const asteriskValue = { label: "*", value: "*" };
function SelectRow({ sql, columns, onSqlChange, functions }) {
  var _a;
  const styles = useStyles2(getStyles);
  const columnsWithAsterisk = [asteriskValue, ...columns || []];
  const onColumnChange = useCallback(
    (item, index) => (column) => {
      var _a2, _b;
      let modifiedItem = { ...item };
      if (!((_a2 = item.parameters) == null ? undefined : _a2.length)) {
        modifiedItem.parameters = [{ type: QueryEditorExpressionType.FunctionParameter, name: column.value }];
      } else {
        modifiedItem.parameters = item.parameters.map(
          (p) => p.type === QueryEditorExpressionType.FunctionParameter ? { ...p, name: column.value } : p
        );
      }
      const newSql = {
        ...sql,
        columns: (_b = sql.columns) == null ? undefined : _b.map((c, i) => i === index ? modifiedItem : c)
      };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const onAggregationChange = useCallback(
    (item, index) => (aggregation) => {
      var _a2;
      const newItem = {
        ...item,
        name: aggregation == null ? undefined : aggregation.value
      };
      const newSql = {
        ...sql,
        columns: (_a2 = sql.columns) == null ? undefined : _a2.map((c, i) => i === index ? newItem : c)
      };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const removeColumn = useCallback(
    (index) => () => {
      const clone = [...sql.columns];
      clone.splice(index, 1);
      const newSql = {
        ...sql,
        columns: clone
      };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const addColumn = useCallback(() => {
    const newSql = { ...sql, columns: [...sql.columns, createFunctionField()] };
    onSqlChange(newSql);
  }, [onSqlChange, sql]);
  return /* @__PURE__ */ jsxs(EditorStack, { gap: 2, alignItems: "end", direction: "column", children: [
    (_a = sql.columns) == null ? undefined : _a.map((item, index) => /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsxs(EditorStack, { gap: 2, alignItems: "end", children: [
      /* @__PURE__ */ jsx(EditorField, { label: "Column", width: 25, children: /* @__PURE__ */ jsx(
        Select,
        {
          value: getColumnValue(item),
          options: columnsWithAsterisk,
          inputId: `select-column-${index}-${uniqueId()}`,
          menuShouldPortal: true,
          allowCustomValue: true,
          onChange: onColumnChange(item, index)
        }
      ) }),
      /* @__PURE__ */ jsx(EditorField, { label: "Aggregation", optional: true, width: 25, children: /* @__PURE__ */ jsx(
        Select,
        {
          value: item.name ? toOption(item.name) : null,
          inputId: `select-aggregation-${index}-${uniqueId()}`,
          isClearable: true,
          menuShouldPortal: true,
          allowCustomValue: true,
          options: functions,
          onChange: onAggregationChange(item, index)
        }
      ) }),
      /* @__PURE__ */ jsx(
        Button,
        {
          "aria-label": "Remove",
          type: "button",
          icon: "trash-alt",
          variant: "secondary",
          size: "md",
          onClick: removeColumn(index)
        }
      )
    ] }) }, index)),
    /* @__PURE__ */ jsx(
      Button,
      {
        type: "button",
        onClick: addColumn,
        variant: "secondary",
        size: "md",
        icon: "plus",
        "aria-label": "Add",
        className: styles.addButton
      }
    )
  ] });
}
const getStyles = () => {
  return { addButton: css({ alignSelf: "flex-start" }) };
};
function getColumnValue({ parameters }) {
  const column = parameters == null ? undefined : parameters.find((p) => p.type === QueryEditorExpressionType.FunctionParameter);
  if (column == null ? undefined : column.name) {
    return toOption(column.name);
  }
  return null;
}

export { SelectRow };
//# sourceMappingURL=SelectRow.js.map
