/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.session.SessionContext;

@FunctionalInterface
public interface PublicKeyEntryResolver {
    public static final PublicKeyEntryResolver IGNORING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
            return null;
        }

        public String toString() {
            return "IGNORING";
        }
    };
    public static final PublicKeyEntryResolver FAILING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
            throw new InvalidKeySpecException("Failing resolver on key type=" + keyType);
        }

        public String toString() {
            return "FAILING";
        }
    };
    public static final PublicKeyEntryResolver UNSUPPORTED = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
            return new UnsupportedSshPublicKey(keyType, keyData);
        }

        public String toString() {
            return "UNSUPPORTED";
        }
    };

    public PublicKey resolve(SessionContext var1, String var2, byte[] var3, Map<String, String> var4) throws IOException, GeneralSecurityException;
}

