/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class ConstantPool {
    public static final int PRIMITIVE = 0;
    public static final int STRING_LITERAL = 1;
    public static final int CLASS_REFERENCE = 2;
    public static final int POINTER_METHOD = 3;
    public static final int POINTER_FIELD = 4;
    public static final int ARRAY_LENGTH = 5;
    public static final int INSTANCE_OF = 6;
    public static final int CHECK_CAST = 7;

    public abstract Record getRecord(long[] var1);

    public static class Record {
        public int tag;
        public String token;
        public long value;
        public byte[] byteData;
        public DataType type;
        public boolean isConstructor = false;

        public void encode(Encoder encoder, long ref, PcodeDataTypeManager dtmanage) throws IOException {
            encoder.openElement(ElementId.ELEM_CPOOLREC);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_REF, ref);
            if (this.tag == 1) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "string");
            } else if (this.tag == 2) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "classref");
            } else if (this.tag == 3) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "method");
            } else if (this.tag == 4) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "field");
            } else if (this.tag == 5) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "arraylength");
            } else if (this.tag == 6) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "instanceof");
            } else if (this.tag == 7) {
                encoder.writeString(AttributeId.ATTRIB_TAG, "checkcast");
            } else {
                encoder.writeString(AttributeId.ATTRIB_TAG, "primitive");
            }
            if (this.isConstructor) {
                encoder.writeBool(AttributeId.ATTRIB_CONSTRUCTOR, true);
            }
            if (this.tag == 0) {
                encoder.openElement(ElementId.ELEM_VALUE);
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_CONTENT, this.value);
                encoder.closeElement(ElementId.ELEM_VALUE);
            }
            if (this.byteData != null) {
                encoder.openElement(ElementId.ELEM_DATA);
                encoder.writeSignedInteger(AttributeId.ATTRIB_LENGTH, this.byteData.length);
                StringBuilder buf = new StringBuilder();
                int wrap = 0;
                for (byte val : this.byteData) {
                    int hival = val >> 4 & 0xF;
                    char hi = (char)(hival > 9 ? hival - 10 + 97 : hival + 48);
                    int loval = val & 0xF;
                    char lo = (char)(loval > 9 ? loval - 10 + 97 : loval + 48);
                    buf.append(hi).append(lo).append(' ');
                    if (++wrap <= 15) continue;
                    buf.append('\n');
                    wrap = 0;
                }
                encoder.writeString(AttributeId.ATTRIB_CONTENT, buf.toString());
                encoder.closeElement(ElementId.ELEM_DATA);
            } else {
                encoder.openElement(ElementId.ELEM_TOKEN);
                encoder.writeString(AttributeId.ATTRIB_CONTENT, this.token);
                encoder.closeElement(ElementId.ELEM_TOKEN);
            }
            dtmanage.encodeTypeRef(encoder, this.type, this.type.getLength());
            encoder.closeElement(ElementId.ELEM_CPOOLREC);
        }

        public void setUTF8Data(String val) {
            this.byteData = val.getBytes(Charset.forName("UTF-8"));
        }
    }
}

