/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.MDVoidDataType;
import mdemangler.datatype.extended.MDArrayReferencedType;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.datatype.modifier.MDManagedProperty;
import mdemangler.functiontype.MDFunctionType;

public abstract class MDModifierType
extends MDDataType {
    public static final char SPACE = ' ';
    private static final String CONST = "const";
    private static final String VOLATILE = "volatile";
    private boolean isConst;
    private boolean isVolatile;
    protected MDManagedProperty managedProperty = null;
    protected MDCVMod cvMod = null;
    protected Boolean hasCVMod = true;
    protected MDType refType;

    public MDModifierType(MDMang dmang) {
        super(dmang, "");
        this.cvMod = new MDCVMod(dmang);
        this.cvMod.setQuestionType();
    }

    public MDModifierType(MDMang dmang, int startIndexOffset) {
        super(dmang, "", startIndexOffset);
        this.cvMod = new MDCVMod(dmang);
        this.cvMod.setQuestionType();
    }

    public MDModifierType(MDMang dmang, String typeName) {
        super(dmang, typeName);
        this.cvMod = new MDCVMod(dmang);
        this.cvMod.setQuestionType();
    }

    public MDType getReferencedType() {
        return this.refType;
    }

    public MDCVMod getCVMod() {
        return this.cvMod;
    }

    public void setConst(boolean isConst) {
        this.isConst = isConst;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isPointer64() {
        return this.cvMod.isPointer64();
    }

    public boolean isRestrict() {
        return this.cvMod.isRestricted();
    }

    public boolean isUnaligned() {
        return this.cvMod.isUnaligned();
    }

    public String getBasedName() {
        return this.cvMod.getBasedName();
    }

    public String getMemberScope() {
        return this.cvMod.getMemberScope();
    }

    protected MDDataType parseReferencedType() throws MDException {
        return MDDataTypeParser.parseBasicDataType(this.dmang, false);
    }

    @Override
    protected void parseInternal() throws MDException {
        this.cvMod.parse();
        if (this.cvMod.isFunction()) {
            MDFunctionType ft = new MDFunctionType(this.dmang);
            ft.setThisPointerCVMod(this.cvMod.getThisPointerMDCVMod());
            this.refType = ft;
            this.refType.parse();
        } else {
            this.refType = this.dmang.peek() == 'Y' ? new MDArrayReferencedType(this.dmang) : this.parseReferencedType();
            this.refType.parse();
        }
    }

    protected void insertCVMod(StringBuilder builder) {
        this.cvMod.insert(builder);
        this.dmang.cleanOutput(builder);
    }

    protected void insertReferredType(StringBuilder builder) {
        this.refType.insert(builder);
    }

    @Override
    public void insert(StringBuilder builder) {
        if (!this.cvMod.isCLIArray()) {
            if (this.isVolatile) {
                this.dmang.insertSpacedString(builder, VOLATILE);
            }
            if (this.isConst) {
                this.dmang.insertSpacedString(builder, CONST);
            }
        }
        if (this.refType instanceof MDFunctionType && (this.cvMod.isPointerType() || this.cvMod.isFunctionPointerType() || this.cvMod.isReferenceType() || this.cvMod.isFunctionReferenceType() || this.cvMod.isArrayType() || builder.length() > 0)) {
            ((MDFunctionType)this.refType).setFromModifier();
        }
        this.insertCVMod(builder);
        if (this.refType instanceof MDArrayReferencedType) {
            this.insertReferredType(builder);
        } else if (this.cvMod.isPinPointer()) {
            StringBuilder refBuilder = new StringBuilder();
            this.insertReferredType(refBuilder);
            this.dmang.appendString(refBuilder, " ");
            if (!(this.cvMod.isQuestionType() || this.cvMod.isPointerType() && this.refType instanceof MDVoidDataType)) {
                this.cvMod.insertManagedPropertiesPrefix(refBuilder);
                this.dmang.insertManagedPropertiesSuffix(refBuilder, this.cvMod);
            }
            this.dmang.insertString(builder, refBuilder.toString());
        } else if (this.cvMod.isCLIArray()) {
            StringBuilder refBuilder = new StringBuilder();
            this.insertReferredType(refBuilder);
            if (!(this.refType instanceof MDVoidDataType)) {
                this.cvMod.insertManagedPropertiesPrefix(refBuilder);
            }
            this.cvMod.insertManagedPropertiesSuffix(refBuilder);
            this.dmang.insertCLIArrayRefSuffix(builder, refBuilder);
        } else {
            this.insertReferredType(builder);
        }
    }
}

