/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.html;

import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HTMLElement
extends ArrayList<Object> {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();

    public HTMLElement(String name) {
        this.name = name;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public String removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public HTMLElement addElement(String elementName) {
        HTMLElement newElement = new HTMLElement(elementName);
        this.add(newElement);
        return newElement;
    }

    public void addHTMLContent(String htmlContent) {
        HTMLContent html = new HTMLContent(this, htmlContent);
        this.add(html);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<" + this.name);
        for (Map.Entry<String, String> ent : this.attributes.entrySet()) {
            sb.append(" ");
            sb.append(ent.getKey());
            sb.append("=\"");
            sb.append(ent.getValue());
            sb.append("\"");
        }
        sb.append(">");
        for (Map.Entry<String, String> obj : this) {
            if (obj == null) {
                sb.append("(null)");
                continue;
            }
            if (obj instanceof HTMLElement) {
                sb.append(obj.toString());
                continue;
            }
            if (obj instanceof HTMLContent) {
                sb.append(obj.toString());
                continue;
            }
            sb.append(HTMLUtilities.friendlyEncodeHTML(obj.toString()));
        }
        sb.append("</" + this.name + ">");
        return sb.toString();
    }

    private class HTMLContent {
        private String content;

        HTMLContent(HTMLElement hTMLElement, String content) {
            this.content = content;
        }

        public String toString() {
            return this.content;
        }
    }
}

