/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.bytesource;

import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.ProgramSearchRegion;
import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.List;

public class ProgramByteSource
implements AddressableByteSource {
    private Memory memory;

    public ProgramByteSource(Program program) {
        this.memory = program.getMemory();
    }

    @Override
    public int getBytes(Address address, byte[] bytes, int length) {
        try {
            return this.memory.getBytes(address, bytes, 0, length);
        }
        catch (MemoryAccessException e) {
            return 0;
        }
    }

    @Override
    public List<SearchRegion> getSearchableRegions() {
        return ProgramSearchRegion.ALL;
    }

    @Override
    public void invalidate() {
    }
}

