/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFileUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class OatDexFile_Nougat
extends OatDexFile {
    protected int dex_file_location_;
    protected String canonical_dex_file_location_;
    protected int dex_file_location_checksum_;
    protected int dex_file_pointer_;
    protected int lookup_table_data_;
    protected int oat_class_offsets_pointer_;
    protected DexHeader dexHeader;

    OatDexFile_Nougat(BinaryReader reader) throws IOException {
        this.dex_file_location_ = reader.readNextInt();
        this.canonical_dex_file_location_ = reader.readNextAsciiString(this.dex_file_location_);
        this.dex_file_location_checksum_ = reader.readNextInt();
        this.dex_file_pointer_ = reader.readNextInt();
        this.lookup_table_data_ = reader.readNextInt();
        this.oat_class_offsets_pointer_ = reader.readNextInt();
        if (!this.isDexHeaderExternal()) {
            ByteProvider provider = reader.getByteProvider();
            ByteProviderWrapper tmpProvider = new ByteProviderWrapper(provider, (long)this.dex_file_pointer_, provider.length() - (long)this.dex_file_pointer_);
            BinaryReader tmpReader = new BinaryReader((ByteProvider)tmpProvider, reader.isLittleEndian());
            this.dexHeader = DexHeaderFactory.getDexHeader(tmpReader);
        }
    }

    @Override
    public int getDexFileChecksum() {
        return this.dex_file_location_checksum_;
    }

    @Override
    public DexHeader getDexHeader() {
        return this.dexHeader;
    }

    @Override
    public int getDexFileOffset() {
        return this.dex_file_pointer_;
    }

    @Override
    public String getDexFileLocation() {
        return this.canonical_dex_file_location_;
    }

    public int getLookupTableData() {
        return this.lookup_table_data_;
    }

    public int getOatClassOffsetsPointer() {
        return this.oat_class_offsets_pointer_;
    }

    @Override
    public boolean isDexHeaderExternal() {
        return false;
    }

    @Override
    public void markup(OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Address address = oatDataSymbol.getAddress();
        Listing listing = program.getListing();
        ReferenceManager referenceManager = program.getReferenceManager();
        SymbolTable symbolTable = program.getSymbolTable();
        Data oatHeaderData = listing.getDefinedDataAt(address);
        if (oatHeaderData == null || !oatHeaderData.getDataType().getName().startsWith("OatHeader")) {
            return;
        }
        block0: for (int i = 0; i < oatHeaderData.getNumComponents(); ++i) {
            monitor.checkCancelled();
            Data componentI = oatHeaderData.getComponent(i);
            if (!componentI.getFieldName().startsWith(OatDexFile.PREFIX)) continue;
            for (int j = 0; j < componentI.getNumComponents(); ++j) {
                monitor.checkCancelled();
                Data componentJ = componentI.getComponent(j);
                if (componentJ.getFieldName().startsWith("canonical_dex_file_location_") && !this.canonical_dex_file_location_.equals(componentJ.getValue())) continue block0;
                if (!componentJ.getFieldName().startsWith("oat_class_offsets_pointer_") && !componentJ.getFieldName().startsWith("lookup_table_data_") && !componentJ.getFieldName().startsWith("oat_class_offsets_pointer_")) continue;
                Scalar scalar = componentJ.getScalar(0);
                Address destinationAddress = address.add(scalar.getUnsignedValue());
                referenceManager.addMemoryReference(componentJ.getMinAddress(), destinationAddress, RefType.DATA, SourceType.ANALYSIS, 0);
                symbolTable.createLabel(destinationAddress, componentJ.getFieldName(), SourceType.ANALYSIS);
                if (componentJ.getFieldName().startsWith("lookup_table_data_")) {
                    OatDexFileUtilities.markupLookupTableData(this.getClass(), destinationAddress, this.dexHeader, oatHeader, program, monitor, log);
                }
                if (!componentJ.getFieldName().startsWith("oat_class_offsets_pointer_")) continue;
                OatDexFileUtilities.markupOatClassOffsetsPointer(this.getClass(), destinationAddress, this.dexHeader, oatHeader, program, monitor, log);
            }
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatDexFile_Nougat.class.getSimpleName() + "_" + Integer.toHexString(this.dex_file_location_), 0);
        structure.add(DWORD, "dex_file_location_", null);
        structure.add(STRING, this.dex_file_location_, "canonical_dex_file_location_", null);
        structure.add(DWORD, "dex_file_location_checksum_", null);
        structure.add(DWORD, "dex_file_pointer_", null);
        structure.add(DWORD, "lookup_table_data_", null);
        structure.add(DWORD, "oat_class_offsets_pointer_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

