/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.AbstractPatternTextFilter;
import docking.widgets.filter.TextFilter;
import java.util.regex.Pattern;

public class FindsPatternTextFilter
extends AbstractPatternTextFilter {
    public FindsPatternTextFilter(String filterText) {
        super(filterText);
    }

    @Override
    protected Pattern createPattern() {
        try {
            Pattern pattern = Pattern.compile(this.filterText, 32);
            return pattern;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean matches(String text, Pattern pattern) {
        return pattern.matcher(text).find();
    }

    @Override
    public boolean isSubFilterOf(TextFilter parentFilter) {
        if (!(parentFilter instanceof FindsPatternTextFilter)) {
            return false;
        }
        FindsPatternTextFilter other = (FindsPatternTextFilter)parentFilter;
        String child = this.filterText;
        String parent = other.filterText;
        if (!child.startsWith(parent)) {
            return false;
        }
        boolean isSubFilter = this.areAllCharactersSimpleEnough(child.substring(parent.length()));
        return isSubFilter;
    }

    private boolean areAllCharactersSimpleEnough(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= 'Z' || c >= '_' && c <= 'z') continue;
            return false;
        }
        return true;
    }
}

