/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.Viewport;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class FontSizeManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    public StringMap getIdentifiers() {
        return values;
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "font-size";
    }

    @Override
    public int getPropertyType() {
        return 39;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.MEDIUM_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                String string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT).intern();
                Object object = values.get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(string);
                }
                return (Value)object;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object object = values.get(string.toLowerCase(Locale.ROOT).intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        CSSValue.Type type;
        boolean bl;
        float f;
        block48: {
            block47: {
                f = 1.0f;
                bl = false;
                type = value.getPrimitiveType();
                if (type != CSSValue.Type.NUMERIC) break block47;
                switch (value.getUnitType()) {
                    case 0: 
                    case 3: {
                        return value;
                    }
                    case 8: {
                        float f2 = value.getFloatValue();
                        return new FloatValue(3, f2 * 3.7795277f);
                    }
                    case 7: {
                        float f3 = value.getFloatValue();
                        return new FloatValue(3, f3 * 37.795277f);
                    }
                    case 4: {
                        float f4 = value.getFloatValue();
                        return new FloatValue(3, f4 * 96.0f);
                    }
                    case 6: {
                        float f5 = value.getFloatValue();
                        return new FloatValue(3, f5 / 0.75f);
                    }
                    case 5: {
                        float f6 = value.getFloatValue();
                        return new FloatValue(3, f6 * 16.0f);
                    }
                    case 20: {
                        bl = true;
                        f = value.getFloatValue();
                        break block48;
                    }
                    case 21: {
                        bl = true;
                        f = value.getFloatValue() * 0.5f;
                        break block48;
                    }
                    case 2: {
                        bl = true;
                        f = value.getFloatValue() * 0.01f;
                        break block48;
                    }
                    case 25: {
                        float f7;
                        styleMap.putLineHeightRelative(n, true);
                        f = value.getFloatValue();
                        int n2 = cSSEngine.getLineHeightIndex();
                        CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                        if (cSSStylableElement2 == null) {
                            f7 = 1.1f * cSSEngine.getCSSContext().getMediumFontSize();
                        } else {
                            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, null, n2);
                            f7 = this.lineHeightValue(cSSStylableElement2, null, cSSEngine, value2);
                        }
                        return new FloatValue(3, f7 * f);
                    }
                    case 26: {
                        styleMap.putRootFontSizeRelative(n, true);
                        f = value.getFloatValue();
                        return this.rootRelative(cSSStylableElement, cSSEngine, n, f);
                    }
                    case 28: {
                        styleMap.putRootFontSizeRelative(n, true);
                        f = value.getFloatValue() * 0.5f;
                        return this.rootRelative(cSSStylableElement, cSSEngine, n, f);
                    }
                    case 27: {
                        float f8;
                        styleMap.putLineHeightRelative(n, true);
                        f = value.getFloatValue();
                        int n3 = cSSEngine.getLineHeightIndex();
                        CSSStylableElement cSSStylableElement3 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
                        if (cSSStylableElement == cSSStylableElement3) {
                            f8 = 1.1f * cSSEngine.getCSSContext().getMediumFontSize();
                        } else {
                            Value value3 = cSSEngine.getComputedStyle(cSSStylableElement3, null, n3);
                            f8 = this.lineHeightValue(cSSStylableElement3, null, cSSEngine, value3);
                        }
                        return new FloatValue(3, f8 * f);
                    }
                    case 45: {
                        styleMap.putViewportRelative(n, true);
                        float f9 = value.getFloatValue();
                        return new FloatValue(3, f9 * cSSEngine.getCSSContext().getViewport(cSSStylableElement).getWidth() * 0.01f);
                    }
                    case 41: {
                        styleMap.putViewportRelative(n, true);
                        float f10 = value.getFloatValue();
                        return new FloatValue(3, f10 * cSSEngine.getCSSContext().getViewport(cSSStylableElement).getHeight() * 0.01f);
                    }
                    case 44: {
                        styleMap.putViewportRelative(n, true);
                        float f11 = value.getFloatValue();
                        Viewport viewport = cSSEngine.getCSSContext().getViewport(cSSStylableElement);
                        float f12 = viewport.getWidth();
                        float f13 = viewport.getHeight();
                        float f14 = Math.min(f12, f13);
                        return new FloatValue(3, f11 * f14 * 0.01f);
                    }
                    case 43: {
                        styleMap.putViewportRelative(n, true);
                        float f15 = value.getFloatValue();
                        Viewport viewport = cSSEngine.getCSSContext().getViewport(cSSStylableElement);
                        float f16 = viewport.getWidth();
                        float f17 = viewport.getHeight();
                        float f18 = Math.max(f16, f17);
                        return new FloatValue(3, f15 * f18 * 0.01f);
                    }
                    default: {
                        return new FloatValue(3, NumberValue.floatValueConversion((float)value.getFloatValue(), (short)value.getUnitType(), (short)3));
                    }
                }
            }
            if (type == CSSValue.Type.EXPRESSION || type == CSSValue.Type.MATH_FUNCTION) {
                try {
                    Value value4 = this.evaluateMath((NumericDelegateValue)value, cSSStylableElement, string, cSSEngine, n, styleMap, (short)3);
                    return new FloatValue(3, value4.getFloatValue());
                }
                catch (Exception exception) {
                    return this.isInheritedProperty() ? null : this.getDefaultValue();
                }
            }
        }
        if (value.isIdentifier("larger")) {
            bl = true;
            f = 1.2f;
        } else if (value.isIdentifier("smaller")) {
            bl = true;
            f = 0.8333333f;
        }
        if (bl) {
            float f19;
            styleMap.putParentRelative(n, true);
            CSSStylableElement cSSStylableElement4 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement4 == null) {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                f19 = cSSContext.getMediumFontSize();
            } else {
                Value value5 = cSSEngine.getComputedStyle(cSSStylableElement4, null, n);
                f19 = value5.getFloatValue();
            }
            return new FloatValue(3, f19 * f);
        }
        CSSContext cSSContext = cSSEngine.getCSSContext();
        float f20 = cSSContext.getMediumFontSize();
        if (type == CSSValue.Type.IDENT) {
            String string2 = value.getIdentifierValue();
            block20 : switch (string2.charAt(0)) {
                case 'm': {
                    break;
                }
                case 's': {
                    f20 /= 1.2f;
                    break;
                }
                case 'l': {
                    f20 *= 1.2f;
                    break;
                }
                default: {
                    switch (string2.charAt(1)) {
                        case 'x': {
                            switch (string2.charAt(3)) {
                                case 's': {
                                    f20 /= 1.728f;
                                    break block20;
                                }
                            }
                            f20 *= 1.728f;
                            break block20;
                        }
                    }
                    switch (string2.charAt(2)) {
                        case 's': {
                            f20 /= 1.44f;
                            break block20;
                        }
                    }
                    f20 *= 1.44f;
                }
            }
        }
        return new FloatValue(3, f20);
    }

    private Value rootRelative(CSSStylableElement cSSStylableElement, CSSEngine cSSEngine, int n, float f) {
        CSSStylableElement cSSStylableElement2 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
        if (cSSStylableElement == cSSStylableElement2) {
            CSSContext cSSContext = cSSEngine.getCSSContext();
            float f2 = cSSContext.getMediumFontSize() * f;
            return new FloatValue(3, f2);
        }
        Value value = cSSEngine.getComputedStyle(cSSStylableElement2, null, n);
        float f3 = value.getFloatValue() * f;
        return new FloatValue(3, f3);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("large", ValueConstants.LARGE_VALUE);
        values.put("larger", ValueConstants.LARGER_VALUE);
        values.put("medium", ValueConstants.MEDIUM_VALUE);
        values.put("small", ValueConstants.SMALL_VALUE);
        values.put("smaller", ValueConstants.SMALLER_VALUE);
        values.put("x-large", ValueConstants.X_LARGE_VALUE);
        values.put("x-small", ValueConstants.X_SMALL_VALUE);
        values.put("xx-large", ValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", ValueConstants.XX_SMALL_VALUE);
    }
}

