/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsActivator;

class CopyAsConfigurationStorage {
    private static final String COPY_AS_CFG = "CopyAsConfig";
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().setPrettyPrinting().create();

    @NotNull
    static Map<DataTransferProcessorDescriptor, Map<String, Object>> getProcessorProperties() {
        HashMap<DataTransferProcessorDescriptor, Map<String, Object>> propertiesMap = new HashMap<DataTransferProcessorDescriptor, Map<String, Object>>();
        String json = CopyAsConfigurationStorage.getPreferenceStore().getString(COPY_AS_CFG);
        if (json == null || json.isEmpty()) {
            return propertiesMap;
        }
        Map jsonMap = JSONUtils.parseMap((Gson)GSON, (Reader)new StringReader(json));
        for (Map.Entry entry : JSONUtils.getNestedObjects((Map)jsonMap, (String)COPY_AS_CFG)) {
            DataTransferProcessorDescriptor descriptor = DataTransferRegistry.getInstance().getProcessor((String)entry.getKey());
            if (descriptor == null) continue;
            propertiesMap.put(descriptor, (Map)entry.getValue());
        }
        return propertiesMap;
    }

    static void saveProcessorProperties(@NotNull Map<DataTransferProcessorDescriptor, Map<String, Object>> properties) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
             JsonWriter jsonWriter = GSON.newJsonWriter((Writer)writer);){
            jsonWriter.setIndent("    ");
            jsonWriter.beginObject();
            jsonWriter.name(COPY_AS_CFG);
            jsonWriter.beginObject();
            for (Map.Entry<DataTransferProcessorDescriptor, Map<String, Object>> entries : properties.entrySet()) {
                JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)entries.getKey().getFullId(), entries.getValue(), (boolean)true);
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
            jsonWriter.flush();
        }
        String json = new String(os.toByteArray(), StandardCharsets.UTF_8);
        CopyAsConfigurationStorage.getPreferenceStore().setValue(COPY_AS_CFG, json);
    }

    private static DBPPreferenceStore getPreferenceStore() {
        return DataEditorsActivator.getDefault().getPreferences();
    }

    private CopyAsConfigurationStorage() {
    }
}

