/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.tidb.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAbstract;
import org.jkiss.dbeaver.ext.tidb.model.plan.TiDBPlanNodePlain;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;

public class TiDBPlainClassic
extends MySQLPlanAbstract {
    private List<TiDBPlanNodePlain> rootNodes;

    public TiDBPlainClassic(JDBCSession session, String query) throws DBCException {
        super((MySQLDataSource)session.getDataSource(), query);
        try (JDBCPreparedStatement dbStat = session.prepareStatement(this.getPlanQueryString());
             JDBCResultSet dbResult = dbStat.executeQuery();){
            ArrayList<TiDBPlanNodePlain> nodes = new ArrayList<TiDBPlanNodePlain>();
            while (dbResult.next()) {
                TiDBPlanNodePlain node = new TiDBPlanNodePlain(null, (ResultSet)dbResult);
                nodes.add(node);
            }
            this.rootNodes = nodes;
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public TiDBPlainClassic(MySQLDataSource dataSource, String query, List<TiDBPlanNodePlain> rootNodes) {
        super(dataSource, query);
        this.rootNodes = rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN FORMAT = \"brief\" " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }
}

