﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/directconnect/DirectConnect_EXPORTS.h>
#include <aws/directconnect/model/InterconnectState.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DirectConnect {
namespace Model {
class DeleteInterconnectResult {
 public:
  AWS_DIRECTCONNECT_API DeleteInterconnectResult() = default;
  AWS_DIRECTCONNECT_API DeleteInterconnectResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DIRECTCONNECT_API DeleteInterconnectResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The state of the interconnect. The following are the possible values:</p>
   * <ul> <li> <p> <code>requested</code>: The initial state of an interconnect. The
   * interconnect stays in the requested state until the Letter of Authorization
   * (LOA) is sent to the customer.</p> </li> <li> <p> <code>pending</code>: The
   * interconnect is approved, and is being initialized.</p> </li> <li> <p>
   * <code>available</code>: The network link is up, and the interconnect is ready
   * for use.</p> </li> <li> <p> <code>down</code>: The network link is down.</p>
   * </li> <li> <p> <code>deleting</code>: The interconnect is being deleted.</p>
   * </li> <li> <p> <code>deleted</code>: The interconnect is deleted.</p> </li> <li>
   * <p> <code>unknown</code>: The state of the interconnect is not available.</p>
   * </li> </ul>
   */
  inline InterconnectState GetInterconnectState() const { return m_interconnectState; }
  inline void SetInterconnectState(InterconnectState value) {
    m_interconnectStateHasBeenSet = true;
    m_interconnectState = value;
  }
  inline DeleteInterconnectResult& WithInterconnectState(InterconnectState value) {
    SetInterconnectState(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteInterconnectResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  InterconnectState m_interconnectState{InterconnectState::NOT_SET};

  Aws::String m_requestId;
  bool m_interconnectStateHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectConnect
}  // namespace Aws
