﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ComplianceType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ConfigService {
namespace Model {

/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRuleRequest">AWS
 * API Reference</a></p>
 */
class DescribeComplianceByConfigRuleRequest : public ConfigServiceRequest {
 public:
  AWS_CONFIGSERVICE_API DescribeComplianceByConfigRuleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeComplianceByConfigRule"; }

  AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

  AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>Specify one or more Config rule names to filter the results by rule.</p>
   */
  inline const Aws::Vector<Aws::String>& GetConfigRuleNames() const { return m_configRuleNames; }
  inline bool ConfigRuleNamesHasBeenSet() const { return m_configRuleNamesHasBeenSet; }
  template <typename ConfigRuleNamesT = Aws::Vector<Aws::String>>
  void SetConfigRuleNames(ConfigRuleNamesT&& value) {
    m_configRuleNamesHasBeenSet = true;
    m_configRuleNames = std::forward<ConfigRuleNamesT>(value);
  }
  template <typename ConfigRuleNamesT = Aws::Vector<Aws::String>>
  DescribeComplianceByConfigRuleRequest& WithConfigRuleNames(ConfigRuleNamesT&& value) {
    SetConfigRuleNames(std::forward<ConfigRuleNamesT>(value));
    return *this;
  }
  template <typename ConfigRuleNamesT = Aws::String>
  DescribeComplianceByConfigRuleRequest& AddConfigRuleNames(ConfigRuleNamesT&& value) {
    m_configRuleNamesHasBeenSet = true;
    m_configRuleNames.emplace_back(std::forward<ConfigRuleNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Filters the results by compliance.</p>
   */
  inline const Aws::Vector<ComplianceType>& GetComplianceTypes() const { return m_complianceTypes; }
  inline bool ComplianceTypesHasBeenSet() const { return m_complianceTypesHasBeenSet; }
  template <typename ComplianceTypesT = Aws::Vector<ComplianceType>>
  void SetComplianceTypes(ComplianceTypesT&& value) {
    m_complianceTypesHasBeenSet = true;
    m_complianceTypes = std::forward<ComplianceTypesT>(value);
  }
  template <typename ComplianceTypesT = Aws::Vector<ComplianceType>>
  DescribeComplianceByConfigRuleRequest& WithComplianceTypes(ComplianceTypesT&& value) {
    SetComplianceTypes(std::forward<ComplianceTypesT>(value));
    return *this;
  }
  inline DescribeComplianceByConfigRuleRequest& AddComplianceTypes(ComplianceType value) {
    m_complianceTypesHasBeenSet = true;
    m_complianceTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>nextToken</code> string returned on a previous page that you use to
   * get the next page of results in a paginated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeComplianceByConfigRuleRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_configRuleNames;

  Aws::Vector<ComplianceType> m_complianceTypes;

  Aws::String m_nextToken;
  bool m_configRuleNamesHasBeenSet = false;
  bool m_complianceTypesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
