/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitNodeInfo.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebKitNodeInfoConstructor);

class JSWebKitNodeInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitNodeInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitNodeInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitNodeInfoPrototype>(vm)) JSWebKitNodeInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitNodeInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitNodeInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitNodeInfoPrototype, JSWebKitNodeInfoPrototype::Base);

using JSWebKitNodeInfoDOMConstructor = JSDOMConstructorNotConstructable<JSWebKitNodeInfo>;

template<> const ClassInfo JSWebKitNodeInfoDOMConstructor::s_info = { "WebKitNodeInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNodeInfoDOMConstructor) };

template<> JSValue JSWebKitNodeInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitNodeInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebKitNodeInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebKitNodeInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSWebKitNodeInfoPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebKitNodeInfoConstructor, 0 } },
};

const ClassInfo JSWebKitNodeInfoPrototype::s_info = { "WebKitNodeInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNodeInfoPrototype) };

void JSWebKitNodeInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitNodeInfo::info(), JSWebKitNodeInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebKitNodeInfo::s_info = { "WebKitNodeInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNodeInfo) };

JSWebKitNodeInfo::JSWebKitNodeInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitNodeInfo>&& impl)
    : JSDOMWrapper<WebKitNodeInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebKitNodeInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebKitNodeInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebKitNodeInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebKitNodeInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebKitNodeInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitNodeInfo>(vm, globalObject);
}

JSValue JSWebKitNodeInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitNodeInfoDOMConstructor, DOMConstructorID::WebKitNodeInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebKitNodeInfo::destroy(JSC::JSCell* cell)
{
    JSWebKitNodeInfo* thisObject = static_cast<JSWebKitNodeInfo*>(cell);
    thisObject->JSWebKitNodeInfo::~JSWebKitNodeInfo();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebKitNodeInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitNodeInfoPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitNodeInfo::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebKitNodeInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebKitNodeInfo, UseCustomHeapCellType::No>(vm, "JSWebKitNodeInfo"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebKitNodeInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebKitNodeInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebKitNodeInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebKitNodeInfo = std::forward<decltype(space)>(space); }
    );
}

void JSWebKitNodeInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitNodeInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebKitNodeInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebKitNodeInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitNodeInfo = static_cast<JSWebKitNodeInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitNodeInfo->protectedWrapped().ptr(), jsWebKitNodeInfo);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitNodeInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14WebKitNodeInfoE[]; }
#endif
template<std::same_as<WebKitNodeInfo> T>
static inline void verifyVTable(WebKitNodeInfo* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebKitNodeInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14WebKitNodeInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebKitNodeInfo has subclasses. If WebKitNodeInfo has subclasses that get passed
        // to toJS() we currently require WebKitNodeInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitNodeInfo>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebKitNodeInfo>(impl.ptr());
#endif
    return createWrapper<WebKitNodeInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitNodeInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebKitNodeInfo* JSWebKitNodeInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitNodeInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
