/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(USER_MESSAGE_HANDLERS)

#include "JSUserMessageHandler.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsUserMessageHandlerPrototypeFunction_postMessage);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsUserMessageHandlerConstructor);

class JSUserMessageHandlerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUserMessageHandlerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUserMessageHandlerPrototype* ptr = new (NotNull, JSC::allocateCell<JSUserMessageHandlerPrototype>(vm)) JSUserMessageHandlerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserMessageHandlerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUserMessageHandlerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserMessageHandlerPrototype, JSUserMessageHandlerPrototype::Base);

using JSUserMessageHandlerDOMConstructor = JSDOMConstructorNotConstructable<JSUserMessageHandler>;

template<> const ClassInfo JSUserMessageHandlerDOMConstructor::s_info = { "UserMessageHandler"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlerDOMConstructor) };

template<> JSValue JSUserMessageHandlerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUserMessageHandlerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "UserMessageHandler"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSUserMessageHandler::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSUserMessageHandlerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsUserMessageHandlerConstructor, 0 } },
    HashTableValue { "postMessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsUserMessageHandlerPrototypeFunction_postMessage, 1 } },
};

const ClassInfo JSUserMessageHandlerPrototype::s_info = { "UserMessageHandler"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlerPrototype) };

void JSUserMessageHandlerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUserMessageHandler::info(), JSUserMessageHandlerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSUserMessageHandler::s_info = { "UserMessageHandler"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandler) };

JSUserMessageHandler::JSUserMessageHandler(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UserMessageHandler>&& impl)
    : JSDOMWrapper<UserMessageHandler>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, UserMessageHandler>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSUserMessageHandler::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSUserMessageHandlerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSUserMessageHandlerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSUserMessageHandler::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUserMessageHandler>(vm, globalObject);
}

JSValue JSUserMessageHandler::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUserMessageHandlerDOMConstructor, DOMConstructorID::UserMessageHandler>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUserMessageHandler::destroy(JSC::JSCell* cell)
{
    JSUserMessageHandler* thisObject = static_cast<JSUserMessageHandler*>(cell);
    thisObject->JSUserMessageHandler::~JSUserMessageHandler();
}

JSC_DEFINE_CUSTOM_GETTER(jsUserMessageHandlerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserMessageHandlerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUserMessageHandler::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsUserMessageHandlerPrototypeFunction_postMessageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSUserMessageHandler>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto messageConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (messageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), messageConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsUserMessageHandlerPrototypeFunction_postMessage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSUserMessageHandler>::call<jsUserMessageHandlerPrototypeFunction_postMessageBody>(*lexicalGlobalObject, *callFrame, "postMessage");
}

JSC::GCClient::IsoSubspace* JSUserMessageHandler::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSUserMessageHandler, UseCustomHeapCellType::No>(vm, "JSUserMessageHandler"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForUserMessageHandler.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForUserMessageHandler = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForUserMessageHandler.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForUserMessageHandler = std::forward<decltype(space)>(space); }
    );
}

void JSUserMessageHandler::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUserMessageHandler*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSUserMessageHandlerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSUserMessageHandlerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUserMessageHandler = static_cast<JSUserMessageHandler*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsUserMessageHandler->protectedWrapped().ptr(), jsUserMessageHandler);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UserMessageHandler@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18UserMessageHandlerE[]; }
#endif
template<std::same_as<UserMessageHandler> T>
static inline void verifyVTable(UserMessageHandler* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7UserMessageHandler@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18UserMessageHandlerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // UserMessageHandler has subclasses. If UserMessageHandler has subclasses that get passed
        // to toJS() we currently require UserMessageHandler you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UserMessageHandler>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<UserMessageHandler>(impl.ptr());
#endif
    return createWrapper<UserMessageHandler>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UserMessageHandler& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UserMessageHandler* JSUserMessageHandler::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUserMessageHandler*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(USER_MESSAGE_HANDLERS)
