/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPath2D.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "JSPath2D.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_addPath);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_closePath);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_moveTo);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_lineTo);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_quadraticCurveTo);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_bezierCurveTo);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_arcTo);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_rect);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_roundRect);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_arc);
static JSC_DECLARE_HOST_FUNCTION(jsPath2DPrototypeFunction_ellipse);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPath2DConstructor);

class JSPath2DPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPath2DPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPath2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSPath2DPrototype>(vm)) JSPath2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPath2DPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPath2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPath2DPrototype, JSPath2DPrototype::Base);

using JSPath2DDOMConstructor = JSDOMConstructor<JSPath2D>;

static inline EncodedJSValue constructJSPath2D1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPath2DDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = Path2D::create();
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<Path2D>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<Path2D>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSPath2D2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPath2DDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "Path2D"_s, nullptr, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = Path2D::create(*pathConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<Path2D>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<Path2D>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSPath2D3(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPath2DDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (dConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = Path2D::create(dConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<Path2D>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<Path2D>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPath2DDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (constructJSPath2D1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>())
            RELEASE_AND_RETURN(throwScope, (constructJSPath2D2(lexicalGlobalObject, callFrame)));
        RELEASE_AND_RETURN(throwScope, (constructJSPath2D3(lexicalGlobalObject, callFrame)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPath2DConstructorConstruct, JSPath2DDOMConstructor::construct);

template<> const ClassInfo JSPath2DDOMConstructor::s_info = { "Path2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPath2DDOMConstructor) };

template<> JSValue JSPath2DDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPath2DDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Path2D"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPath2D::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 12> JSPath2DPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPath2DConstructor, 0 } },
    HashTableValue { "addPath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_addPath, 1 } },
    HashTableValue { "closePath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_closePath, 0 } },
    HashTableValue { "moveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_moveTo, 2 } },
    HashTableValue { "lineTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_lineTo, 2 } },
    HashTableValue { "quadraticCurveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_quadraticCurveTo, 4 } },
    HashTableValue { "bezierCurveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_bezierCurveTo, 6 } },
    HashTableValue { "arcTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_arcTo, 5 } },
    HashTableValue { "rect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_rect, 4 } },
    HashTableValue { "roundRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_roundRect, 5 } },
    HashTableValue { "arc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_arc, 5 } },
    HashTableValue { "ellipse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPath2DPrototypeFunction_ellipse, 7 } },
};

const ClassInfo JSPath2DPrototype::s_info = { "Path2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPath2DPrototype) };

void JSPath2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPath2D::info(), JSPath2DPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPath2D::s_info = { "Path2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPath2D) };

JSPath2D::JSPath2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Path2D>&& impl)
    : JSDOMWrapper<Path2D>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, Path2D>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPath2D::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPath2DPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPath2DPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPath2D::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPath2D>(vm, globalObject);
}

JSValue JSPath2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPath2DDOMConstructor, DOMConstructorID::Path2D>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPath2D::destroy(JSC::JSCell* cell)
{
    JSPath2D* thisObject = static_cast<JSPath2D*>(cell);
    thisObject->JSPath2D::~JSPath2D();
}

JSC_DEFINE_CUSTOM_GETTER(jsPath2DConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPath2DPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPath2D::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_addPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "Path2D"_s, "addPath"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto transformConversionResult = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, argument1.value());
    if (transformConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addPath(*pathConversionResult.releaseReturnValue(), transformConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_addPath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_addPathBody>(*lexicalGlobalObject, *callFrame, "addPath");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_closePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.closePath(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_closePath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_closePathBody>(*lexicalGlobalObject, *callFrame, "closePath");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_moveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.moveTo(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_moveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_moveToBody>(*lexicalGlobalObject, *callFrame, "moveTo");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_lineToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.lineTo(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_lineTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_lineToBody>(*lexicalGlobalObject, *callFrame, "lineTo");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_quadraticCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cpxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (cpxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cpyConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (cpyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.quadraticCurveTo(cpxConversionResult.releaseReturnValue(), cpyConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_quadraticCurveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_quadraticCurveToBody>(*lexicalGlobalObject, *callFrame, "quadraticCurveTo");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_bezierCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 6) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cp1xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (cp1xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cp1yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (cp1yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cp2xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (cp2xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto cp2yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (cp2yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bezierCurveTo(cp1xConversionResult.releaseReturnValue(), cp1yConversionResult.releaseReturnValue(), cp2xConversionResult.releaseReturnValue(), cp2yConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_bezierCurveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_bezierCurveToBody>(*lexicalGlobalObject, *callFrame, "bezierCurveTo");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_arcToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x1ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y1ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto x2ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto y2ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiusConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (radiusConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.arcTo(x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue(), radiusConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_arcTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_arcToBody>(*lexicalGlobalObject, *callFrame, "arcTo");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_rectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.rect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_rect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_rectBody>(*lexicalGlobalObject, *callFrame, "rect");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_roundRect1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiiConversionResult = convert<IDLSequence<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<DOMPointInit>>>>(*lexicalGlobalObject, argument4.value());
    if (radiiConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.roundRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue(), radiiConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_roundRect2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiiConversionResult = convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<DOMPointInit>>>(*lexicalGlobalObject, argument4.value());
    if (radiiConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.roundRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue(), radiiConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_roundRectOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 5) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(4);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsPath2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        {
            bool success = hasIteratorMethod(lexicalGlobalObject, distinguishingArg);
            RETURN_IF_EXCEPTION(throwScope, { });
            if (success)
                RELEASE_AND_RETURN(throwScope, (jsPath2DPrototypeFunction_roundRect1Body(lexicalGlobalObject, callFrame, castedThis)));
        }
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsPath2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (jsPath2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsPath2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 5 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_roundRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_roundRectOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "roundRect");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_arcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto radiusConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (radiusConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto startAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (startAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto endAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (endAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto anticlockwiseConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument5.value());
    if (anticlockwiseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.arc(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), radiusConversionResult.releaseReturnValue(), startAngleConversionResult.releaseReturnValue(), endAngleConversionResult.releaseReturnValue(), anticlockwiseConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_arc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_arcBody>(*lexicalGlobalObject, *callFrame, "arc");
}

static inline JSC::EncodedJSValue jsPath2DPrototypeFunction_ellipseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPath2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 7) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto radiusXConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (radiusXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto radiusYConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (radiusYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto rotationConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (rotationConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto startAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (startAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto endAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument6.value());
    if (endAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto anticlockwiseConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument7.value());
    if (anticlockwiseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.ellipse(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), radiusXConversionResult.releaseReturnValue(), radiusYConversionResult.releaseReturnValue(), rotationConversionResult.releaseReturnValue(), startAngleConversionResult.releaseReturnValue(), endAngleConversionResult.releaseReturnValue(), anticlockwiseConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPath2DPrototypeFunction_ellipse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPath2D>::call<jsPath2DPrototypeFunction_ellipseBody>(*lexicalGlobalObject, *callFrame, "ellipse");
}

JSC::GCClient::IsoSubspace* JSPath2D::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPath2D, UseCustomHeapCellType::No>(vm, "JSPath2D"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPath2D.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPath2D = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPath2D.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPath2D = std::forward<decltype(space)>(space); }
    );
}

void JSPath2D::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPath2D*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSPath2DOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPath2DOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPath2D = static_cast<JSPath2D*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPath2D->protectedWrapped().ptr(), jsPath2D);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Path2D@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6Path2DE[]; }
#endif
template<std::same_as<Path2D> T>
static inline void verifyVTable(Path2D* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Path2D@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore6Path2DE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Path2D has subclasses. If Path2D has subclasses that get passed
        // to toJS() we currently require Path2D you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Path2D>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Path2D>(impl.ptr());
#endif
    return createWrapper<Path2D>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Path2D& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Path2D* JSPath2D::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPath2D*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
