/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSOverconstrainedError.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsOverconstrainedErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsOverconstrainedError_message);
static JSC_DECLARE_CUSTOM_GETTER(jsOverconstrainedError_constraint);
static JSC_DECLARE_CUSTOM_GETTER(jsOverconstrainedError_name);

class JSOverconstrainedErrorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOverconstrainedErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOverconstrainedErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSOverconstrainedErrorPrototype>(vm)) JSOverconstrainedErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOverconstrainedErrorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOverconstrainedErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOverconstrainedErrorPrototype, JSOverconstrainedErrorPrototype::Base);

using JSOverconstrainedErrorDOMConstructor = JSDOMConstructor<JSOverconstrainedError>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSOverconstrainedErrorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSOverconstrainedErrorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto constraintConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (constraintConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto messageConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (messageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = OverconstrainedError::create(constraintConversionResult.releaseReturnValue(), messageConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<OverconstrainedError>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<OverconstrainedError>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSOverconstrainedErrorDOMConstructorConstruct, JSOverconstrainedErrorDOMConstructor::construct);

template<> const ClassInfo JSOverconstrainedErrorDOMConstructor::s_info = { "OverconstrainedError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedErrorDOMConstructor) };

template<> JSValue JSOverconstrainedErrorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSOverconstrainedErrorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "OverconstrainedError"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSOverconstrainedError::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSOverconstrainedErrorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsOverconstrainedErrorConstructor, 0 } },
    HashTableValue { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOverconstrainedError_message, 0 } },
    HashTableValue { "constraint"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOverconstrainedError_constraint, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOverconstrainedError_name, 0 } },
};

const ClassInfo JSOverconstrainedErrorPrototype::s_info = { "OverconstrainedError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedErrorPrototype) };

void JSOverconstrainedErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOverconstrainedError::info(), JSOverconstrainedErrorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOverconstrainedError::s_info = { "OverconstrainedError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedError) };

JSOverconstrainedError::JSOverconstrainedError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OverconstrainedError>&& impl)
    : JSDOMWrapper<OverconstrainedError>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OverconstrainedError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOverconstrainedError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOverconstrainedErrorPrototype::createStructure(vm, &globalObject, globalObject.errorPrototype());
    structure->setMayBePrototype(true);
    return JSOverconstrainedErrorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOverconstrainedError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOverconstrainedError>(vm, globalObject);
}

JSValue JSOverconstrainedError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOverconstrainedErrorDOMConstructor, DOMConstructorID::OverconstrainedError>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSOverconstrainedError::destroy(JSC::JSCell* cell)
{
    JSOverconstrainedError* thisObject = static_cast<JSOverconstrainedError*>(cell);
    thisObject->JSOverconstrainedError::~JSOverconstrainedError();
}

JSC_DEFINE_CUSTOM_GETTER(jsOverconstrainedErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOverconstrainedErrorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOverconstrainedError::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsOverconstrainedError_messageGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOverconstrainedError_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedError_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsOverconstrainedError_constraintGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.constraint())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOverconstrainedError_constraint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedError_constraintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsOverconstrainedError_nameGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOverconstrainedError_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedError_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSOverconstrainedError::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOverconstrainedError, UseCustomHeapCellType::No>(vm, "JSOverconstrainedError"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOverconstrainedError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOverconstrainedError = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOverconstrainedError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOverconstrainedError = std::forward<decltype(space)>(space); }
    );
}

void JSOverconstrainedError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOverconstrainedError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOverconstrainedErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSOverconstrainedErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOverconstrainedError = static_cast<JSOverconstrainedError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOverconstrainedError->protectedWrapped().ptr(), jsOverconstrainedError);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OverconstrainedError@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20OverconstrainedErrorE[]; }
#endif
template<std::same_as<OverconstrainedError> T>
static inline void verifyVTable(OverconstrainedError* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OverconstrainedError@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20OverconstrainedErrorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OverconstrainedError has subclasses. If OverconstrainedError has subclasses that get passed
        // to toJS() we currently require OverconstrainedError you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OverconstrainedError>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OverconstrainedError>(impl.ptr());
#endif
    return createWrapper<OverconstrainedError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OverconstrainedError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OverconstrainedError* JSOverconstrainedError::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOverconstrainedError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
