/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMCounter.h"
#include "JSDeprecatedCSSOMRGBColor.h"
#include "JSDeprecatedCSSOMRect.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValue_primitiveType);

class JSDeprecatedCSSOMPrimitiveValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMPrimitiveValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMPrimitiveValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMPrimitiveValuePrototype>(vm)) JSDeprecatedCSSOMPrimitiveValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMPrimitiveValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMPrimitiveValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMPrimitiveValuePrototype, JSDeprecatedCSSOMPrimitiveValuePrototype::Base);

using JSDeprecatedCSSOMPrimitiveValueDOMConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMPrimitiveValue>;

/* Hash table for constructor */

static const std::array<HashTableValue, 26> JSDeprecatedCSSOMPrimitiveValueConstructorTableValues {
    HashTableValue { "CSS_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "CSS_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "CSS_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "CSS_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "CSS_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "CSS_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "CSS_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "CSS_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "CSS_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "CSS_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "CSS_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    HashTableValue { "CSS_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    HashTableValue { "CSS_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    HashTableValue { "CSS_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    HashTableValue { "CSS_MS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    HashTableValue { "CSS_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    HashTableValue { "CSS_HZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    HashTableValue { "CSS_KHZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    HashTableValue { "CSS_DIMENSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    HashTableValue { "CSS_STRING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
    HashTableValue { "CSS_URI"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 20 } },
    HashTableValue { "CSS_IDENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 21 } },
    HashTableValue { "CSS_ATTR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 22 } },
    HashTableValue { "CSS_COUNTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 23 } },
    HashTableValue { "CSS_RECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 24 } },
    HashTableValue { "CSS_RGBCOLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 25 } },
};

static_assert(DeprecatedCSSOMPrimitiveValue::CSS_UNKNOWN == 0, "CSS_UNKNOWN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_NUMBER == 1, "CSS_NUMBER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PERCENTAGE == 2, "CSS_PERCENTAGE in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EMS == 3, "CSS_EMS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EXS == 4, "CSS_EXS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PX == 5, "CSS_PX in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_CM == 6, "CSS_CM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MM == 7, "CSS_MM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IN == 8, "CSS_IN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PT == 9, "CSS_PT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PC == 10, "CSS_PC in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DEG == 11, "CSS_DEG in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RAD == 12, "CSS_RAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_GRAD == 13, "CSS_GRAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MS == 14, "CSS_MS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_S == 15, "CSS_S in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_HZ == 16, "CSS_HZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_KHZ == 17, "CSS_KHZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DIMENSION == 18, "CSS_DIMENSION in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_STRING == 19, "CSS_STRING in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_URI == 20, "CSS_URI in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IDENT == 21, "CSS_IDENT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_ATTR == 22, "CSS_ATTR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_COUNTER == 23, "CSS_COUNTER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RECT == 24, "CSS_RECT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RGBCOLOR == 25, "CSS_RGBCOLOR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");

template<> const ClassInfo JSDeprecatedCSSOMPrimitiveValueDOMConstructor::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValueDOMConstructor) };

template<> JSValue JSDeprecatedCSSOMPrimitiveValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValue::getConstructor(vm, &globalObject);
}

template<> void JSDeprecatedCSSOMPrimitiveValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSPrimitiveValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMPrimitiveValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValueConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 35> JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMPrimitiveValueConstructor, 0 } },
    HashTableValue { "primitiveType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMPrimitiveValue_primitiveType, 0 } },
    HashTableValue { "setFloatValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue, 0 } },
    HashTableValue { "getFloatValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue, 0 } },
    HashTableValue { "setStringValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue, 0 } },
    HashTableValue { "getStringValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue, 0 } },
    HashTableValue { "getCounterValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue, 0 } },
    HashTableValue { "getRectValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue, 0 } },
    HashTableValue { "getRGBColorValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue, 0 } },
    HashTableValue { "CSS_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "CSS_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "CSS_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "CSS_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "CSS_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "CSS_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "CSS_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "CSS_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "CSS_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "CSS_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "CSS_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    HashTableValue { "CSS_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    HashTableValue { "CSS_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    HashTableValue { "CSS_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    HashTableValue { "CSS_MS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    HashTableValue { "CSS_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    HashTableValue { "CSS_HZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    HashTableValue { "CSS_KHZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    HashTableValue { "CSS_DIMENSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    HashTableValue { "CSS_STRING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
    HashTableValue { "CSS_URI"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 20 } },
    HashTableValue { "CSS_IDENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 21 } },
    HashTableValue { "CSS_ATTR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 22 } },
    HashTableValue { "CSS_COUNTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 23 } },
    HashTableValue { "CSS_RECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 24 } },
    HashTableValue { "CSS_RGBCOLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 25 } },
};

const ClassInfo JSDeprecatedCSSOMPrimitiveValuePrototype::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValuePrototype) };

void JSDeprecatedCSSOMPrimitiveValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDeprecatedCSSOMPrimitiveValue::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValue) };

JSDeprecatedCSSOMPrimitiveValue::JSDeprecatedCSSOMPrimitiveValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMPrimitiveValue>&& impl)
    : JSDeprecatedCSSOMValue(structure, globalObject, WTFMove(impl))
{
}

Ref<DeprecatedCSSOMPrimitiveValue> JSDeprecatedCSSOMPrimitiveValue::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSDeprecatedCSSOMPrimitiveValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDeprecatedCSSOMPrimitiveValuePrototype::createStructure(vm, &globalObject, JSDeprecatedCSSOMValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDeprecatedCSSOMPrimitiveValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDeprecatedCSSOMPrimitiveValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMPrimitiveValue>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMPrimitiveValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMPrimitiveValueDOMConstructor, DOMConstructorID::DeprecatedCSSOMPrimitiveValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMPrimitiveValuePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMPrimitiveValue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDeprecatedCSSOMPrimitiveValue_primitiveTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMPrimitiveValue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.primitiveType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValue_primitiveType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMPrimitiveValue>::get<jsDeprecatedCSSOMPrimitiveValue_primitiveTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto floatValueConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (floatValueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setFloatValue(unitTypeConversionResult.releaseReturnValue(), floatValueConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValueBody>(*lexicalGlobalObject, *callFrame, "setFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnrestrictedFloat>(*lexicalGlobalObject, throwScope, impl.getFloatValue(unitTypeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValueBody>(*lexicalGlobalObject, *callFrame, "getFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto stringTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (stringTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto stringValueConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (stringValueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setStringValue(stringTypeConversionResult.releaseReturnValue(), stringValueConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValueBody>(*lexicalGlobalObject, *callFrame, "setStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getStringValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValueBody>(*lexicalGlobalObject, *callFrame, "getStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMCounter>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCounterValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValueBody>(*lexicalGlobalObject, *callFrame, "getCounterValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRectValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValueBody>(*lexicalGlobalObject, *callFrame, "getRectValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRGBColor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRGBColorValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValueBody>(*lexicalGlobalObject, *callFrame, "getRGBColorValue");
}

JSC::GCClient::IsoSubspace* JSDeprecatedCSSOMPrimitiveValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDeprecatedCSSOMPrimitiveValue, UseCustomHeapCellType::No>(vm, "JSDeprecatedCSSOMPrimitiveValue"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDeprecatedCSSOMPrimitiveValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDeprecatedCSSOMPrimitiveValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDeprecatedCSSOMPrimitiveValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDeprecatedCSSOMPrimitiveValue = std::forward<decltype(space)>(space); }
    );
}

void JSDeprecatedCSSOMPrimitiveValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMPrimitiveValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
