/* ModemInterface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ModemInterface.vala, do not modify */

/*-
 * Copyright 2017-2023 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "network.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <pango/pango.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_MODEM_INTERFACE_0_PROPERTY,
	NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY,
	NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY,
	NETWORK_MODEM_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_modem_interface_properties[NETWORK_MODEM_INTERFACE_NUM_PROPERTIES];
typedef enum  {
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN = 0,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS = 1 << 0,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM = 1 << 1,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT = 1 << 2,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS = 1 << 3,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE = 1 << 4,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS = 1 << 5,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA = 1 << 6,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA = 1 << 7,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA = 1 << 8,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS = 1 << 9,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT = 1 << 10,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0 = 1 << 11,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA = 1 << 12,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB = 1 << 13,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE = 1 << 14,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY = 0xFFFFFFFFLL
} NetworkModemInterfaceModemAccessTechnology;

#define NETWORK_MODEM_INTERFACE_TYPE_MODEM_ACCESS_TECHNOLOGY (network_modem_interface_modem_access_technology_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetworkModemInterfacePrepareData NetworkModemInterfacePrepareData;

struct _NetworkModemInterfacePrivate {
	gchar* _extra_info;
	guint32 _signal_quality;
	GDBusObjectManagerClient* modem_manager;
	GtkToggleButton* modem_item;
};

struct _Block3Data {
	int _ref_count_;
	NetworkModemInterface* self;
	NMClient* nm_client;
};

struct _NetworkModemInterfacePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkModemInterface* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GDBusObjectManagerClient* _tmp5_;
	GError* _inner_error0_;
};

static gint NetworkModemInterface_private_offset;
static gpointer network_modem_interface_parent_class = NULL;

static GType network_modem_interface_modem_access_technology_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda9_ (Block3Data* _data3_);
static void ____lambda10_ (NetworkModemInterface* self);
static void _____lambda10__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void network_modem_interface_update (NetworkModemInterface* self);
static void _network_modem_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                              guint new_state,
                                                              guint old_state,
                                                              guint reason,
                                                              gpointer self);
static NetworkState network_modem_interface_strength_to_state (NetworkModemInterface* self,
                                                        guint32 strength);
static gchar* network_modem_interface_access_technology_to_string (NetworkModemInterface* self,
                                                            NetworkModemInterfaceModemAccessTechnology tech);
static void network_modem_interface_device_properties_changed (NetworkModemInterface* self,
                                                        GVariant* changed);
static void network_modem_interface_set_signal_quality (NetworkModemInterface* self,
                                                 guint32 value);
static void network_modem_interface_set_extra_info (NetworkModemInterface* self,
                                             const gchar* value);
static void network_modem_interface_prepare_data_free (gpointer _data);
static gboolean network_modem_interface_prepare_co (NetworkModemInterfacePrepareData* _data_);
static void network_modem_interface_prepare_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void __lambda11_ (NetworkModemInterface* self,
                  GDBusObjectProxy* obj_proxy,
                  GDBusProxy* interface_proxy,
                  GVariant* changed,
                  gchar** invalidated);
static void ___lambda11__g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender,
                                                                                   GDBusObjectProxy* object_proxy,
                                                                                   GDBusProxy* interface_proxy,
                                                                                   GVariant* changed_properties,
                                                                                   gchar** invalidated_properties,
                                                                                   gpointer self);
static void network_modem_interface_finalize (GObject * obj);
static GType network_modem_interface_get_type_once (void);
static void _vala_network_modem_interface_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_network_modem_interface_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
network_modem_interface_get_instance_private (NetworkModemInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkModemInterface_private_offset);
}

static GType
network_modem_interface_modem_access_technology_get_type_once (void)
{
	static const GEnumValue values[] = {{NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN", "unknown"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS", "pots"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM", "gsm"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT", "gsm-compact"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS", "gprs"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE", "edge"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS", "umts"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA", "hsdpa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA", "hsupa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA", "hspa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS", "hspa-plus"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT", "1xrtt"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0", "evdo0"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA", "evdoa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB", "evdob"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE", "lte"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY", "any"}, {0, NULL, NULL}};
	GType network_modem_interface_modem_access_technology_type_id;
	network_modem_interface_modem_access_technology_type_id = g_enum_register_static ("NetworkModemInterfaceModemAccessTechnology", values);
	return network_modem_interface_modem_access_technology_type_id;
}

static GType
network_modem_interface_modem_access_technology_get_type (void)
{
	static volatile gsize network_modem_interface_modem_access_technology_type_id__once = 0;
	if (g_once_init_enter (&network_modem_interface_modem_access_technology_type_id__once)) {
		GType network_modem_interface_modem_access_technology_type_id;
		network_modem_interface_modem_access_technology_type_id = network_modem_interface_modem_access_technology_get_type_once ();
		g_once_init_leave (&network_modem_interface_modem_access_technology_type_id__once, network_modem_interface_modem_access_technology_type_id);
	}
	return network_modem_interface_modem_access_technology_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		NetworkModemInterface* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
____lambda10_ (NetworkModemInterface* self)
{
	g_debug ("ModemInterface.vala:85: Successfully disconnected.");
}

static void
_____lambda10__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda10_ ((NetworkModemInterface*) self);
	g_object_unref (self);
}

static void
__lambda9_ (Block3Data* _data3_)
{
	NetworkModemInterface* self;
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data3_->self;
	_tmp1_ = self->priv->modem_item;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		NMDevice* _tmp4_;
		NMDevice* _tmp5_;
		NMDeviceState _tmp6_;
		NMDeviceState _tmp7_;
		_tmp4_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = nm_device_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == NM_DEVICE_STATE_DISCONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMDevice* _tmp8_;
		NMDevice* _tmp9_;
		_tmp8_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp9_ = _tmp8_;
		nm_client_activate_connection_async (_data3_->nm_client, NULL, _tmp9_, NULL, NULL, NULL, NULL);
	} else {
		gboolean _tmp10_ = FALSE;
		GtkToggleButton* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->modem_item;
		_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
		_tmp13_ = _tmp12_;
		if (!_tmp13_) {
			NMDevice* _tmp14_;
			NMDevice* _tmp15_;
			NMDeviceState _tmp16_;
			NMDeviceState _tmp17_;
			_tmp14_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp15_ = _tmp14_;
			_tmp16_ = nm_device_get_state (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp10_ = _tmp17_ == NM_DEVICE_STATE_ACTIVATED;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			NMDevice* _tmp18_;
			NMDevice* _tmp19_;
			_tmp18_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp19_ = _tmp18_;
			nm_device_disconnect_async (_tmp19_, NULL, _____lambda10__gasync_ready_callback, g_object_ref (self));
		}
	}
}

static void
___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda9_ (self);
}

static void
_network_modem_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                         guint new_state,
                                                         guint old_state,
                                                         guint reason,
                                                         gpointer self)
{
	network_modem_interface_update ((NetworkModemInterface*) self);
}

NetworkModemInterface*
network_modem_interface_construct (GType object_type,
                                   NMClient* nm_client,
                                   NMDevice* _device)
{
	NetworkModemInterface * self = NULL;
	Block3Data* _data3_;
	NMClient* _tmp0_;
	GtkImage* _tmp1_;
	GtkToggleButton* _tmp2_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_;
	GtkToggleButton* _tmp7_;
	GtkToggleButton* _tmp8_;
	NMDevice* _tmp9_;
	NMDevice* _tmp10_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data3_->nm_client);
	_data3_->nm_client = _tmp0_;
	self = (NetworkModemInterface*) network_widget_nm_interface_construct (object_type);
	_data3_->self = g_object_ref (self);
	network_widget_nm_interface_set_device ((NetworkWidgetNMInterface*) self, _device);
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-network-cellular-connected-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	gtk_button_set_image ((GtkButton*) _tmp2_, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->modem_item);
	self->priv->modem_item = _tmp2_;
	_tmp3_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_max_width_chars (_tmp5_, 16);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_add_class (_tmp6_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 3);
	_tmp7_ = self->priv->modem_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	g_object_bind_property_with_closures ((GObject*) self, "display-title", (GObject*) label, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp8_ = self->priv->modem_item;
	g_signal_connect_data (_tmp8_, "toggled", (GCallback) ___lambda9__gtk_toggle_button_toggled, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	network_modem_interface_update (self);
	_tmp9_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "state-changed", (GCallback) _network_modem_interface_update_nm_device_state_changed, self, 0);
	network_modem_interface_prepare (self, NULL, NULL);
	_g_object_unref0 (label);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

NetworkModemInterface*
network_modem_interface_new (NMClient* nm_client,
                             NMDevice* _device)
{
	return network_modem_interface_construct (NETWORK_TYPE_MODEM_INTERFACE, nm_client, _device);
}

static void
network_modem_interface_update (NetworkModemInterface* self)
{
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceState _tmp2_;
	NMDeviceState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = nm_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_UNAVAILABLE:
		case NM_DEVICE_STATE_FAILED:
		{
			GtkToggleButton* _tmp4_;
			GtkToggleButton* _tmp5_;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
			_tmp4_ = self->priv->modem_item;
			gtk_toggle_button_set_active (_tmp4_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_MOBILE);
			_tmp5_ = self->priv->modem_item;
			_tmp6_ = gtk_button_get_image ((GtkButton*) _tmp5_);
			_tmp7_ = _tmp6_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-cellular-error-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		case NM_DEVICE_STATE_DEACTIVATING:
		{
			GtkToggleButton* _tmp8_;
			GtkToggleButton* _tmp9_;
			GtkWidget* _tmp10_;
			GtkWidget* _tmp11_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp8_ = self->priv->modem_item;
			gtk_toggle_button_set_active (_tmp8_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_MOBILE);
			_tmp9_ = self->priv->modem_item;
			_tmp10_ = gtk_button_get_image ((GtkButton*) _tmp9_);
			_tmp11_ = _tmp10_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-cellular-disconnected-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			GtkToggleButton* _tmp12_;
			GtkToggleButton* _tmp13_;
			GtkWidget* _tmp14_;
			GtkWidget* _tmp15_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp12_ = self->priv->modem_item;
			gtk_toggle_button_set_active (_tmp12_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_MOBILE);
			_tmp13_ = self->priv->modem_item;
			_tmp14_ = gtk_button_get_image ((GtkButton*) _tmp13_);
			_tmp15_ = _tmp14_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-cellular-acquiring-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			GtkToggleButton* _tmp16_;
			guint32 _tmp17_;
			guint32 _tmp18_;
			GtkToggleButton* _tmp19_;
			GtkWidget* _tmp20_;
			GtkWidget* _tmp21_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp16_ = self->priv->modem_item;
			gtk_toggle_button_set_active (_tmp16_, TRUE);
			_tmp17_ = network_modem_interface_get_signal_quality (self);
			_tmp18_ = _tmp17_;
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_modem_interface_strength_to_state (self, _tmp18_));
			_tmp19_ = self->priv->modem_item;
			_tmp20_ = gtk_button_get_image ((GtkButton*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-cellular-connected-symbolic-symbolic", NULL);
			break;
		}
		default:
		break;
	}
}

static NetworkState
network_modem_interface_strength_to_state (NetworkModemInterface* self,
                                           guint32 strength)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	if (strength < ((guint32) 30)) {
		result = NETWORK_STATE_CONNECTED_MOBILE_WEAK;
		return result;
	} else {
		if (strength < ((guint32) 55)) {
			result = NETWORK_STATE_CONNECTED_MOBILE_OK;
			return result;
		} else {
			if (strength < ((guint32) 80)) {
				result = NETWORK_STATE_CONNECTED_MOBILE_GOOD;
				return result;
			} else {
				result = NETWORK_STATE_CONNECTED_MOBILE_EXCELLENT;
				return result;
			}
		}
	}
}

static gchar*
network_modem_interface_access_technology_to_string (NetworkModemInterface* self,
                                                     NetworkModemInterfaceModemAccessTechnology tech)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (tech) {
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY:
		{
			result = NULL;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("G");
			result = _tmp0_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("E");
			result = _tmp1_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("3G");
			result = _tmp2_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("H");
			result = _tmp3_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("H+");
			result = _tmp4_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("LTE");
			result = _tmp5_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

static void
network_modem_interface_device_properties_changed (NetworkModemInterface* self,
                                                   GVariant* changed)
{
	GVariant* signal_variant = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* access_technologies_variant = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_TUPLE;
	_tmp1_ = g_variant_lookup_value (changed, "SignalQuality", _tmp0_);
	signal_variant = _tmp1_;
	_tmp2_ = signal_variant;
	if (_tmp2_ != NULL) {
		gboolean recent = FALSE;
		guint32 quality = 0U;
		GVariant* _tmp3_;
		guint32 _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = signal_variant;
		g_variant_get (_tmp3_, "(ub)", &_tmp4_, &_tmp5_, NULL);
		quality = _tmp4_;
		recent = _tmp5_;
		network_modem_interface_set_signal_quality (self, quality);
	}
	_tmp6_ = G_VARIANT_TYPE_UINT32;
	_tmp7_ = g_variant_lookup_value (changed, "AccessTechnologies", _tmp6_);
	access_technologies_variant = _tmp7_;
	_tmp8_ = access_technologies_variant;
	if (_tmp8_ != NULL) {
		guint32 access_type = 0U;
		GVariant* _tmp9_;
		guint32 _tmp10_ = 0U;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = access_technologies_variant;
		g_variant_get (_tmp9_, "u", &_tmp10_, NULL);
		access_type = _tmp10_;
		_tmp11_ = network_modem_interface_access_technology_to_string (self, (NetworkModemInterfaceModemAccessTechnology) access_type);
		_tmp12_ = _tmp11_;
		network_modem_interface_set_extra_info (self, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_g_variant_unref0 (access_technologies_variant);
	_g_variant_unref0 (signal_variant);
}

static void
network_modem_interface_prepare_data_free (gpointer _data)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkModemInterfacePrepareData, _data_);
}

void
network_modem_interface_prepare (NetworkModemInterface* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	NetworkModemInterfacePrepareData* _data_;
	NetworkModemInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NetworkModemInterfacePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_modem_interface_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	network_modem_interface_prepare_co (_data_);
}

void
network_modem_interface_prepare_finish (NetworkModemInterface* self,
                                        GAsyncResult* _res_)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
network_modem_interface_prepare_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_modem_interface_prepare_co (_data_);
}

static void
__lambda11_ (NetworkModemInterface* self,
             GDBusObjectProxy* obj_proxy,
             GDBusProxy* interface_proxy,
             GVariant* changed,
             gchar** invalidated)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	NMDevice* _tmp3_;
	NMDevice* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (obj_proxy != NULL);
	g_return_if_fail (interface_proxy != NULL);
	g_return_if_fail (changed != NULL);
	g_object_get (interface_proxy, "g-object-path", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = nm_device_get_udi (_tmp4_);
	_tmp6_ = g_strcmp0 (_tmp2_, _tmp5_) == 0;
	_g_free0 (_tmp2_);
	if (_tmp6_) {
		network_modem_interface_device_properties_changed (self, changed);
	}
}

static void
___lambda11__g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender,
                                                                              GDBusObjectProxy* object_proxy,
                                                                              GDBusProxy* interface_proxy,
                                                                              GVariant* changed_properties,
                                                                              gchar** invalidated_properties,
                                                                              gpointer self)
{
	__lambda11_ ((NetworkModemInterface*) self, object_proxy, interface_proxy, changed_properties, invalidated_properties);
}

static gboolean
network_modem_interface_prepare_co (NetworkModemInterfacePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.freedesktop.ModemManager1", "/org/freedesktop/ModemManager1", NULL, NULL, NULL, NULL, network_modem_interface_prepare_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->modem_manager);
		_data_->self->priv->modem_manager = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("ModemInterface.vala:200: Unable to connect to ModemManager1 to check c" \
"ellular internet signal quality: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->modem_manager;
	g_signal_connect_object (_data_->_tmp5_, "interface-proxy-properties-changed", (GCallback) ___lambda11__g_dbus_object_manager_client_interface_proxy_properties_changed, _data_->self, 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
network_modem_interface_get_extra_info (NetworkModemInterface* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra_info;
	result = _tmp0_;
	return result;
}

static void
network_modem_interface_set_extra_info (NetworkModemInterface* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_modem_interface_get_extra_info (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extra_info);
		self->priv->_extra_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY]);
	}
}

guint32
network_modem_interface_get_signal_quality (NetworkModemInterface* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_signal_quality;
	return result;
}

static void
network_modem_interface_set_signal_quality (NetworkModemInterface* self,
                                            guint32 value)
{
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceState _tmp2_;
	NMDeviceState _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_signal_quality = value;
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = nm_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NM_DEVICE_STATE_ACTIVATED) {
		network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_modem_interface_strength_to_state (self, value));
	}
	g_object_notify_by_pspec ((GObject *) self, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY]);
}

static void
network_modem_interface_class_init (NetworkModemInterfaceClass * klass,
                                    gpointer klass_data)
{
	network_modem_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkModemInterface_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_modem_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_modem_interface_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_modem_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY] = g_param_spec_string ("extra-info", "extra-info", "extra-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY] = g_param_spec_uint ("signal-quality", "signal-quality", "signal-quality", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_modem_interface_instance_init (NetworkModemInterface * self,
                                       gpointer klass)
{
	self->priv = network_modem_interface_get_instance_private (self);
	self->priv->_extra_info = NULL;
}

static void
network_modem_interface_finalize (GObject * obj)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	_g_free0 (self->priv->_extra_info);
	_g_object_unref0 (self->priv->modem_manager);
	_g_object_unref0 (self->priv->modem_item);
	G_OBJECT_CLASS (network_modem_interface_parent_class)->finalize (obj);
}

static GType
network_modem_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkModemInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_modem_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkModemInterface), 0, (GInstanceInitFunc) network_modem_interface_instance_init, NULL };
	GType network_modem_interface_type_id;
	network_modem_interface_type_id = g_type_register_static (NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkModemInterface", &g_define_type_info, 0);
	NetworkModemInterface_private_offset = g_type_add_instance_private (network_modem_interface_type_id, sizeof (NetworkModemInterfacePrivate));
	return network_modem_interface_type_id;
}

GType
network_modem_interface_get_type (void)
{
	static volatile gsize network_modem_interface_type_id__once = 0;
	if (g_once_init_enter (&network_modem_interface_type_id__once)) {
		GType network_modem_interface_type_id;
		network_modem_interface_type_id = network_modem_interface_get_type_once ();
		g_once_init_leave (&network_modem_interface_type_id__once, network_modem_interface_type_id);
	}
	return network_modem_interface_type_id__once;
}

static void
_vala_network_modem_interface_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	switch (property_id) {
		case NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY:
		g_value_set_string (value, network_modem_interface_get_extra_info (self));
		break;
		case NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY:
		g_value_set_uint (value, network_modem_interface_get_signal_quality (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_modem_interface_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	switch (property_id) {
		case NETWORK_MODEM_INTERFACE_EXTRA_INFO_PROPERTY:
		network_modem_interface_set_extra_info (self, g_value_get_string (value));
		break;
		case NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY:
		network_modem_interface_set_signal_quality (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

