/* EtherInterface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EtherInterface.vala, do not modify */

/*
* Copyright 2015-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "network.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_ETHER_INTERFACE_0_PROPERTY,
	NETWORK_ETHER_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_ether_interface_properties[NETWORK_ETHER_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkEtherInterfacePrivate {
	NetworkSettingsToggle* ethernet_item;
	GSimpleAction* toggle_ethernet_action;
};

struct _Block2Data {
	int _ref_count_;
	NetworkEtherInterface* self;
	NMClient* nm_client;
};

static gint NetworkEtherInterface_private_offset;
static gpointer network_ether_interface_parent_class = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_);
static void ____lambda8_ (NetworkEtherInterface* self);
static void _____lambda8__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda7__g_simple_action_activate (GSimpleAction* _sender,
                                           GVariant* parameter,
                                           gpointer self);
static void network_ether_interface_update (NetworkEtherInterface* self);
static void _network_ether_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                              guint new_state,
                                                              guint old_state,
                                                              guint reason,
                                                              gpointer self);
static void network_ether_interface_finalize (GObject * obj);
static GType network_ether_interface_get_type_once (void);

static inline gpointer
network_ether_interface_get_instance_private (NetworkEtherInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkEtherInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NetworkEtherInterface* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
____lambda8_ (NetworkEtherInterface* self)
{
	g_debug ("EtherInterface.vala:49: Successfully disconnected.");
}

static void
_____lambda8__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda8_ ((NetworkEtherInterface*) self);
	g_object_unref (self);
}

static void
__lambda7_ (Block2Data* _data2_)
{
	NetworkEtherInterface* self;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	self = _data2_->self;
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	if (nm_device_get_state (_tmp1_) == NM_DEVICE_STATE_DISCONNECTED) {
		NMConnection* connection = NULL;
		NMConnection* _tmp2_;
		GPtrArray* remote_array = NULL;
		NMDevice* _tmp3_;
		NMDevice* _tmp4_;
		GPtrArray* _tmp5_;
		GPtrArray* _tmp6_;
		GPtrArray* _tmp7_;
		_tmp2_ = nm_simple_connection_new ();
		connection = _tmp2_;
		_tmp3_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = nm_device_get_available_connections (_tmp4_);
		_tmp6_ = _g_ptr_array_ref0 (_tmp5_);
		remote_array = _tmp6_;
		_tmp7_ = remote_array;
		if (_tmp7_ == NULL) {
			g_critical ("EtherInterface.vala:43: Unable to find an ethernet connection to activ" \
"ate");
		} else {
			NMConnection* _tmp8_;
			GPtrArray* _tmp9_;
			gconstpointer _tmp10_;
			const gchar* _tmp11_;
			NMConnection* _tmp12_;
			NMDevice* _tmp13_;
			NMDevice* _tmp14_;
			_tmp8_ = connection;
			_tmp9_ = remote_array;
			_tmp10_ = g_ptr_array_index (_tmp9_, (guint) 0);
			_tmp11_ = nm_connection_get_path ((NMConnection*) ((NMRemoteConnection*) _tmp10_));
			nm_connection_set_path (_tmp8_, _tmp11_);
			_tmp12_ = connection;
			_tmp13_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp14_ = _tmp13_;
			nm_client_activate_connection_async (_data2_->nm_client, _tmp12_, _tmp14_, NULL, NULL, NULL, NULL);
		}
		_g_ptr_array_unref0 (remote_array);
		_g_object_unref0 (connection);
	} else {
		NMDevice* _tmp15_;
		NMDevice* _tmp16_;
		_tmp15_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp16_ = _tmp15_;
		if (nm_device_get_state (_tmp16_) == NM_DEVICE_STATE_ACTIVATED) {
			NMDevice* _tmp17_;
			NMDevice* _tmp18_;
			_tmp17_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp18_ = _tmp17_;
			nm_device_disconnect_async (_tmp18_, NULL, _____lambda8__gasync_ready_callback, g_object_ref (self));
		}
	}
}

static void
___lambda7__g_simple_action_activate (GSimpleAction* _sender,
                                      GVariant* parameter,
                                      gpointer self)
{
	__lambda7_ (self);
}

static void
_network_ether_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                         guint new_state,
                                                         guint old_state,
                                                         guint reason,
                                                         gpointer self)
{
	network_ether_interface_update ((NetworkEtherInterface*) self);
}

NetworkEtherInterface*
network_ether_interface_construct (GType object_type,
                                   NMClient* nm_client,
                                   NMDevice* _device)
{
	NetworkEtherInterface * self = NULL;
	Block2Data* _data2_;
	NMClient* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	NetworkSettingsToggle* _tmp7_ = NULL;
	NetworkSettingsToggle* _tmp8_;
	NetworkSettingsToggle* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	NMDevice* _tmp14_;
	NMDevice* _tmp15_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp16_;
	GSimpleAction* _tmp17_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data2_->nm_client);
	_data2_->nm_client = _tmp0_;
	self = (NetworkEtherInterface*) network_widget_nm_interface_construct (object_type);
	_data2_->self = g_object_ref (self);
	network_widget_nm_interface_set_device ((NetworkWidgetNMInterface*) self, _device);
	_tmp1_ = g_strdup ("ethernet.toggle");
	_tmp2_ = g_strdup ("panel-network-wired-connected-symbolic");
	_tmp3_ = g_strdup ("settings://network");
	_tmp4_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = network_settings_toggle_new ();
	network_settings_toggle_set_action_name (_tmp7_, _tmp1_);
	_g_free0 (_tmp1_);
	network_settings_toggle_set_icon_name (_tmp7_, _tmp2_);
	_g_free0 (_tmp2_);
	network_settings_toggle_set_settings_uri (_tmp7_, _tmp3_);
	_g_free0 (_tmp3_);
	network_settings_toggle_set_text (_tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->ethernet_item);
	self->priv->ethernet_item = _tmp7_;
	_tmp8_ = self->priv->ethernet_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->ethernet_item;
	g_object_bind_property_with_closures ((GObject*) self, "display-title", (GObject*) _tmp9_, "text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = g_variant_new_boolean (TRUE);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_simple_action_new_stateful ("toggle", NULL, _tmp11_);
	_g_object_unref0 (self->priv->toggle_ethernet_action);
	self->priv->toggle_ethernet_action = _tmp12_;
	_g_variant_unref0 (_tmp11_);
	_tmp13_ = self->priv->toggle_ethernet_action;
	g_signal_connect_data (_tmp13_, "activate", (GCallback) ___lambda7__g_simple_action_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	network_ether_interface_update (self);
	_tmp14_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "state-changed", (GCallback) _network_ether_interface_update_nm_device_state_changed, self, 0);
	_tmp16_ = g_simple_action_group_new ();
	action_group = _tmp16_;
	_tmp17_ = self->priv->toggle_ethernet_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp17_);
	gtk_widget_insert_action_group ((GtkWidget*) self, "ethernet", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

NetworkEtherInterface*
network_ether_interface_new (NMClient* nm_client,
                             NMDevice* _device)
{
	return network_ether_interface_construct (NETWORK_TYPE_ETHER_INTERFACE, nm_client, _device);
}

static void
network_ether_interface_update (NetworkEtherInterface* self)
{
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	switch (nm_device_get_state (_tmp1_)) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_DEACTIVATING:
		case NM_DEVICE_STATE_FAILED:
		{
			GSimpleAction* _tmp2_;
			GVariant* _tmp3_;
			GVariant* _tmp4_;
			GSimpleAction* _tmp5_;
			NetworkSettingsToggle* _tmp6_;
			_tmp2_ = self->priv->toggle_ethernet_action;
			_tmp3_ = g_variant_new_boolean (FALSE);
			g_variant_ref_sink (_tmp3_);
			_tmp4_ = _tmp3_;
			g_simple_action_set_state (_tmp2_, _tmp4_);
			_g_variant_unref0 (_tmp4_);
			_tmp5_ = self->priv->toggle_ethernet_action;
			g_simple_action_set_enabled (_tmp5_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED);
			_tmp6_ = self->priv->ethernet_item;
			network_settings_toggle_set_icon_name (_tmp6_, "panel-network-wired-error-symbolic");
			break;
		}
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			GSimpleAction* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			GSimpleAction* _tmp10_;
			NetworkSettingsToggle* _tmp11_;
			_tmp7_ = self->priv->toggle_ethernet_action;
			_tmp8_ = g_variant_new_boolean (FALSE);
			g_variant_ref_sink (_tmp8_);
			_tmp9_ = _tmp8_;
			g_simple_action_set_state (_tmp7_, _tmp9_);
			_g_variant_unref0 (_tmp9_);
			_tmp10_ = self->priv->toggle_ethernet_action;
			g_simple_action_set_enabled (_tmp10_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_WIRED_UNPLUGGED);
			_tmp11_ = self->priv->ethernet_item;
			network_settings_toggle_set_icon_name (_tmp11_, "panel-network-wired-no-route-symbolic");
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			GSimpleAction* _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			GSimpleAction* _tmp15_;
			NetworkSettingsToggle* _tmp16_;
			_tmp12_ = self->priv->toggle_ethernet_action;
			_tmp13_ = g_variant_new_boolean (FALSE);
			g_variant_ref_sink (_tmp13_);
			_tmp14_ = _tmp13_;
			g_simple_action_set_state (_tmp12_, _tmp14_);
			_g_variant_unref0 (_tmp14_);
			_tmp15_ = self->priv->toggle_ethernet_action;
			g_simple_action_set_enabled (_tmp15_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_WIRED_UNPLUGGED);
			_tmp16_ = self->priv->ethernet_item;
			network_settings_toggle_set_icon_name (_tmp16_, "panel-network-wired-offline-symbolic");
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			GSimpleAction* _tmp17_;
			GSimpleAction* _tmp18_;
			GVariant* _tmp19_;
			GVariant* _tmp20_;
			NetworkSettingsToggle* _tmp21_;
			_tmp17_ = self->priv->toggle_ethernet_action;
			g_simple_action_set_enabled (_tmp17_, TRUE);
			_tmp18_ = self->priv->toggle_ethernet_action;
			_tmp19_ = g_variant_new_boolean (TRUE);
			g_variant_ref_sink (_tmp19_);
			_tmp20_ = _tmp19_;
			g_simple_action_set_state (_tmp18_, _tmp20_);
			_g_variant_unref0 (_tmp20_);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_WIRED);
			_tmp21_ = self->priv->ethernet_item;
			network_settings_toggle_set_icon_name (_tmp21_, "panel-network-wired-acquiring-symbolic");
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			GSimpleAction* _tmp22_;
			GSimpleAction* _tmp23_;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			NetworkSettingsToggle* _tmp26_;
			_tmp22_ = self->priv->toggle_ethernet_action;
			g_simple_action_set_enabled (_tmp22_, TRUE);
			_tmp23_ = self->priv->toggle_ethernet_action;
			_tmp24_ = g_variant_new_boolean (TRUE);
			g_variant_ref_sink (_tmp24_);
			_tmp25_ = _tmp24_;
			g_simple_action_set_state (_tmp23_, _tmp25_);
			_g_variant_unref0 (_tmp25_);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTED_WIRED);
			_tmp26_ = self->priv->ethernet_item;
			network_settings_toggle_set_icon_name (_tmp26_, "panel-network-wired-connected-symbolic-symbolic");
			break;
		}
		default:
		break;
	}
}

static void
network_ether_interface_class_init (NetworkEtherInterfaceClass * klass,
                                    gpointer klass_data)
{
	network_ether_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkEtherInterface_private_offset);
	G_OBJECT_CLASS (klass)->finalize = network_ether_interface_finalize;
}

static void
network_ether_interface_instance_init (NetworkEtherInterface * self,
                                       gpointer klass)
{
	self->priv = network_ether_interface_get_instance_private (self);
}

static void
network_ether_interface_finalize (GObject * obj)
{
	NetworkEtherInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ETHER_INTERFACE, NetworkEtherInterface);
	_g_object_unref0 (self->priv->ethernet_item);
	_g_object_unref0 (self->priv->toggle_ethernet_action);
	G_OBJECT_CLASS (network_ether_interface_parent_class)->finalize (obj);
}

static GType
network_ether_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkEtherInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_ether_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkEtherInterface), 0, (GInstanceInitFunc) network_ether_interface_instance_init, NULL };
	GType network_ether_interface_type_id;
	network_ether_interface_type_id = g_type_register_static (NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkEtherInterface", &g_define_type_info, 0);
	NetworkEtherInterface_private_offset = g_type_add_instance_private (network_ether_interface_type_id, sizeof (NetworkEtherInterfacePrivate));
	return network_ether_interface_type_id;
}

GType
network_ether_interface_get_type (void)
{
	static volatile gsize network_ether_interface_type_id__once = 0;
	if (g_once_init_enter (&network_ether_interface_type_id__once)) {
		GType network_ether_interface_type_id;
		network_ether_interface_type_id = network_ether_interface_get_type_once ();
		g_once_init_leave (&network_ether_interface_type_id__once, network_ether_interface_type_id);
	}
	return network_ether_interface_type_id__once;
}

