/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportReceiveStreamStats.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportReceiveStreamStats>> convertDictionary<WebTransportReceiveStreamStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportReceiveStreamStats result;
    JSValue bytesReadValue;
    if (isNullOrUndefined)
        bytesReadValue = jsUndefined();
    else {
        bytesReadValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesRead"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesReadValue.isUndefined()) {
        auto bytesReadConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReadValue);
        if (bytesReadConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesRead = bytesReadConversionResult.releaseReturnValue();
    }
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        auto bytesReceivedConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        if (bytesReceivedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesReceived = bytesReceivedConversionResult.releaseReturnValue();
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampValue.isUndefined()) {
        auto timestampConversionResult = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        if (timestampConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestamp = timestampConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

