/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSServiceWorkerWindowClient.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSServiceWorkerWindowClient.h"
#include "JSVisibilityState.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerWindowClientPrototypeFunction_focus);
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerWindowClientPrototypeFunction_navigate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerWindowClientConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerWindowClient_visibilityState);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerWindowClient_focused);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerWindowClient_ancestorOrigins);

class JSServiceWorkerWindowClientPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerWindowClientPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerWindowClientPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerWindowClientPrototype>(vm)) JSServiceWorkerWindowClientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerWindowClientPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerWindowClientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerWindowClientPrototype, JSServiceWorkerWindowClientPrototype::Base);

using JSServiceWorkerWindowClientDOMConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerWindowClient>;

template<> const ClassInfo JSServiceWorkerWindowClientDOMConstructor::s_info = { "WindowClient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClientDOMConstructor) };

template<> JSValue JSServiceWorkerWindowClientDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerClient::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerWindowClientDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WindowClient"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerWindowClient::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSServiceWorkerWindowClientPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerWindowClientConstructor, 0 } },
    HashTableValue { "visibilityState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerWindowClient_visibilityState, 0 } },
    HashTableValue { "focused"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerWindowClient_focused, 0 } },
    HashTableValue { "ancestorOrigins"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerWindowClient_ancestorOrigins, 0 } },
    HashTableValue { "focus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerWindowClientPrototypeFunction_focus, 0 } },
    HashTableValue { "navigate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerWindowClientPrototypeFunction_navigate, 1 } },
};

const ClassInfo JSServiceWorkerWindowClientPrototype::s_info = { "WindowClient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClientPrototype) };

void JSServiceWorkerWindowClientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerWindowClient::info(), JSServiceWorkerWindowClientPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSServiceWorkerWindowClient::s_info = { "WindowClient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClient) };

JSServiceWorkerWindowClient::JSServiceWorkerWindowClient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerWindowClient>&& impl)
    : JSServiceWorkerClient(structure, globalObject, WTFMove(impl))
{
}

Ref<ServiceWorkerWindowClient> JSServiceWorkerWindowClient::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerWindowClient>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSServiceWorkerWindowClient::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSServiceWorkerWindowClientPrototype::createStructure(vm, &globalObject, JSServiceWorkerClient::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSServiceWorkerWindowClientPrototype::create(vm, &globalObject, structure);
}

JSObject* JSServiceWorkerWindowClient::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerWindowClient>(vm, globalObject);
}

JSValue JSServiceWorkerWindowClient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerWindowClientDOMConstructor, DOMConstructorID::ServiceWorkerWindowClient>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerWindowClientConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerWindowClientPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerWindowClient::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsServiceWorkerWindowClient_visibilityStateGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerWindowClient& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VisibilityState>>(lexicalGlobalObject, throwScope, impl.visibilityState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerWindowClient_visibilityState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerWindowClient>::get<jsServiceWorkerWindowClient_visibilityStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerWindowClient_focusedGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerWindowClient& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.focused())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerWindowClient_focused, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerWindowClient>::get<jsServiceWorkerWindowClient_focusedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerWindowClient_ancestorOriginsGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerWindowClient& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLUSVString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ancestorOrigins())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerWindowClient_ancestorOrigins, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerWindowClient>::get<jsServiceWorkerWindowClient_ancestorOriginsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsServiceWorkerWindowClientPrototypeFunction_focusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerWindowClient>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<ServiceWorkerWindowClient>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.focus(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerWindowClientPrototypeFunction_focus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerWindowClient>::call<jsServiceWorkerWindowClientPrototypeFunction_focusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsServiceWorkerWindowClientPrototypeFunction_navigateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerWindowClient>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto urlConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (urlConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<ServiceWorkerWindowClient>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.navigate(*context, urlConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerWindowClientPrototypeFunction_navigate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerWindowClient>::call<jsServiceWorkerWindowClientPrototypeFunction_navigateBody>(*lexicalGlobalObject, *callFrame, "navigate");
}

JSC::GCClient::IsoSubspace* JSServiceWorkerWindowClient::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSServiceWorkerWindowClient, UseCustomHeapCellType::No>(vm, "JSServiceWorkerWindowClient"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForServiceWorkerWindowClient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForServiceWorkerWindowClient = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForServiceWorkerWindowClient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForServiceWorkerWindowClient = std::forward<decltype(space)>(space); }
    );
}

void JSServiceWorkerWindowClient::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerWindowClient*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
