const char minifio_lua[] =
"local ffi = require('ffi')\n"
"local minifio = require('internal.minifio')\n"
"\n"
"-- Several file manipulation functions without dependencies on\n"
"-- tarantool's built-in modules to use at early initialization\n"
"-- stage.\n"
"\n"
"ffi.cdef([[\n"
"    char *\n"
"    dirname(char *path);\n"
"]])\n"
"\n"
"-- {{{ Functions exposed by fio\n"
"\n"
"-- Several functions are defined in src/lua/minifio.c.\n"
"--\n"
"-- List them to ease searching by a function name.\n"
"assert(type(minifio.cwd) == 'function')\n"
"assert(type(minifio.script) == 'function')\n"
"\n"
"function minifio.pathjoin(...)\n"
"    local i, path = 1, nil\n"
"\n"
"    local len = select('#', ...)\n"
"    while i <= len do\n"
"        local sp = select(i, ...)\n"
"        if sp == nil then\n"
"            error(\"fio.pathjoin(): undefined path part \"..i, 0)\n"
"        end\n"
"\n"
"        sp = tostring(sp)\n"
"        if sp ~= '' then\n"
"            path = sp\n"
"            break\n"
"        else\n"
"            i = i + 1\n"
"        end\n"
"    end\n"
"\n"
"    if path == nil then\n"
"        return '.'\n"
"    end\n"
"\n"
"    i = i + 1\n"
"    while i <= len do\n"
"        local sp = select(i, ...)\n"
"        if sp == nil then\n"
"            error(\"fio.pathjoin(): undefined path part \"..i, 0)\n"
"        end\n"
"\n"
"        sp = tostring(sp)\n"
"        if sp ~= '' then\n"
"            path = path .. '/' .. sp\n"
"        end\n"
"\n"
"        i = i + 1\n"
"    end\n"
"\n"
"    path = path:gsub('/+', '/')\n"
"    if path ~= '/' then\n"
"        path = path:gsub('/$', '')\n"
"    end\n"
"\n"
"    return path\n"
"end\n"
"\n"
"function minifio.abspath(path)\n"
"    if path == nil then\n"
"        error(\"Usage: fio.abspath(path)\", 0)\n"
"    end\n"
"    path = path\n"
"    local joined_path\n"
"    local path_tab = {}\n"
"    if string.sub(path, 1, 1) == '/' then\n"
"        joined_path = path\n"
"    else\n"
"        joined_path = minifio.pathjoin(minifio.cwd(), path)\n"
"    end\n"
"    for sp in string.gmatch(joined_path, '[^/]+') do\n"
"        if sp == '..' then\n"
"            table.remove(path_tab)\n"
"        elseif sp ~= '.' then\n"
"            table.insert(path_tab, sp)\n"
"        end\n"
"    end\n"
"    return '/' .. table.concat(path_tab, '/')\n"
"end\n"
"\n"
"-- }}} Functions exposed by fio\n"
"\n"
"-- {{{ Functions replaced by fio\n"
"\n"
"-- Similar to fio.dirname, but it doesn't use\n"
"-- cord_ibuf_take()/cord_ibuf_put().\n"
"function minifio.dirname(path)\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: minifio.dirname(path)\", 0)\n"
"    end\n"
"    -- Can't just cast path to char * - on Linux dirname modifies\n"
"    -- its argument.\n"
"    local bsize = #path + 1\n"
"    local buf = ffi.new('char[\?]', bsize)\n"
"    ffi.copy(buf, ffi.cast('const char *', path), bsize)\n"
"    return ffi.string(ffi.C.dirname(buf))\n"
"end\n"
"\n"
"-- }}} Functions replaced by fio\n"
"\n"
"-- Functions to expose from fio as is. List them separately to\n"
"-- reduce probability of a mistake.\n"
"minifio.expose_from_fio = {\n"
"    cwd = minifio.cwd,\n"
"    pathjoin = minifio.pathjoin,\n"
"    abspath = minifio.abspath,\n"
"}\n"
"\n"
"return minifio\n"
""
;
