const char env_lua[] =
"local ffi = require('ffi')\n"
"local os = require('os')\n"
"local errno = require('errno')\n"
"\n"
"ffi.cdef[[\n"
"    extern char **environ;\n"
"\n"
"    int   setenv(const char *name, const char *value, int overwrite);\n"
"    int   unsetenv(const char *name);\n"
"]]\n"
"\n"
"os.environ = function()\n"
"    local environ = ffi.C.environ\n"
"    if not environ then\n"
"        return nil\n"
"    end\n"
"    local r = {}\n"
"    local i = 0\n"
"    while environ[i] ~= nil do\n"
"        local e = ffi.string(environ[i])\n"
"        local eq = e:find('=')\n"
"        if eq then\n"
"            r[e:sub(1, eq - 1)] = e:sub(eq + 1)\n"
"        end\n"
"        i = i + 1\n"
"    end\n"
"    return r\n"
"end\n"
"\n"
"os.setenv = function(key, value)\n"
"    local rv\n"
"    if value ~= nil then\n"
"        rv = ffi.C.setenv(key, value, 1)\n"
"    else\n"
"        rv = ffi.C.unsetenv(key)\n"
"    end\n"
"    if rv == -1 then\n"
"        error(string.format('error %d: %s', errno(), errno.errstring()))\n"
"    end\n"
"end\n"
""
;
