const char debug_lua[] =
"local debug = require('debug')\n"
"\n"
"local function sourcefile(level)\n"
"    local info = debug.getinfo(level or 2, 'S')\n"
"    local source = info and info.source\n"
"    return source and source:startswith('@') and source:sub(2) or nil\n"
"end\n"
"\n"
"local function sourcedir(level)\n"
"    local source = sourcefile(level and level + 1 or 3)\n"
"    return source and source:match('(.*)/') or '.'\n"
"end\n"
"\n"
"setmetatable(debug, {\n"
"    __index = function(self, v)\n"
"        -- Be careful editing these tail calls,\n"
"        -- since it may affect function results\n"
"        if v == '__file__' then\n"
"            return sourcefile()\n"
"        elseif v == '__dir__' then\n"
"            return sourcedir()\n"
"        end\n"
"        return rawget(self, v)\n"
"    end\n"
"})\n"
"\n"
"debug.sourcefile = sourcefile\n"
"debug.sourcedir = sourcedir\n"
""
;
