/* UbuntuInstaller.c generated by valac 0.56.18, the Vala compiler
 * generated from UbuntuInstaller.vala, do not modify */

/* Copyright 2011-2015 Switchboard Locale Plug Developers
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "io.elementary.settings.locale.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <unistd.h>

#define SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_LANGUAGE_CHECKER "/usr/bin/check-language-support"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData;
typedef struct _SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData;
typedef struct _SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData;
typedef struct _SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData;
typedef struct _SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData;
typedef struct _Block2Data Block2Data;
enum  {
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FINISHED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FAILED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_REMOVE_FINISHED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_CHECK_MISSING_FINISHED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_PROGRESS_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_NUM_SIGNALS
};
static guint switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_NUM_SIGNALS] = {0};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerPrivate {
	AptdProxy* aptd;
	AptdTransactionProxy* proxy;
	gchar** missing_packages;
	gint missing_packages_length1;
	gint _missing_packages_size_;
	gboolean _install_cancellable;
	SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode _transaction_mode;
	gchar* _transaction_language_code;
	GeeHashMap* transactions;
};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	gchar* language;
	gboolean has_permission;
	GError* _tmp0_;
	gchar** packages;
	gint _tmp1_;
	gchar** _tmp2_;
	gint packages_length1;
	gint _packages_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** packet_collection;
	gint packet_collection_length1;
	gint _packet_collection_size_;
	gint packet_it;
	gchar* _tmp4_;
	gchar* packet;
	const gchar* _tmp5_;
	gchar* transaction_id;
	AptdProxy* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* e;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _inner_error0_;
};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	gboolean _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean has_permission;
	GError* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** package_collection;
	gint package_collection_length1;
	gint _package_collection_size_;
	gint package_it;
	const gchar* package;
	const gchar* _tmp5_;
	gchar* transaction_id;
	AptdProxy* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* e;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	gchar* languagecode;
	gboolean has_permission;
	GError* _tmp0_;
	gchar** installed;
	gint _tmp1_;
	gchar** _tmp2_;
	gint installed_length1;
	gint _installed_size_;
	gchar* transaction_id;
	AptdProxy* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* e;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _inner_error0_;
};

struct _SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean result;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	PolkitUnixProcess* _tmp2_;
	PolkitUnixProcess* _tmp3_;
	PolkitPermission* _tmp4_;
	PolkitPermission* _tmp5_;
	PolkitPermission* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	PolkitPermission* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PolkitPermission* _tmp12_;
	GError* _vala1_e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	gchar* transaction_id;
};

static gint SwitchboardPlugLocaleInstallerUbuntuInstaller_private_offset;
static gpointer switchboard_plug_locale_installer_ubuntu_installer_parent_class = NULL;
static GOnce switchboard_plug_locale_installer_ubuntu_installer_instance;
static GOnce switchboard_plug_locale_installer_ubuntu_installer_instance = G_ONCE_INIT;
static PolkitPermission* switchboard_plug_locale_installer_ubuntu_installer_permission;
static PolkitPermission* switchboard_plug_locale_installer_ubuntu_installer_permission = NULL;

static SwitchboardPlugLocaleInstallerUbuntuInstaller* __lambda6_ (void);
static SwitchboardPlugLocaleInstallerUbuntuInstaller* switchboard_plug_locale_installer_ubuntu_installer_new (void);
static SwitchboardPlugLocaleInstallerUbuntuInstaller* switchboard_plug_locale_installer_ubuntu_installer_construct (GType object_type);
static gpointer ___lambda6__gthread_func (gpointer self);
static void switchboard_plug_locale_installer_ubuntu_installer_install_data_free (gpointer _data);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_install_co (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_);
static void switchboard_plug_locale_installer_ubuntu_installer_get_permission (GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_get_permission_finish (GAsyncResult* _res_);
static void switchboard_plug_locale_installer_ubuntu_installer_install_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                              SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode value);
static gchar** switchboard_plug_locale_installer_ubuntu_installer_get_remaining_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                                const gchar* langcode,
                                                                                                gint* result_length1);
static void switchboard_plug_locale_installer_ubuntu_installer_set_transaction_language_code (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                       const gchar* value);
static void switchboard_plug_locale_installer_ubuntu_installer_run_transaction (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                         const gchar* transaction_id);
static void switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_data_free (gpointer _data);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_co (SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_);
static void switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_ready (GObject* source_object,
                                                                                       GAsyncResult* _res_,
                                                                                       gpointer _user_data_);
static void switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_data_free (gpointer _data);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_co (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_);
static void switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_ready (GObject* source_object,
                                                                                         GAsyncResult* _res_,
                                                                                         gpointer _user_data_);
static void switchboard_plug_locale_installer_ubuntu_installer_remove_data_free (gpointer _data);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_remove_co (SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_);
static void switchboard_plug_locale_installer_ubuntu_installer_remove_ready (GObject* source_object,
                                                                      GAsyncResult* _res_,
                                                                      gpointer _user_data_);
static gchar** switchboard_plug_locale_installer_ubuntu_installer_get_to_remove_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                                const gchar* language,
                                                                                                gint* result_length1);
static void switchboard_plug_locale_installer_ubuntu_installer_get_permission_data_free (gpointer _data);
static gboolean switchboard_plug_locale_installer_ubuntu_installer_get_permission_co (SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_);
static void switchboard_plug_locale_installer_ubuntu_installer_get_permission_ready (GObject* source_object,
                                                                              GAsyncResult* _res_,
                                                                              gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_);
static void switchboard_plug_locale_installer_ubuntu_installer_on_apt_finshed (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                        const gchar* id,
                                                                        gboolean success);
static void ___lambda7__aptd_transaction_proxy_finished (AptdTransactionProxy* _sender,
                                                  const gchar* transaction_id,
                                                  gpointer self);
static void __lambda8_ (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                 const gchar* prop,
                 GVariant* val);
static void switchboard_plug_locale_installer_ubuntu_installer_set_install_cancellable (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                 gboolean value);
static void ___lambda8__aptd_transaction_proxy_property_changed (AptdTransactionProxy* _sender,
                                                          const gchar* property,
                                                          GVariant* variant,
                                                          gpointer self);
static gchar** switchboard_plug_locale_installer_ubuntu_installer_get_installed_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                                const gchar* langcode,
                                                                                                gint* result_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * switchboard_plug_locale_installer_ubuntu_installer_constructor (GType type,
                                                                          guint n_construct_properties,
                                                                          GObjectConstructParam * construct_properties);
static void switchboard_plug_locale_installer_ubuntu_installer_finalize (GObject * obj);
static GType switchboard_plug_locale_installer_ubuntu_installer_get_type_once (void);
static void _vala_switchboard_plug_locale_installer_ubuntu_installer_get_property (GObject * object,
                                                                            guint property_id,
                                                                            GValue * value,
                                                                            GParamSpec * pspec);
static void _vala_switchboard_plug_locale_installer_ubuntu_installer_set_property (GObject * object,
                                                                            guint property_id,
                                                                            const GValue * value,
                                                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
switchboard_plug_locale_installer_ubuntu_installer_get_instance_private (SwitchboardPlugLocaleInstallerUbuntuInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleInstallerUbuntuInstaller_private_offset);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL, "SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL", "install"}, {SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_REMOVE, "SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_REMOVE", "remove"}, {SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL_MISSING, "SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL_MISSING", "install-missing"}, {0, NULL, NULL}};
	GType switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id;
	switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id = g_enum_register_static ("SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode", values);
	return switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id;
}

GType
switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_get_type (void)
{
	static gsize switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id__once)) {
		GType switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id;
		switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id = switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id__once, switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id);
	}
	return switchboard_plug_locale_installer_ubuntu_installer_transaction_mode_type_id__once;
}

static SwitchboardPlugLocaleInstallerUbuntuInstaller*
__lambda6_ (void)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* result;
	_tmp0_ = switchboard_plug_locale_installer_ubuntu_installer_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda6__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda6_ ();
	return result;
}

SwitchboardPlugLocaleInstallerUbuntuInstaller*
switchboard_plug_locale_installer_ubuntu_installer_get_default (void)
{
	gconstpointer _tmp0_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* result;
	_tmp0_ = g_once (&switchboard_plug_locale_installer_ubuntu_installer_instance, ___lambda6__gthread_func, NULL);
	result = (SwitchboardPlugLocaleInstallerUbuntuInstaller*) _tmp0_;
	return result;
}

static SwitchboardPlugLocaleInstallerUbuntuInstaller*
switchboard_plug_locale_installer_ubuntu_installer_construct (GType object_type)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller * self = NULL;
	self = (SwitchboardPlugLocaleInstallerUbuntuInstaller*) g_object_new (object_type, NULL);
	return self;
}

static SwitchboardPlugLocaleInstallerUbuntuInstaller*
switchboard_plug_locale_installer_ubuntu_installer_new (void)
{
	return switchboard_plug_locale_installer_ubuntu_installer_construct (SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER);
}

static void
switchboard_plug_locale_installer_ubuntu_installer_install_data_free (gpointer _data)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_;
	_data_ = _data;
	_g_free0 (_data_->language);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_locale_installer_ubuntu_installer_install (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                            const gchar* language,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_installer_ubuntu_installer_install_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (language);
	_g_free0 (_data_->language);
	_data_->language = _tmp1_;
	switchboard_plug_locale_installer_ubuntu_installer_install_co (_data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_install_finish (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
switchboard_plug_locale_installer_ubuntu_installer_install_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_installer_ubuntu_installer_install_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_install_co (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	switchboard_plug_locale_installer_ubuntu_installer_get_permission (switchboard_plug_locale_installer_ubuntu_installer_install_ready, _data_);
	return FALSE;
	_state_1:
	_data_->has_permission = switchboard_plug_locale_installer_ubuntu_installer_get_permission_finish (_data_->_res_);
	if (!_data_->has_permission) {
		_data_->_tmp0_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_ACCESS_DENIED, "");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (_data_->self, SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL);
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = switchboard_plug_locale_installer_ubuntu_installer_get_remaining_packages_for_language (_data_->self, _data_->language, &_data_->_tmp1_);
	_data_->packages = _data_->_tmp2_;
	_data_->packages_length1 = _data_->_tmp1_;
	_data_->_packages_size_ = _data_->packages_length1;
	switchboard_plug_locale_installer_ubuntu_installer_set_transaction_language_code (_data_->self, _data_->language);
	_data_->_tmp3_ = _data_->packages;
	_data_->_tmp3__length1 = _data_->packages_length1;
	{
		_data_->packet_collection_length1 = 0;
		_data_->_packet_collection_size_ = 0;
		_data_->packet_collection = _data_->_tmp3_;
		_data_->packet_collection_length1 = _data_->_tmp3__length1;
		for (_data_->packet_it = 0; _data_->packet_it < _data_->packet_collection_length1; _data_->packet_it = _data_->packet_it + 1) {
			_data_->_tmp4_ = g_strdup (_data_->packet_collection[_data_->packet_it]);
			_data_->packet = _data_->_tmp4_;
			{
				_data_->_tmp5_ = _data_->packet;
				g_message ("UbuntuInstaller.vala:73: Packet: %s", _data_->_tmp5_);
				_g_free0 (_data_->packet);
			}
		}
	}
	{
		_data_->_tmp6_ = _data_->self->priv->aptd;
		_data_->_tmp7_ = _data_->packages;
		_data_->_tmp7__length1 = _data_->packages_length1;
		_data_->_state_ = 2;
		aptd_proxy_install_packages (_data_->_tmp6_, _data_->_tmp7_, (gint) _data_->_tmp7__length1, switchboard_plug_locale_installer_ubuntu_installer_install_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = aptd_proxy_install_packages_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->transaction_id = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->self->priv->transactions;
		_data_->_tmp10_ = _data_->transaction_id;
		_data_->_tmp11_ = g_strconcat ("i-", _data_->language, NULL);
		_data_->_tmp12_ = _data_->_tmp11_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->transaction_id;
		switchboard_plug_locale_installer_ubuntu_installer_run_transaction (_data_->self, _data_->_tmp13_);
		_g_free0 (_data_->transaction_id);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
		_data_->_inner_error0_ = _data_->_tmp15_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->packages = (_vala_array_free (_data_->packages, _data_->packages_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->packages = (_vala_array_free (_data_->packages, _data_->packages_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_data_free (gpointer _data)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData, _data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                            GAsyncReadyCallback _callback_,
                                                                            gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_co (_data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_finish (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                   GAsyncResult* _res_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_ready (GObject* source_object,
                                                                                  GAsyncResult* _res_,
                                                                                  gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_co (_data_);
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_co (SwitchboardPlugLocaleInstallerUbuntuInstallerCheckMissingLanguagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_state_ = 1;
	switchboard_plug_locale_utils_get_missing_languages (switchboard_plug_locale_installer_ubuntu_installer_check_missing_languages_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = switchboard_plug_locale_utils_get_missing_languages_finish (_data_->_res_, &_data_->_tmp0_);
	_data_->self->priv->missing_packages = (_vala_array_free (_data_->self->priv->missing_packages, _data_->self->priv->missing_packages_length1, (GDestroyNotify) g_free), NULL);
	_data_->self->priv->missing_packages = _data_->_tmp1_;
	_data_->self->priv->missing_packages_length1 = _data_->_tmp0_;
	_data_->self->priv->_missing_packages_size_ = _data_->self->priv->missing_packages_length1;
	_data_->_tmp2_ = _data_->self->priv->missing_packages;
	_data_->_tmp2__length1 = _data_->self->priv->missing_packages_length1;
	g_signal_emit (_data_->self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_CHECK_MISSING_FINISHED_SIGNAL], 0, _data_->_tmp2_, (gint) _data_->_tmp2__length1);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_data_free (gpointer _data)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData, _data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                              GAsyncReadyCallback _callback_,
                                                                              gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_co (_data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_finish (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                     GAsyncResult* _res_,
                                                                                     GError** error)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_ready (GObject* source_object,
                                                                                    GAsyncResult* _res_,
                                                                                    gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_co (_data_);
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_co (SwitchboardPlugLocaleInstallerUbuntuInstallerInstallMissingLanguagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->missing_packages;
	_data_->_tmp1__length1 = _data_->self->priv->missing_packages_length1;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->missing_packages;
		_data_->_tmp2__length1 = _data_->self->priv->missing_packages_length1;
		_data_->_tmp0_ = _data_->_tmp2__length1 == 0;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	switchboard_plug_locale_installer_ubuntu_installer_get_permission (switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_ready, _data_);
	return FALSE;
	_state_1:
	_data_->has_permission = switchboard_plug_locale_installer_ubuntu_installer_get_permission_finish (_data_->_res_);
	if (!_data_->has_permission) {
		_data_->_tmp3_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_ACCESS_DENIED, "");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (_data_->self, SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_INSTALL_MISSING);
	_data_->_tmp4_ = _data_->self->priv->missing_packages;
	_data_->_tmp4__length1 = _data_->self->priv->missing_packages_length1;
	{
		_data_->package_collection_length1 = 0;
		_data_->_package_collection_size_ = 0;
		_data_->package_collection = _data_->_tmp4_;
		_data_->package_collection_length1 = _data_->_tmp4__length1;
		for (_data_->package_it = 0; _data_->package_it < _data_->package_collection_length1; _data_->package_it = _data_->package_it + 1) {
			_data_->package = _data_->package_collection[_data_->package_it];
			{
				_data_->_tmp5_ = _data_->package;
				g_message ("UbuntuInstaller.vala:103: will install: %s", _data_->_tmp5_);
			}
		}
	}
	{
		_data_->_tmp6_ = _data_->self->priv->aptd;
		_data_->_tmp7_ = _data_->self->priv->missing_packages;
		_data_->_tmp7__length1 = _data_->self->priv->missing_packages_length1;
		_data_->_state_ = 2;
		aptd_proxy_install_packages (_data_->_tmp6_, _data_->_tmp7_, (gint) _data_->_tmp7__length1, switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = aptd_proxy_install_packages_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->transaction_id = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->self->priv->transactions;
		_data_->_tmp10_ = _data_->transaction_id;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp9_, _data_->_tmp10_, "install-missing");
		_data_->_tmp11_ = _data_->transaction_id;
		switchboard_plug_locale_installer_ubuntu_installer_run_transaction (_data_->self, _data_->_tmp11_);
		_g_free0 (_data_->transaction_id);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _g_error_copy0 (_data_->_tmp12_);
		_data_->_inner_error0_ = _data_->_tmp13_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_remove_data_free (gpointer _data)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_;
	_data_ = _data;
	_g_free0 (_data_->languagecode);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData, _data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_remove (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                           const gchar* languagecode,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (languagecode != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_installer_ubuntu_installer_remove_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (languagecode);
	_g_free0 (_data_->languagecode);
	_data_->languagecode = _tmp1_;
	switchboard_plug_locale_installer_ubuntu_installer_remove_co (_data_);
}

void
switchboard_plug_locale_installer_ubuntu_installer_remove_finish (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
switchboard_plug_locale_installer_ubuntu_installer_remove_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_installer_ubuntu_installer_remove_co (_data_);
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_remove_co (SwitchboardPlugLocaleInstallerUbuntuInstallerRemoveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	switchboard_plug_locale_installer_ubuntu_installer_get_permission (switchboard_plug_locale_installer_ubuntu_installer_remove_ready, _data_);
	return FALSE;
	_state_1:
	_data_->has_permission = switchboard_plug_locale_installer_ubuntu_installer_get_permission_finish (_data_->_res_);
	if (!_data_->has_permission) {
		_data_->_tmp0_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_ACCESS_DENIED, "");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (_data_->self, SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_REMOVE);
	switchboard_plug_locale_installer_ubuntu_installer_set_transaction_language_code (_data_->self, _data_->languagecode);
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = switchboard_plug_locale_installer_ubuntu_installer_get_to_remove_packages_for_language (_data_->self, _data_->languagecode, &_data_->_tmp1_);
	_data_->installed = _data_->_tmp2_;
	_data_->installed_length1 = _data_->_tmp1_;
	_data_->_installed_size_ = _data_->installed_length1;
	{
		_data_->_tmp3_ = _data_->self->priv->aptd;
		_data_->_tmp4_ = _data_->installed;
		_data_->_tmp4__length1 = _data_->installed_length1;
		_data_->_state_ = 2;
		aptd_proxy_remove_packages (_data_->_tmp3_, _data_->_tmp4_, (gint) _data_->_tmp4__length1, switchboard_plug_locale_installer_ubuntu_installer_remove_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = aptd_proxy_remove_packages_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->transaction_id = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->self->priv->transactions;
		_data_->_tmp7_ = _data_->transaction_id;
		_data_->_tmp8_ = g_strconcat ("r-", _data_->languagecode, NULL);
		_data_->_tmp9_ = _data_->_tmp8_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		_data_->_tmp10_ = _data_->transaction_id;
		switchboard_plug_locale_installer_ubuntu_installer_run_transaction (_data_->self, _data_->_tmp10_);
		_g_free0 (_data_->transaction_id);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
		_data_->_inner_error0_ = _data_->_tmp12_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->installed = (_vala_array_free (_data_->installed, _data_->installed_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->installed = (_vala_array_free (_data_->installed, _data_->installed_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_get_permission_data_free (gpointer _data)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_;
	_data_ = _data;
	g_slice_free (SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData, _data_);
}

static void
switchboard_plug_locale_installer_ubuntu_installer_get_permission (GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_;
	_data_ = g_slice_new0 (SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_installer_ubuntu_installer_get_permission_data_free);
	switchboard_plug_locale_installer_ubuntu_installer_get_permission_co (_data_);
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_get_permission_finish (GAsyncResult* _res_)
{
	gboolean result;
	SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_get_permission_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_installer_ubuntu_installer_get_permission_co (_data_);
}

static gboolean
switchboard_plug_locale_installer_ubuntu_installer_get_permission_co (SwitchboardPlugLocaleInstallerUbuntuInstallerGetPermissionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plug_locale_installer_ubuntu_installer_permission;
	if (_data_->_tmp0_ == NULL) {
		{
			_data_->_tmp2_ = (PolkitUnixProcess*) polkit_unix_process_new ((gint) getpid ());
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_state_ = 1;
			polkit_permission_new ("io.elementary.settings.locale.administration", (PolkitSubject*) _data_->_tmp3_, NULL, switchboard_plug_locale_installer_ubuntu_installer_get_permission_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp4_ = polkit_permission_new_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_g_object_unref0 (_data_->_tmp3_);
			_data_->_tmp1_ = _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp6_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_object_unref0 (switchboard_plug_locale_installer_ubuntu_installer_permission);
			switchboard_plug_locale_installer_ubuntu_installer_permission = _data_->_tmp6_;
			_g_object_unref0 (_data_->_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_critical ("UbuntuInstaller.vala:144: %s", _data_->_tmp8_);
			_data_->result = FALSE;
			_g_error_free0 (_data_->e);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = switchboard_plug_locale_installer_ubuntu_installer_permission;
	_data_->_tmp10_ = g_permission_get_allowed ((GPermission*) _data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	if (!_data_->_tmp11_) {
		{
			_data_->_tmp12_ = switchboard_plug_locale_installer_ubuntu_installer_permission;
			_data_->_state_ = 2;
			g_permission_acquire_async ((GPermission*) _data_->_tmp12_, NULL, switchboard_plug_locale_installer_ubuntu_installer_get_permission_ready, _data_);
			return FALSE;
			_state_2:
			g_permission_acquire_finish ((GPermission*) _data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp13_ = _data_->_vala1_e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_critical ("UbuntuInstaller.vala:153: %s", _data_->_tmp14_);
			_data_->result = FALSE;
			_g_error_free0 (_data_->_vala1_e);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
switchboard_plug_locale_installer_ubuntu_installer_cancel_install (SwitchboardPlugLocaleInstallerUbuntuInstaller* self)
{
	gboolean _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_install_cancellable;
	if (_tmp0_) {
		g_warning ("UbuntuInstaller.vala:163: cancel_install");
		{
			AptdTransactionProxy* _tmp1_;
			_tmp1_ = self->priv->proxy;
			aptd_transaction_proxy_cancel (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("UbuntuInstaller.vala:167: cannot cancel installation:%s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
		self = _data2_->self;
		_g_free0 (_data2_->transaction_id);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda7_ (Block2Data* _data2_)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller* self;
	self = _data2_->self;
	switchboard_plug_locale_installer_ubuntu_installer_on_apt_finshed (self, _data2_->transaction_id, TRUE);
}

static void
___lambda7__aptd_transaction_proxy_finished (AptdTransactionProxy* _sender,
                                             const gchar* transaction_id,
                                             gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda8_ (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
            const gchar* prop,
            GVariant* val)
{
	g_return_if_fail (prop != NULL);
	g_return_if_fail (val != NULL);
	if (g_strcmp0 (prop, "Progress") == 0) {
		g_signal_emit (self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_PROGRESS_CHANGED_SIGNAL], 0, (gint) g_variant_get_int32 (val));
	}
	if (g_strcmp0 (prop, "Cancellable") == 0) {
		switchboard_plug_locale_installer_ubuntu_installer_set_install_cancellable (self, g_variant_get_boolean (val));
	}
}

static void
___lambda8__aptd_transaction_proxy_property_changed (AptdTransactionProxy* _sender,
                                                     const gchar* property,
                                                     GVariant* variant,
                                                     gpointer self)
{
	__lambda8_ ((SwitchboardPlugLocaleInstallerUbuntuInstaller*) self, property, variant);
}

static void
switchboard_plug_locale_installer_ubuntu_installer_run_transaction (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                    const gchar* transaction_id)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	AptdTransactionProxy* _tmp1_;
	AptdTransactionProxy* _tmp2_;
	AptdTransactionProxy* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transaction_id != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (transaction_id);
	_g_free0 (_data2_->transaction_id);
	_data2_->transaction_id = _tmp0_;
	_tmp1_ = aptd_transaction_proxy_new ();
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp1_;
	_tmp2_ = self->priv->proxy;
	g_signal_connect_data (_tmp2_, "finished", (GCallback) ___lambda7__aptd_transaction_proxy_finished, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp3_ = self->priv->proxy;
	g_signal_connect_object (_tmp3_, "property-changed", (GCallback) ___lambda8__aptd_transaction_proxy_property_changed, self, 0);
	{
		AptdTransactionProxy* _tmp4_;
		AptdTransactionProxy* _tmp5_;
		AptdTransactionProxy* _tmp6_;
		_tmp4_ = self->priv->proxy;
		aptd_transaction_proxy_connect_to_aptd (_tmp4_, _data2_->transaction_id, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->proxy;
		aptd_transaction_proxy_simulate (_tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->proxy;
		aptd_transaction_proxy_run (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		switchboard_plug_locale_installer_ubuntu_installer_on_apt_finshed (self, _data2_->transaction_id, FALSE);
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("UbuntuInstaller.vala:195: Could no run transaction: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_on_apt_finshed (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                   const gchar* id,
                                                                   gboolean success)
{
	GeeHashMap* _tmp1_;
	gchar* action = NULL;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	gchar* lang = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	if (!success) {
		GeeHashMap* _tmp0_;
		g_signal_emit (self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FAILED_SIGNAL], 0);
		_tmp0_ = self->priv->transactions;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, id, NULL);
		return;
	}
	_tmp1_ = self->priv->transactions;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, id)) {
		return;
	}
	_tmp2_ = self->priv->transactions;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, id);
	action = (gchar*) _tmp3_;
	_tmp4_ = action;
	if (g_strcmp0 (_tmp4_, "install-missing") == 0) {
		GeeHashMap* _tmp5_;
		g_signal_emit (self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FINISHED_SIGNAL], 0, "");
		_tmp5_ = self->priv->transactions;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, id, NULL);
		_g_free0 (action);
		return;
	}
	_tmp6_ = action;
	_tmp7_ = action;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_slice (_tmp6_, (glong) 2, (glong) _tmp9_);
	lang = _tmp10_;
	if (success) {
		_tmp11_ = "success";
	} else {
		_tmp11_ = "failed";
	}
	g_message ("UbuntuInstaller.vala:219: ID %s -> %s", id, _tmp11_);
	_tmp12_ = action;
	_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) 1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp14_, "i") == 0;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = lang;
		g_signal_emit (self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FINISHED_SIGNAL], 0, _tmp16_);
	} else {
		const gchar* _tmp17_;
		_tmp17_ = lang;
		g_signal_emit (self, switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_REMOVE_FINISHED_SIGNAL], 0, _tmp17_);
	}
	_tmp18_ = self->priv->transactions;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp18_, id, NULL);
	_g_free0 (lang);
	_g_free0 (action);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar**
switchboard_plug_locale_installer_ubuntu_installer_get_remaining_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                        const gchar* langcode,
                                                                                        gint* result_length1)
{
	gchar* output = NULL;
	gint status = 0;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (langcode != NULL, NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp0_ = g_strdup (SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_LANGUAGE_CHECKER);
		_tmp1_ = g_strdup ("-l");
		_tmp2_ = g_strdup (langcode);
		_tmp3_ = g_new0 (gchar*, 4 + 1);
		_tmp3_[0] = _tmp0_;
		_tmp3_[1] = _tmp1_;
		_tmp3_[2] = _tmp2_;
		_tmp3_[3] = NULL;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 4;
		_tmp6_ = _tmp5_ = g_get_environ ();
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _vala_array_length (_tmp5_);
		g_spawn_sync (NULL, _tmp4_, _tmp7_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp8_, NULL, &_tmp9_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp8_;
		status = _tmp9_;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("UbuntuInstaller.vala:244: Could not get remaining language packages fo" \
"r %s", langcode);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = string_strip (output);
	_tmp11_ = _tmp10_;
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, " ", 0);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _vala_array_length (_tmp12_);
	_g_free0 (_tmp11_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (output);
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar**
switchboard_plug_locale_installer_ubuntu_installer_get_to_remove_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                        const gchar* language,
                                                                                        gint* result_length1)
{
	gchar** installed = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint installed_length1;
	gint _installed_size_;
	gchar** multilang_packs = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint multilang_packs_length1;
	gint _multilang_packs_size_;
	gchar** missing_packs = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint missing_packs_length1;
	gint _missing_packs_size_;
	GeeArrayList* removable = NULL;
	GeeArrayList* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeArrayList* _tmp19_;
	gint _tmp20_ = 0;
	gpointer* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (language != NULL, NULL);
	_tmp1_ = switchboard_plug_locale_installer_ubuntu_installer_get_installed_packages_for_language (self, language, &_tmp0_);
	installed = _tmp1_;
	installed_length1 = _tmp0_;
	_installed_size_ = installed_length1;
	_tmp2_ = g_strdup ("chromium-browser-l10n");
	_tmp3_ = g_strdup ("poppler-data");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	multilang_packs = _tmp4_;
	multilang_packs_length1 = 2;
	_multilang_packs_size_ = multilang_packs_length1;
	_tmp6_ = switchboard_plug_locale_installer_ubuntu_installer_get_remaining_packages_for_language (self, language, &_tmp5_);
	missing_packs = _tmp6_;
	missing_packs_length1 = _tmp5_;
	_missing_packs_size_ = missing_packs_length1;
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	removable = _tmp7_;
	_tmp8_ = installed;
	_tmp8__length1 = installed_length1;
	{
		gchar** packet_collection = NULL;
		gint packet_collection_length1 = 0;
		gint _packet_collection_size_ = 0;
		gint packet_it = 0;
		packet_collection = _tmp8_;
		packet_collection_length1 = _tmp8__length1;
		for (packet_it = 0; packet_it < packet_collection_length1; packet_it = packet_it + 1) {
			gchar* _tmp9_;
			gchar* packet = NULL;
			_tmp9_ = g_strdup (packet_collection[packet_it]);
			packet = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				_tmp12_ = packet;
				_tmp13_ = multilang_packs;
				_tmp13__length1 = multilang_packs_length1;
				if (!_vala_string_array_contains (_tmp13_, _tmp13__length1, _tmp12_)) {
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = packet;
					_tmp15_ = missing_packs;
					_tmp15__length1 = missing_packs_length1;
					_tmp11_ = !_vala_string_array_contains (_tmp15_, _tmp15__length1, _tmp14_);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					const gchar* _tmp16_;
					_tmp16_ = packet;
					_tmp10_ = !string_contains (_tmp16_, "font");
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					GeeArrayList* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = removable;
					_tmp18_ = packet;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
				}
				_g_free0 (packet);
			}
		}
	}
	_tmp19_ = removable;
	_tmp21_ = gee_collection_to_array ((GeeCollection*) _tmp19_, &_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _tmp20_;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_g_object_unref0 (removable);
	missing_packs = (_vala_array_free (missing_packs, missing_packs_length1, (GDestroyNotify) g_free), NULL);
	multilang_packs = (_vala_array_free (multilang_packs, multilang_packs_length1, (GDestroyNotify) g_free), NULL);
	installed = (_vala_array_free (installed, installed_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
switchboard_plug_locale_installer_ubuntu_installer_get_installed_packages_for_language (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                        const gchar* langcode,
                                                                                        gint* result_length1)
{
	gchar* output = NULL;
	gint status = 0;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (langcode != NULL, NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp0_ = g_strdup (SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_LANGUAGE_CHECKER);
		_tmp1_ = g_strdup ("--show-installed");
		_tmp2_ = g_strdup ("-l");
		_tmp3_ = g_strdup (langcode);
		_tmp4_ = g_new0 (gchar*, 5 + 1);
		_tmp4_[0] = _tmp0_;
		_tmp4_[1] = _tmp1_;
		_tmp4_[2] = _tmp2_;
		_tmp4_[3] = _tmp3_;
		_tmp4_[4] = NULL;
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 5;
		_tmp7_ = _tmp6_ = g_get_environ ();
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		g_spawn_sync (NULL, _tmp5_, _tmp8_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, NULL, &_tmp10_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp9_;
		status = _tmp10_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("UbuntuInstaller.vala:283: Could not get remaining language packages fo" \
"r %s", langcode);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = string_strip (output);
	_tmp12_ = _tmp11_;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " ", 0);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _vala_array_length (_tmp13_);
	_g_free0 (_tmp12_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp15__length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_free0 (output);
	return result;
}

gboolean
switchboard_plug_locale_installer_ubuntu_installer_get_install_cancellable (SwitchboardPlugLocaleInstallerUbuntuInstaller* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_install_cancellable;
	return result;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_set_install_cancellable (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_installer_ubuntu_installer_get_install_cancellable (self);
	if (old_value != value) {
		self->priv->_install_cancellable = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY]);
	}
}

SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode
switchboard_plug_locale_installer_ubuntu_installer_get_transaction_mode (SwitchboardPlugLocaleInstallerUbuntuInstaller* self)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_transaction_mode;
	return result;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                         SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode value)
{
	SwitchboardPlugLocaleInstallerUbuntuInstallerTransactionMode old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_installer_ubuntu_installer_get_transaction_mode (self);
	if (old_value != value) {
		self->priv->_transaction_mode = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY]);
	}
}

const gchar*
switchboard_plug_locale_installer_ubuntu_installer_get_transaction_language_code (SwitchboardPlugLocaleInstallerUbuntuInstaller* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_transaction_language_code;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_set_transaction_language_code (SwitchboardPlugLocaleInstallerUbuntuInstaller* self,
                                                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_installer_ubuntu_installer_get_transaction_language_code (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_transaction_language_code);
		self->priv->_transaction_language_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static GObject *
switchboard_plug_locale_installer_ubuntu_installer_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleInstallerUbuntuInstaller * self;
	GeeHashMap* _tmp0_;
	AptdProxy* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_installer_ubuntu_installer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, SwitchboardPlugLocaleInstallerUbuntuInstaller);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->transactions);
	self->priv->transactions = _tmp0_;
	_tmp1_ = aptd_proxy_new ();
	_g_object_unref0 (self->priv->aptd);
	self->priv->aptd = _tmp1_;
	{
		AptdProxy* _tmp2_;
		_tmp2_ = self->priv->aptd;
		aptd_proxy_connect_to_aptd (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("UbuntuInstaller.vala:58: Could not connect to APT daemon");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_class_init (SwitchboardPlugLocaleInstallerUbuntuInstallerClass * klass,
                                                               gpointer klass_data)
{
	switchboard_plug_locale_installer_ubuntu_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleInstallerUbuntuInstaller_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_installer_ubuntu_installer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_installer_ubuntu_installer_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_installer_ubuntu_installer_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_installer_ubuntu_installer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY] = g_param_spec_boolean ("install-cancellable", "install-cancellable", "install-cancellable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY] = g_param_spec_enum ("transaction-mode", "transaction-mode", "transaction-mode", SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TYPE_TRANSACTION_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY, switchboard_plug_locale_installer_ubuntu_installer_properties[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY] = g_param_spec_string ("transaction-language-code", "transaction-language-code", "transaction-language-code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FINISHED_SIGNAL] = g_signal_new ("install-finished", SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_FAILED_SIGNAL] = g_signal_new ("install-failed", SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_REMOVE_FINISHED_SIGNAL] = g_signal_new ("remove-finished", SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_CHECK_MISSING_FINISHED_SIGNAL] = g_signal_new ("check-missing-finished", SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT, G_TYPE_NONE, 2, G_TYPE_STRV, G_TYPE_INT);
	switchboard_plug_locale_installer_ubuntu_installer_signals[SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_PROGRESS_CHANGED_SIGNAL] = g_signal_new ("progress-changed", SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
switchboard_plug_locale_installer_ubuntu_installer_instance_init (SwitchboardPlugLocaleInstallerUbuntuInstaller * self,
                                                                  gpointer klass)
{
	self->priv = switchboard_plug_locale_installer_ubuntu_installer_get_instance_private (self);
	self->priv->missing_packages = NULL;
	self->priv->missing_packages_length1 = 0;
	self->priv->_missing_packages_size_ = self->priv->missing_packages_length1;
}

static void
switchboard_plug_locale_installer_ubuntu_installer_finalize (GObject * obj)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, SwitchboardPlugLocaleInstallerUbuntuInstaller);
	_g_object_unref0 (self->priv->aptd);
	_g_object_unref0 (self->priv->proxy);
	self->priv->missing_packages = (_vala_array_free (self->priv->missing_packages, self->priv->missing_packages_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_transaction_language_code);
	_g_object_unref0 (self->priv->transactions);
	G_OBJECT_CLASS (switchboard_plug_locale_installer_ubuntu_installer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_installer_ubuntu_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleInstallerUbuntuInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_installer_ubuntu_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleInstallerUbuntuInstaller), 0, (GInstanceInitFunc) switchboard_plug_locale_installer_ubuntu_installer_instance_init, NULL };
	GType switchboard_plug_locale_installer_ubuntu_installer_type_id;
	switchboard_plug_locale_installer_ubuntu_installer_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugLocaleInstallerUbuntuInstaller", &g_define_type_info, 0);
	SwitchboardPlugLocaleInstallerUbuntuInstaller_private_offset = g_type_add_instance_private (switchboard_plug_locale_installer_ubuntu_installer_type_id, sizeof (SwitchboardPlugLocaleInstallerUbuntuInstallerPrivate));
	return switchboard_plug_locale_installer_ubuntu_installer_type_id;
}

GType
switchboard_plug_locale_installer_ubuntu_installer_get_type (void)
{
	static gsize switchboard_plug_locale_installer_ubuntu_installer_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_installer_ubuntu_installer_type_id__once)) {
		GType switchboard_plug_locale_installer_ubuntu_installer_type_id;
		switchboard_plug_locale_installer_ubuntu_installer_type_id = switchboard_plug_locale_installer_ubuntu_installer_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_installer_ubuntu_installer_type_id__once, switchboard_plug_locale_installer_ubuntu_installer_type_id);
	}
	return switchboard_plug_locale_installer_ubuntu_installer_type_id__once;
}

static void
_vala_switchboard_plug_locale_installer_ubuntu_installer_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, SwitchboardPlugLocaleInstallerUbuntuInstaller);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_locale_installer_ubuntu_installer_get_install_cancellable (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY:
		g_value_set_enum (value, switchboard_plug_locale_installer_ubuntu_installer_get_transaction_mode (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_installer_ubuntu_installer_get_transaction_language_code (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_installer_ubuntu_installer_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec)
{
	SwitchboardPlugLocaleInstallerUbuntuInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_INSTALLER_TYPE_UBUNTU_INSTALLER, SwitchboardPlugLocaleInstallerUbuntuInstaller);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_INSTALL_CANCELLABLE_PROPERTY:
		switchboard_plug_locale_installer_ubuntu_installer_set_install_cancellable (self, g_value_get_boolean (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_MODE_PROPERTY:
		switchboard_plug_locale_installer_ubuntu_installer_set_transaction_mode (self, g_value_get_enum (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_INSTALLER_UBUNTU_INSTALLER_TRANSACTION_LANGUAGE_CODE_PROPERTY:
		switchboard_plug_locale_installer_ubuntu_installer_set_transaction_language_code (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

