/* DriversView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DriversView.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include "system.h"
#include <gtk/gtk.h>
#include <granite-7.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_DRIVERS_VIEW_0_PROPERTY,
	ABOUT_DRIVERS_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_drivers_view_properties[ABOUT_DRIVERS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _AboutDriversViewUpdateStateData AboutDriversViewUpdateStateData;

struct _AboutDriversViewPrivate {
	GtkStack* stack;
	GtkListBox* devices_list;
	GranitePlaceholder* progress_placeholder;
	GranitePlaceholder* error_placeholder;
	Drivers* driver_proxy;
	gchar* error_message;
};

struct _Block4Data {
	int _ref_count_;
	AboutDriversView* self;
	AboutDriverRow* row;
};

struct _AboutDriversViewUpdateStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutDriversView* self;
	Drivers* _tmp0_;
	DriversCurrentState current_state;
	DriversCurrentState _tmp1_;
	Drivers* _tmp2_;
	DriversCurrentState _tmp3_;
	DriversCurrentState _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	DriversCurrentState _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBoxRow* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBoxRow* _tmp14_;
	GtkStack* _tmp15_;
	GtkListBox* _tmp16_;
	GtkListBoxRow* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GtkListBoxRow* _tmp20_;
	GHashTable* drivers;
	Drivers* _tmp21_;
	GHashTable* _tmp22_;
	GHashTable* _tmp23_;
	GList* _tmp24_;
	GList* device_collection;
	GList* device_it;
	const gchar* device;
	AboutDriverRow* last_row;
	GHashTable* _tmp25_;
	const gchar* _tmp26_;
	gconstpointer _tmp27_;
	GList* _tmp28_;
	GList* driver_collection;
	GList* driver_it;
	const gchar* driver;
	Block4Data* _data4_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GHashTable* _tmp31_;
	const gchar* _tmp32_;
	gconstpointer _tmp33_;
	const gchar* _tmp34_;
	gconstpointer _tmp35_;
	AboutDriverRow* _tmp36_;
	GtkListBox* _tmp37_;
	AboutDriverRow* _tmp38_;
	AboutDriverRow* _tmp39_;
	AboutDriverRow* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkCheckButton* _tmp42_;
	AboutDriverRow* _tmp43_;
	GtkCheckButton* _tmp44_;
	GtkCheckButton* _tmp45_;
	AboutDriverRow* _tmp46_;
	AboutDriverRow* _tmp47_;
	AboutDriverRow* _tmp48_;
	GError* _vala1_e;
	GError* _tmp49_;
	const gchar* _tmp50_;
	GtkStack* _tmp51_;
	GranitePlaceholder* _tmp52_;
	DriversCurrentState _tmp53_;
	const gchar* _tmp54_;
	GtkStack* _tmp55_;
	DriversCurrentState _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	GError* _inner_error0_;
};

static gint AboutDriversView_private_offset;
static gpointer about_drivers_view_parent_class = NULL;

static void about_drivers_view_update_state_data_free (gpointer _data);
static void about_drivers_view_update_state (AboutDriversView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void about_drivers_view_update_state_finish (AboutDriversView* self,
                                             GAsyncResult* _res_);
static gboolean about_drivers_view_update_state_co (AboutDriversViewUpdateStateData* _data_);
static void about_drivers_view_update_state_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ________lambda35_ (Block4Data* _data4_);
static void _________lambda35__about_driver_row_install (AboutDriverRow* _sender,
                                                  gpointer self);
static void about_drivers_view_header_func (AboutDriversView* self,
                                     GtkListBoxRow* row,
                                     GtkListBoxRow* before);
static GObject * about_drivers_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _about_drivers_view_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                      GtkListBoxRow* before,
                                                                      gpointer self);
static void _about_drivers_view___lambda36_ (AboutDriversView* self,
                                      GObject* obj,
                                      GAsyncResult* res);
static void _about_drivers_view_update_state_drivers_state_changed (Drivers* _sender,
                                                             gpointer self);
static void __about_drivers_view___lambda36__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self);
static void _about_drivers_view___lambda37_ (AboutDriversView* self);
static void __about_drivers_view___lambda37__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _about_drivers_view___lambda38_ (AboutDriversView* self);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void __about_drivers_view___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void about_drivers_view_finalize (GObject * obj);
static GType about_drivers_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
about_drivers_view_get_instance_private (AboutDriversView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutDriversView_private_offset);
}

AboutDriversView*
about_drivers_view_construct (GType object_type)
{
	AboutDriversView * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	_tmp1_ = _tmp0_;
	self = (AboutDriversView*) g_object_new (object_type, "icon", _tmp1_, "title", _ ("Drivers"), "description", _ ("Broadcom® Wi-Fi adapters, NVIDIA® graphics, and some virtual machines " \
"may not function properly without additional drivers."), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

AboutDriversView*
about_drivers_view_new (void)
{
	return about_drivers_view_construct (ABOUT_TYPE_DRIVERS_VIEW);
}

static void
about_drivers_view_update_state_data_free (gpointer _data)
{
	AboutDriversViewUpdateStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutDriversViewUpdateStateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_drivers_view_update_state (AboutDriversView* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AboutDriversViewUpdateStateData* _data_;
	AboutDriversView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutDriversViewUpdateStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_drivers_view_update_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_drivers_view_update_state_co (_data_);
}

static void
about_drivers_view_update_state_finish (AboutDriversView* self,
                                        GAsyncResult* _res_)
{
	AboutDriversViewUpdateStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_drivers_view_update_state_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AboutDriversViewUpdateStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_drivers_view_update_state_co (_data_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AboutDriversView* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->row);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
________lambda35_ (Block4Data* _data4_)
{
	AboutDriversView* self;
	Drivers* _tmp0_;
	AboutDriverRow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GranitePlaceholder* _tmp4_;
	AboutDriverRow* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = _data4_->self;
	_tmp0_ = self->priv->driver_proxy;
	_tmp1_ = _data4_->row;
	_tmp2_ = about_driver_row_get_driver_name (_tmp1_);
	_tmp3_ = _tmp2_;
	drivers_install (_tmp0_, _tmp3_, NULL, NULL);
	_tmp4_ = self->priv->progress_placeholder;
	_tmp5_ = _data4_->row;
	_tmp6_ = about_driver_row_get_driver_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Installing %s…"), _tmp7_);
	_tmp9_ = _tmp8_;
	granite_placeholder_set_title (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
}

static void
_________lambda35__about_driver_row_install (AboutDriverRow* _sender,
                                             gpointer self)
{
	________lambda35_ (self);
}

static gboolean
about_drivers_view_update_state_co (AboutDriversViewUpdateStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->driver_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = _data_->self->priv->driver_proxy;
		memset (&_data_->_tmp3_, 0, sizeof (DriversCurrentState));
		_data_->_state_ = 1;
		drivers_get_current_state (_data_->_tmp2_, about_drivers_view_update_state_ready, _data_);
		return FALSE;
		_state_1:
		drivers_get_current_state_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		memset (&_data_->_tmp1_, 0, sizeof (DriversCurrentState));
		drivers_current_state_destroy (&_data_->current_state);
		_data_->current_state = _data_->_tmp4_;
		drivers_current_state_destroy (&_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_critical ("DriversView.vala:115: Failed to get current state from Updates Backend" \
": %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
		drivers_current_state_destroy (&_data_->current_state);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		drivers_current_state_destroy (&_data_->current_state);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->current_state;
	switch (_data_->_tmp7_.state) {
		case DRIVERS_STATE_UP_TO_DATE:
		{
			_data_->_tmp8_ = _data_->self->priv->stack;
			gtk_stack_set_visible_child_name (_data_->_tmp8_, "none");
			break;
		}
		case DRIVERS_STATE_CHECKING:
		{
			_data_->_tmp9_ = _data_->self->priv->stack;
			gtk_stack_set_visible_child_name (_data_->_tmp9_, "scrolled");
			while (TRUE) {
				_data_->_tmp10_ = _data_->self->priv->devices_list;
				_data_->_tmp11_ = gtk_list_box_get_row_at_index (_data_->_tmp10_, 0);
				if (!(_data_->_tmp11_ != NULL)) {
					break;
				}
				_data_->_tmp12_ = _data_->self->priv->devices_list;
				_data_->_tmp13_ = _data_->self->priv->devices_list;
				_data_->_tmp14_ = gtk_list_box_get_row_at_index (_data_->_tmp13_, 0);
				gtk_list_box_remove (_data_->_tmp12_, (GtkWidget*) _data_->_tmp14_);
			}
			break;
		}
		case DRIVERS_STATE_AVAILABLE:
		{
			_data_->_tmp15_ = _data_->self->priv->stack;
			gtk_stack_set_visible_child_name (_data_->_tmp15_, "scrolled");
			while (TRUE) {
				_data_->_tmp16_ = _data_->self->priv->devices_list;
				_data_->_tmp17_ = gtk_list_box_get_row_at_index (_data_->_tmp16_, 0);
				if (!(_data_->_tmp17_ != NULL)) {
					break;
				}
				_data_->_tmp18_ = _data_->self->priv->devices_list;
				_data_->_tmp19_ = _data_->self->priv->devices_list;
				_data_->_tmp20_ = gtk_list_box_get_row_at_index (_data_->_tmp19_, 0);
				gtk_list_box_remove (_data_->_tmp18_, (GtkWidget*) _data_->_tmp20_);
			}
			{
				_data_->_tmp21_ = _data_->self->priv->driver_proxy;
				_data_->_state_ = 2;
				drivers_get_available_drivers (_data_->_tmp21_, about_drivers_view_update_state_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp22_ = drivers_get_available_drivers_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
				_data_->drivers = _data_->_tmp22_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_data_->_tmp23_ = _data_->drivers;
				_data_->_tmp24_ = g_hash_table_get_keys (_data_->_tmp23_);
				{
					_data_->device_collection = _data_->_tmp24_;
					for (_data_->device_it = _data_->device_collection; _data_->device_it != NULL; _data_->device_it = _data_->device_it->next) {
						_data_->device = (const gchar*) _data_->device_it->data;
						{
							_data_->last_row = NULL;
							_data_->_tmp25_ = _data_->drivers;
							_data_->_tmp26_ = _data_->device;
							_data_->_tmp27_ = g_hash_table_lookup (_data_->_tmp25_, _data_->_tmp26_);
							_data_->_tmp28_ = g_hash_table_get_keys ((GHashTable*) _data_->_tmp27_);
							{
								_data_->driver_collection = _data_->_tmp28_;
								for (_data_->driver_it = _data_->driver_collection; _data_->driver_it != NULL; _data_->driver_it = _data_->driver_it->next) {
									_data_->driver = (const gchar*) _data_->driver_it->data;
									{
										_data_->_data4_ = g_slice_new0 (Block4Data);
										_data_->_data4_->_ref_count_ = 1;
										_data_->_data4_->self = g_object_ref (_data_->self);
										_data_->_tmp29_ = _data_->device;
										_data_->_tmp30_ = _data_->driver;
										_data_->_tmp31_ = _data_->drivers;
										_data_->_tmp32_ = _data_->device;
										_data_->_tmp33_ = g_hash_table_lookup (_data_->_tmp31_, _data_->_tmp32_);
										_data_->_tmp34_ = _data_->driver;
										_data_->_tmp35_ = g_hash_table_lookup ((GHashTable*) _data_->_tmp33_, _data_->_tmp34_);
										_data_->_tmp36_ = about_driver_row_new (_data_->_tmp29_, _data_->_tmp30_, (gboolean) ((gintptr) _data_->_tmp35_));
										g_object_ref_sink (_data_->_tmp36_);
										_data_->_data4_->row = _data_->_tmp36_;
										_data_->_tmp37_ = _data_->self->priv->devices_list;
										_data_->_tmp38_ = _data_->_data4_->row;
										gtk_list_box_append (_data_->_tmp37_, (GtkWidget*) _data_->_tmp38_);
										_data_->_tmp39_ = _data_->last_row;
										if (_data_->_tmp39_ != NULL) {
											_data_->_tmp40_ = _data_->last_row;
											_data_->_tmp41_ = about_driver_row_get_install_button (_data_->_tmp40_);
											_data_->_tmp42_ = _data_->_tmp41_;
											_data_->_tmp43_ = _data_->_data4_->row;
											_data_->_tmp44_ = about_driver_row_get_install_button (_data_->_tmp43_);
											_data_->_tmp45_ = _data_->_tmp44_;
											gtk_check_button_set_group (_data_->_tmp42_, _data_->_tmp45_);
										}
										_data_->_tmp46_ = _data_->_data4_->row;
										_data_->_tmp47_ = _g_object_ref0 (_data_->_tmp46_);
										_g_object_unref0 (_data_->last_row);
										_data_->last_row = _data_->_tmp47_;
										_data_->_tmp48_ = _data_->_data4_->row;
										g_signal_connect_data (_data_->_tmp48_, "install", (GCallback) _________lambda35__about_driver_row_install, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
										block4_data_unref (_data_->_data4_);
										_data_->_data4_ = NULL;
									}
								}
								(_data_->driver_collection == NULL) ? NULL : (_data_->driver_collection = (g_list_free (_data_->driver_collection), NULL));
							}
							_g_object_unref0 (_data_->last_row);
						}
					}
					(_data_->device_collection == NULL) ? NULL : (_data_->device_collection = (g_list_free (_data_->device_collection), NULL));
				}
				_g_hash_table_unref0 (_data_->drivers);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp49_ = _data_->_vala1_e;
				_data_->_tmp50_ = _data_->_tmp49_->message;
				g_warning ("DriversView.vala:161: Failed to get driver list from backend: %s", _data_->_tmp50_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				drivers_current_state_destroy (&_data_->current_state);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case DRIVERS_STATE_DOWNLOADING:
		{
			_data_->_tmp51_ = _data_->self->priv->stack;
			gtk_stack_set_visible_child_name (_data_->_tmp51_, "progress");
			_data_->_tmp52_ = _data_->self->priv->progress_placeholder;
			_data_->_tmp53_ = _data_->current_state;
			_data_->_tmp54_ = _data_->_tmp53_.message;
			granite_placeholder_set_description (_data_->_tmp52_, _data_->_tmp54_);
			break;
		}
		case DRIVERS_STATE_ERROR:
		{
			_data_->_tmp55_ = _data_->self->priv->stack;
			gtk_stack_set_visible_child_name (_data_->_tmp55_, "error");
			_data_->_tmp56_ = _data_->current_state;
			_data_->_tmp57_ = _data_->_tmp56_.message;
			_data_->_tmp58_ = g_strdup (_data_->_tmp57_);
			_g_free0 (_data_->self->priv->error_message);
			_data_->self->priv->error_message = _data_->_tmp58_;
			break;
		}
		default:
		{
			break;
		}
	}
	drivers_current_state_destroy (&_data_->current_state);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_drivers_view_header_func (AboutDriversView* self,
                                GtkListBoxRow* row,
                                GtkListBoxRow* before)
{
	AboutDriverRow* driver1 = NULL;
	AboutDriverRow* _tmp0_;
	gboolean same = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, ABOUT_TYPE_DRIVER_ROW, AboutDriverRow));
	driver1 = _tmp0_;
	same = FALSE;
	if (before != NULL) {
		AboutDriverRow* driver2 = NULL;
		AboutDriverRow* _tmp1_;
		AboutDriverRow* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		AboutDriverRow* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (before, ABOUT_TYPE_DRIVER_ROW, AboutDriverRow));
		driver2 = _tmp1_;
		_tmp2_ = driver1;
		_tmp3_ = about_driver_row_get_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = driver2;
		_tmp6_ = about_driver_row_get_device (_tmp5_);
		_tmp7_ = _tmp6_;
		same = g_strcmp0 (_tmp4_, _tmp7_) == 0;
		_g_object_unref0 (driver2);
	}
	if (!same) {
		GraniteHeaderLabel* header = NULL;
		AboutDriverRow* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GraniteHeaderLabel* _tmp11_;
		AboutDriverRow* _tmp12_;
		GraniteHeaderLabel* _tmp13_;
		_tmp8_ = driver1;
		_tmp9_ = about_driver_row_get_device (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = granite_header_label_new (_tmp10_);
		g_object_ref_sink (_tmp11_);
		header = _tmp11_;
		_tmp12_ = driver1;
		_tmp13_ = header;
		gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp12_, (GtkWidget*) _tmp13_);
		_g_object_unref0 (header);
	}
	_g_object_unref0 (driver1);
}

static void
_about_drivers_view_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                 GtkListBoxRow* before,
                                                                 gpointer self)
{
	about_drivers_view_header_func ((AboutDriversView*) self, row, before);
}

static void
_about_drivers_view_update_state_drivers_state_changed (Drivers* _sender,
                                                        gpointer self)
{
	about_drivers_view_update_state ((AboutDriversView*) self, NULL, NULL);
}

static void
_about_drivers_view___lambda36_ (AboutDriversView* self,
                                 GObject* obj,
                                 GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		Drivers* _tmp0_ = NULL;
		Drivers* _tmp1_;
		Drivers* _tmp2_;
		Drivers* _tmp3_;
		Drivers* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (Drivers*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (Drivers*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->driver_proxy);
		self->priv->driver_proxy = _tmp3_;
		_tmp4_ = self->priv->driver_proxy;
		g_signal_connect_object (_tmp4_, "state-changed", (GCallback) _about_drivers_view_update_state_drivers_state_changed, self, 0);
		about_drivers_view_update_state (self, NULL, NULL);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("DriversView.vala:79: Failed to get driver proxy: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__about_drivers_view___lambda36__gasync_ready_callback (GObject* source_object,
                                                        GAsyncResult* res,
                                                        gpointer self)
{
	_about_drivers_view___lambda36_ ((AboutDriversView*) self, source_object, res);
	g_object_unref (self);
}

static void
_about_drivers_view___lambda37_ (AboutDriversView* self)
{
	Drivers* _tmp0_;
	_tmp0_ = self->priv->driver_proxy;
	if (_tmp0_ != NULL) {
		Drivers* _tmp1_;
		_tmp1_ = self->priv->driver_proxy;
		drivers_check_for_drivers (_tmp1_, FALSE, NULL, NULL);
	}
}

static void
__about_drivers_view___lambda37__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_about_drivers_view___lambda37_ ((AboutDriversView*) self);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
_about_drivers_view___lambda38_ (AboutDriversView* self)
{
	GraniteMessageDialog* message_dialog = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkRoot* _tmp2_;
	GtkWindow* _tmp3_;
	GraniteMessageDialog* _tmp4_ = NULL;
	GraniteMessageDialog* _tmp5_;
	GraniteMessageDialog* _tmp6_;
	const gchar* _tmp7_;
	GraniteMessageDialog* _tmp8_;
	GraniteMessageDialog* _tmp9_;
	GraniteMessageDialog* _tmp10_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
	_tmp4_ = granite_message_dialog_new (_ ("Failed to install"), _ ("This may have been caused by sideloaded or manually compiled software," \
" a third-party software source, or a package manager error. Manually r" \
"efreshing may resolve the issue."), (GIcon*) _tmp1_, GTK_BUTTONS_CLOSE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	message_dialog = _tmp5_;
	_tmp6_ = message_dialog;
	_tmp7_ = self->priv->error_message;
	granite_message_dialog_show_error_details (_tmp6_, _tmp7_);
	_tmp8_ = message_dialog;
	_tmp9_ = message_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp8_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp9_, 0);
	_tmp10_ = message_dialog;
	gtk_window_present ((GtkWindow*) _tmp10_);
	_g_object_unref0 (message_dialog);
}

static void
__about_drivers_view___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_about_drivers_view___lambda38_ ((AboutDriversView*) self);
}

static GObject *
about_drivers_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutDriversView * self;
	GranitePlaceholder* none_placeholder = NULL;
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	GranitePlaceholder* checking_placeholder = NULL;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GranitePlaceholder* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GtkListBox* _tmp7_;
	GranitePlaceholder* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp11_;
	GtkWidget* _tmp12_;
	GtkScrolledWindow* _tmp13_ = NULL;
	GThemedIcon* _tmp14_;
	GranitePlaceholder* _tmp15_ = NULL;
	gchar* _tmp16_;
	GThemedIcon* _tmp17_;
	GranitePlaceholder* _tmp18_ = NULL;
	GtkButton* refresh_button = NULL;
	GranitePlaceholder* _tmp19_;
	GThemedIcon* _tmp20_;
	GThemedIcon* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* more_button = NULL;
	GranitePlaceholder* _tmp24_;
	GThemedIcon* _tmp25_;
	GThemedIcon* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkStack* _tmp29_ = NULL;
	GtkStack* _tmp30_;
	GranitePlaceholder* _tmp31_;
	GtkStack* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkStack* _tmp34_;
	GranitePlaceholder* _tmp35_;
	GtkStack* _tmp36_;
	GranitePlaceholder* _tmp37_;
	GtkFrame* frame = NULL;
	GtkStack* _tmp38_;
	GtkWidget* _tmp39_;
	GtkFrame* _tmp40_ = NULL;
	GtkFrame* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (about_drivers_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_DRIVERS_VIEW, AboutDriversView);
	_tmp0_ = g_strdup (_ ("This device doesn't need any additional drivers."));
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("emblem-default");
	_tmp2_ = granite_placeholder_new (_ ("No drivers available"));
	granite_placeholder_set_description (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	granite_placeholder_set_icon (_tmp2_, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	none_placeholder = _tmp2_;
	_tmp3_ = g_strdup (_ ("Connecting to the driver service and searching for drivers."));
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("sync-synchronizing");
	_tmp5_ = granite_placeholder_new (_ ("Checking for Drivers"));
	granite_placeholder_set_description (_tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	granite_placeholder_set_icon (_tmp5_, (GIcon*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	checking_placeholder = _tmp5_;
	_tmp6_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp6_, TRUE);
	gtk_list_box_set_selection_mode (_tmp6_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp6_;
	_tmp7_ = self->priv->devices_list;
	_tmp8_ = checking_placeholder;
	gtk_list_box_set_placeholder (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->devices_list;
	gtk_list_box_set_header_func (_tmp9_, _about_drivers_view_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp10_ = self->priv->devices_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp11_ = self->priv->devices_list;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	scrolled = _tmp13_;
	_tmp14_ = (GThemedIcon*) g_themed_icon_new ("emblem-synchronized");
	_tmp15_ = granite_placeholder_new ("");
	granite_placeholder_set_icon (_tmp15_, (GIcon*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->progress_placeholder);
	self->priv->progress_placeholder = _tmp15_;
	_tmp16_ = g_strdup (_ ("Manually refreshing driver information may resolve the issue"));
	_tmp17_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp18_ = granite_placeholder_new (_ ("Failed to install driver"));
	granite_placeholder_set_description (_tmp18_, _tmp16_);
	_g_free0 (_tmp16_);
	granite_placeholder_set_icon (_tmp18_, (GIcon*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->error_placeholder);
	self->priv->error_placeholder = _tmp18_;
	_tmp19_ = self->priv->error_placeholder;
	_tmp20_ = (GThemedIcon*) g_themed_icon_new ("sync-synchronizing");
	_tmp21_ = _tmp20_;
	_tmp22_ = granite_placeholder_append_button (_tmp19_, (GIcon*) _tmp21_, _ ("Refresh"), _ ("Refresh driver information"));
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	refresh_button = _tmp23_;
	_tmp24_ = self->priv->error_placeholder;
	_tmp25_ = (GThemedIcon*) g_themed_icon_new ("go-next");
	_tmp26_ = _tmp25_;
	_tmp27_ = granite_placeholder_append_button (_tmp24_, (GIcon*) _tmp26_, _ ("Learn More…"), "");
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp26_);
	more_button = _tmp28_;
	_tmp29_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp29_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp29_;
	_tmp30_ = self->priv->stack;
	_tmp31_ = none_placeholder;
	gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, "none");
	_tmp32_ = self->priv->stack;
	_tmp33_ = scrolled;
	gtk_stack_add_named (_tmp32_, (GtkWidget*) _tmp33_, "scrolled");
	_tmp34_ = self->priv->stack;
	_tmp35_ = self->priv->progress_placeholder;
	gtk_stack_add_named (_tmp34_, (GtkWidget*) _tmp35_, "progress");
	_tmp36_ = self->priv->stack;
	_tmp37_ = self->priv->error_placeholder;
	gtk_stack_add_named (_tmp36_, (GtkWidget*) _tmp37_, "error");
	_tmp38_ = self->priv->stack;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	g_object_ref_sink (_tmp40_);
	frame = _tmp40_;
	_tmp41_ = frame;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp41_);
	g_async_initable_new_async (TYPE_DRIVERS_PROXY, 0, NULL, __about_drivers_view___lambda36__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "io.elementary.settings-daemon", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/io/elementary/settings_daemon", "g-interface-name", "io.elementary.settings_daemon.Drivers", NULL);
	_tmp42_ = refresh_button;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) __about_drivers_view___lambda37__gtk_button_clicked, self, 0);
	_tmp43_ = more_button;
	g_signal_connect_object (_tmp43_, "clicked", (GCallback) __about_drivers_view___lambda38__gtk_button_clicked, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (more_button);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (checking_placeholder);
	_g_object_unref0 (none_placeholder);
	return obj;
}

static void
about_drivers_view_class_init (AboutDriversViewClass * klass,
                               gpointer klass_data)
{
	about_drivers_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutDriversView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_drivers_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_drivers_view_finalize;
}

static void
about_drivers_view_instance_init (AboutDriversView * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = about_drivers_view_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->error_message = _tmp0_;
}

static void
about_drivers_view_finalize (GObject * obj)
{
	AboutDriversView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_DRIVERS_VIEW, AboutDriversView);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->progress_placeholder);
	_g_object_unref0 (self->priv->error_placeholder);
	_g_object_unref0 (self->priv->driver_proxy);
	_g_free0 (self->priv->error_message);
	G_OBJECT_CLASS (about_drivers_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_drivers_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutDriversViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_drivers_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutDriversView), 0, (GInstanceInitFunc) about_drivers_view_instance_init, NULL };
	GType about_drivers_view_type_id;
	about_drivers_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "AboutDriversView", &g_define_type_info, 0);
	AboutDriversView_private_offset = g_type_add_instance_private (about_drivers_view_type_id, sizeof (AboutDriversViewPrivate));
	return about_drivers_view_type_id;
}

GType
about_drivers_view_get_type (void)
{
	static volatile gsize about_drivers_view_type_id__once = 0;
	if (g_once_init_enter (&about_drivers_view_type_id__once)) {
		GType about_drivers_view_type_id;
		about_drivers_view_type_id = about_drivers_view_get_type_once ();
		g_once_init_leave (&about_drivers_view_type_id__once, about_drivers_view_type_id);
	}
	return about_drivers_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

