/* FirmwareView.c generated by valac 0.56.18, the Vala compiler
 * generated from FirmwareView.vala, do not modify */

/*
* Copyright 2020-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "system.h"
#include <gtk/gtk.h>
#include <adwaita.h>
#include <granite-7.h>
#include <glib.h>
#include <fwupd.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <switchboard.h>

#define ABOUT_GETTEXT_PACKAGE "io.elementary.settings.system"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_FIRMWARE_VIEW_0_PROPERTY,
	ABOUT_FIRMWARE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_view_properties[ABOUT_FIRMWARE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _AboutFirmwareViewUpdateListViewData AboutFirmwareViewUpdateListViewData;
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _AboutFirmwareViewUpdateData AboutFirmwareViewUpdateData;
typedef struct _AboutFirmwareViewContinueUpdateData AboutFirmwareViewContinueUpdateData;
typedef struct _AboutFirmwareViewDownloadFileData AboutFirmwareViewDownloadFileData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _AboutFirmwareViewPrivate {
	GtkStack* stack;
	AdwLeaflet* deck;
	AboutFirmwareReleaseView* firmware_release_view;
	GranitePlaceholder* progress_alert_view;
	GranitePlaceholder* placeholder_alert_view;
	GtkListBox* update_list;
	guint num_updates;
	FwupdClient* fwupd_client;
};

struct _AboutFirmwareViewUpdateListViewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GPtrArray* devices;
	FwupdClient* _tmp5_;
	GPtrArray* _tmp6_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GPtrArray* _tmp12_;
	gconstpointer _tmp13_;
	GranitePlaceholder* _tmp14_;
	GranitePlaceholder* _tmp15_;
	GranitePlaceholder* _tmp16_;
	GranitePlaceholder* _tmp17_;
	GtkStack* _tmp18_;
	AdwLeaflet* _tmp19_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	AboutFirmwareView* self;
	FwupdDevice* device;
};

struct _Block6Data {
	int _ref_count_;
	AboutFirmwareView* self;
	FwupdDevice* device;
	FwupdRelease* release;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GraniteMessageDialog* details_dialog;
};

struct _AboutFirmwareViewUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	FwupdDevice* device;
	FwupdRelease* release;
	Block6Data* _data6_;
	GranitePlaceholder* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkStack* _tmp4_;
	GranitePlaceholder* _tmp5_;
	const gchar* detach_caption;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	Block7Data* _data7_;
	gchar* detach_image;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GraniteMessageDialog* _tmp15_;
	GraniteMessageDialog* _tmp16_;
	GraniteMessageDialog* _tmp17_;
};

struct _AboutFirmwareViewContinueUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	FwupdDevice* device;
	FwupdRelease* release;
	GPtrArray* locations;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GPtrArray* _tmp6_;
	gconstpointer _tmp7_;
	gchar* path;
	gchar* _tmp8_;
	FwupdInstallFlags install_flags;
	gboolean _tmp9_;
	FwupdClient* _tmp10_;
	const gchar* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GtkStack* _tmp14_;
	AdwLeaflet* _tmp15_;
	GError* _inner_error0_;
};

struct _AboutFirmwareViewDownloadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	FwupdDevice* device;
	gchar* uri;
	gchar* result;
	GFile* server_file;
	GFile* _tmp0_;
	gchar* path;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* local_file;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	gboolean _result_;
	gboolean _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	AboutFirmwareView* self;
	GraniteMessageDialog* message_dialog;
};

struct _Block9Data {
	int _ref_count_;
	AboutFirmwareView* self;
	GraniteMessageDialog* message_dialog;
};

struct _Block10Data {
	int _ref_count_;
	AboutFirmwareView* self;
	GraniteMessageDialog* dialog;
};

static gint AboutFirmwareView_private_offset;
static gpointer about_firmware_view_parent_class = NULL;

static void about_firmware_view_update_list_view_data_free (gpointer _data);
static void about_firmware_view_update_list_view (AboutFirmwareView* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void about_firmware_view_update_list_view_finish (AboutFirmwareView* self,
                                                  GAsyncResult* _res_);
static gboolean about_firmware_view_update_list_view_co (AboutFirmwareViewUpdateListViewData* _data_);
static void about_firmware_view_update_list_view_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void about_firmware_view_add_device (AboutFirmwareView* self,
                                     FwupdDevice* device);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda26_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void __lambda28_ (AboutFirmwareView* self,
                  FwupdDevice* device,
                  FwupdRelease* release);
static void about_firmware_view_update (AboutFirmwareView* self,
                                 FwupdDevice* device,
                                 FwupdRelease* release,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void about_firmware_view_update_finish (AboutFirmwareView* self,
                                        GAsyncResult* _res_);
static void ___lambda28__about_widgets_firmware_update_row_update (AboutWidgetsFirmwareUpdateRow* _sender,
                                                            FwupdDevice* device,
                                                            FwupdRelease* release,
                                                            gpointer self);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void about_firmware_view_show_release (AboutFirmwareView* self,
                                       GtkListBoxRow* widget);
static void about_firmware_view_on_device_added (AboutFirmwareView* self,
                                          FwupdClient* client,
                                          FwupdDevice* device);
static void about_firmware_view_on_device_removed (AboutFirmwareView* self,
                                            FwupdClient* client,
                                            FwupdDevice* device);
static gint about_firmware_view_compare_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                       AboutWidgetsFirmwareUpdateRow* row2,
                                       AboutFirmwareView* self);
static void about_firmware_view_header_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                      AboutWidgetsFirmwareUpdateRow* row2,
                                      AboutFirmwareView* self);
static void about_firmware_view_update_data_free (gpointer _data);
static gboolean about_firmware_view_update_co (AboutFirmwareViewUpdateData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void about_firmware_view_download_file (AboutFirmwareView* self,
                                        FwupdDevice* device,
                                        const gchar* uri,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gchar* about_firmware_view_download_file_finish (AboutFirmwareView* self,
                                                 GAsyncResult* _res_);
static void about_firmware_view_update_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static GraniteMessageDialog* about_firmware_view_show_details_dialog (AboutFirmwareView* self,
                                                               FwupdDevice* device,
                                                               const gchar* detach_caption,
                                                               const gchar* detach_image);
static void ___lambda30_ (Block7Data* _data7_,
                   gint response);
static void about_firmware_view_continue_update (AboutFirmwareView* self,
                                          FwupdDevice* device,
                                          FwupdRelease* release,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void about_firmware_view_continue_update_finish (AboutFirmwareView* self,
                                                 GAsyncResult* _res_);
static void ____lambda30__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void about_firmware_view_continue_update_data_free (gpointer _data);
static gboolean about_firmware_view_continue_update_co (AboutFirmwareViewContinueUpdateData* _data_);
static void about_firmware_view_continue_update_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void about_firmware_view_show_reboot_dialog (AboutFirmwareView* self);
static void about_firmware_view_show_shutdown_dialog (AboutFirmwareView* self);
static void about_firmware_view_show_error_dialog (AboutFirmwareView* self,
                                            FwupdDevice* device,
                                            const gchar* secondary_text);
static void about_firmware_view_download_file_data_free (gpointer _data);
static gboolean about_firmware_view_download_file_co (AboutFirmwareViewDownloadFileData* _data_);
static void ___lambda29_ (AboutFirmwareView* self,
                   gint64 current_num_bytes,
                   gint64 total_num_bytes);
static void ____lambda29__gfile_progress_callback (gint64 current_num_bytes,
                                            gint64 total_num_bytes,
                                            gpointer self);
static void about_firmware_view_download_file_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda31_ (Block8Data* _data8_,
                  gint response);
static void ___lambda31__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda32_ (Block9Data* _data9_,
                  gint response);
static void ___lambda32__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void about_firmware_view_reboot_to_firmware_setup_clicked (AboutFirmwareView* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda33_ (Block10Data* _data10_,
                  gint _result_);
static void ___lambda33__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static GObject * about_firmware_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void _about_firmware_view_on_device_added_fwupd_client_device_added (FwupdClient* _sender,
                                                                     FwupdDevice* _result_,
                                                                     gpointer self);
static void _about_firmware_view_on_device_removed_fwupd_client_device_removed (FwupdClient* _sender,
                                                                         FwupdDevice* _result_,
                                                                         gpointer self);
static void _about_firmware_view_show_release_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void _about_firmware_view___lambda34_ (AboutFirmwareView* self,
                                       FwupdDevice* device,
                                       FwupdRelease* release);
static void __about_firmware_view___lambda34__about_firmware_release_view_update (AboutFirmwareReleaseView* _sender,
                                                                           FwupdDevice* device,
                                                                           FwupdRelease* release,
                                                                           gpointer self);
static void about_firmware_view_finalize (GObject * obj);
static GType about_firmware_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
about_firmware_view_get_instance_private (AboutFirmwareView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutFirmwareView_private_offset);
}

AboutFirmwareView*
about_firmware_view_construct (GType object_type)
{
	AboutFirmwareView * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	_tmp1_ = _tmp0_;
	self = (AboutFirmwareView*) g_object_new (object_type, "icon", _tmp1_, "title", _ ("Firmware"), "description", _ ("Firmware updates provided by device manufacturers can improve performa" \
"nce and fix critical security issues."), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

AboutFirmwareView*
about_firmware_view_new (void)
{
	return about_firmware_view_construct (ABOUT_TYPE_FIRMWARE_VIEW);
}

static void
about_firmware_view_update_list_view_data_free (gpointer _data)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewUpdateListViewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_firmware_view_update_list_view (AboutFirmwareView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	AboutFirmwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewUpdateListViewData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_update_list_view_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_firmware_view_update_list_view_co (_data_);
}

static void
about_firmware_view_update_list_view_finish (AboutFirmwareView* self,
                                             GAsyncResult* _res_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_firmware_view_update_list_view_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_update_list_view_co (_data_);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
about_firmware_view_update_list_view_co (AboutFirmwareViewUpdateListViewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		_data_->_tmp0_ = _data_->self->priv->update_list;
		_data_->_tmp1_ = gtk_list_box_get_row_at_index (_data_->_tmp0_, 0);
		if (!(_data_->_tmp1_ != NULL)) {
			break;
		}
		_data_->_tmp2_ = _data_->self->priv->update_list;
		_data_->_tmp3_ = _data_->self->priv->update_list;
		_data_->_tmp4_ = gtk_list_box_get_row_at_index (_data_->_tmp3_, 0);
		gtk_list_box_remove (_data_->_tmp2_, (GtkWidget*) _data_->_tmp4_);
	}
	_data_->self->priv->num_updates = (guint) 0;
	{
		_data_->_tmp5_ = _data_->self->priv->fwupd_client;
		_data_->_state_ = 1;
		about_firmware_client_get_devices (_data_->_tmp5_, about_firmware_view_update_list_view_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = about_firmware_client_get_devices_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->devices = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp7_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp7_) {
						_data_->_tmp8_ = _data_->i;
						_data_->i = _data_->_tmp8_ + 1;
					}
					_data_->_tmp7_ = FALSE;
					_data_->_tmp9_ = _data_->devices;
					_data_->_tmp10_ = vala_g_ptr_array_get_length (_data_->_tmp9_);
					_data_->_tmp11_ = _data_->_tmp10_;
					if (!(_data_->i < _data_->_tmp11_)) {
						break;
					}
					_data_->_tmp12_ = _data_->devices;
					_data_->_tmp13_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->i);
					about_firmware_view_add_device (_data_->self, (FwupdDevice*) _data_->_tmp13_);
				}
			}
		}
		_data_->_tmp14_ = _data_->self->priv->placeholder_alert_view;
		granite_placeholder_set_title (_data_->_tmp14_, _ ("Firmware Updates Are Not Available"));
		_data_->_tmp15_ = _data_->self->priv->placeholder_alert_view;
		granite_placeholder_set_description (_data_->_tmp15_, _ ("Firmware updates are not supported on this or any connected devices."));
		_g_ptr_array_unref0 (_data_->devices);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp16_ = _data_->self->priv->placeholder_alert_view;
		granite_placeholder_set_title (_data_->_tmp16_, _ ("The Firmware Service Is Not Available"));
		_data_->_tmp17_ = _data_->self->priv->placeholder_alert_view;
		granite_placeholder_set_description (_data_->_tmp17_, _ ("Please make sure “fwupd” is installed and enabled."));
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->self->priv->stack;
	_data_->_tmp19_ = _data_->self->priv->deck;
	gtk_stack_set_visible_child (_data_->_tmp18_, (GtkWidget*) _data_->_tmp19_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->device);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda28_ (AboutFirmwareView* self,
             FwupdDevice* device,
             FwupdRelease* release)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	about_firmware_view_update (self, device, release, NULL, NULL);
}

static void
___lambda28__about_widgets_firmware_update_row_update (AboutWidgetsFirmwareUpdateRow* _sender,
                                                       FwupdDevice* device,
                                                       FwupdRelease* release,
                                                       gpointer self)
{
	__lambda28_ ((AboutFirmwareView*) self, device, release);
}

static void
___lambda26_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	AboutFirmwareView* self;
	FwupdRelease* release = NULL;
	AboutWidgetsFirmwareUpdateRow* row = NULL;
	FwupdRelease* _tmp5_;
	AboutWidgetsFirmwareUpdateRow* _tmp6_;
	AboutWidgetsFirmwareUpdateRow* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkListBox* _tmp11_;
	AboutWidgetsFirmwareUpdateRow* _tmp12_;
	GtkListBox* _tmp13_;
	AboutWidgetsFirmwareUpdateRow* _tmp14_;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	release = NULL;
	{
		GPtrArray* upgrades = NULL;
		GPtrArray* _tmp0_;
		_tmp0_ = about_firmware_client_get_upgrades_finish (res, &_inner_error0_);
		upgrades = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (upgrades != NULL) {
			gconstpointer _tmp1_;
			FwupdRelease* _tmp2_;
			_tmp1_ = g_ptr_array_index (upgrades, (guint) 0);
			_tmp2_ = _g_object_ref0 ((FwupdRelease*) _tmp1_);
			_g_object_unref0 (release);
			release = _tmp2_;
		}
		_g_ptr_array_unref0 (upgrades);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("FirmwareView.vala:141: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (release);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = release;
	_tmp6_ = about_widgets_firmware_update_row_new (_data5_->device, _tmp5_);
	g_object_ref_sink (_tmp6_);
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = about_widgets_firmware_update_row_get_is_updatable (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		guint _tmp10_;
		_tmp10_ = self->priv->num_updates;
		self->priv->num_updates = _tmp10_ + 1;
	}
	_tmp11_ = self->priv->update_list;
	_tmp12_ = row;
	gtk_list_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->update_list;
	gtk_list_box_invalidate_sort (_tmp13_);
	_tmp14_ = row;
	g_signal_connect_object (_tmp14_, "update", (GCallback) ___lambda28__about_widgets_firmware_update_row_update, self, 0);
	_g_object_unref0 (row);
	_g_object_unref0 (release);
}

static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda26_ (self, source_object, res);
	block5_data_unref (self);
}

static void
about_firmware_view_add_device (AboutFirmwareView* self,
                                FwupdDevice* device)
{
	Block5Data* _data5_;
	FwupdDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data5_->device);
	_data5_->device = _tmp0_;
	if (fwupd_device_has_flag (_data5_->device, FWUPD_DEVICE_FLAG_UPDATABLE)) {
		FwupdClient* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->fwupd_client;
		_tmp2_ = fwupd_device_get_id (_data5_->device);
		about_firmware_client_get_upgrades (_tmp1_, _tmp2_, ____lambda26__gasync_ready_callback, block5_data_ref (_data5_));
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
about_firmware_view_show_release (AboutFirmwareView* self,
                                  GtkListBoxRow* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (ABOUT_WIDGETS_IS_FIRMWARE_UPDATE_ROW (widget)) {
		AboutWidgetsFirmwareUpdateRow* row = NULL;
		AboutWidgetsFirmwareUpdateRow* _tmp0_;
		AboutFirmwareReleaseView* _tmp1_;
		AboutWidgetsFirmwareUpdateRow* _tmp2_;
		FwupdDevice* _tmp3_;
		FwupdDevice* _tmp4_;
		AboutWidgetsFirmwareUpdateRow* _tmp5_;
		FwupdRelease* _tmp6_;
		FwupdRelease* _tmp7_;
		AdwLeaflet* _tmp8_;
		AboutFirmwareReleaseView* _tmp9_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, ABOUT_WIDGETS_TYPE_FIRMWARE_UPDATE_ROW, AboutWidgetsFirmwareUpdateRow));
		row = _tmp0_;
		_tmp1_ = self->priv->firmware_release_view;
		_tmp2_ = row;
		_tmp3_ = about_widgets_firmware_update_row_get_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = row;
		_tmp6_ = about_widgets_firmware_update_row_get_release (_tmp5_);
		_tmp7_ = _tmp6_;
		about_firmware_release_view_update_view (_tmp1_, _tmp4_, _tmp7_);
		_tmp8_ = self->priv->deck;
		_tmp9_ = self->priv->firmware_release_view;
		adw_leaflet_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (row);
	}
}

static void
about_firmware_view_on_device_added (AboutFirmwareView* self,
                                     FwupdClient* client,
                                     FwupdDevice* device)
{
	const gchar* _tmp0_;
	GtkStack* _tmp1_;
	AdwLeaflet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = fwupd_device_get_name (device);
	g_debug ("FirmwareView.vala:169: Added device: %s", _tmp0_);
	about_firmware_view_add_device (self, device);
	_tmp1_ = self->priv->stack;
	_tmp2_ = self->priv->deck;
	gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
}

static void
about_firmware_view_on_device_removed (AboutFirmwareView* self,
                                       FwupdClient* client,
                                       FwupdDevice* device)
{
	const gchar* _tmp0_;
	GtkWidget* child = NULL;
	GtkListBox* _tmp1_;
	GtkWidget* _tmp2_;
	GtkListBox* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = fwupd_device_get_name (device);
	g_debug ("FirmwareView.vala:177: Removed device: %s", _tmp0_);
	_tmp1_ = self->priv->update_list;
	_tmp2_ = gtk_widget_get_first_child ((GtkWidget*) _tmp1_);
	child = _tmp2_;
	while (TRUE) {
		GtkWidget* _tmp3_;
		AboutWidgetsFirmwareUpdateRow* row = NULL;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		AboutWidgetsFirmwareUpdateRow* _tmp9_;
		_tmp3_ = child;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		row = NULL;
		_tmp4_ = child;
		if (ABOUT_WIDGETS_IS_FIRMWARE_UPDATE_ROW (_tmp4_)) {
			GtkWidget* _tmp5_;
			AboutWidgetsFirmwareUpdateRow* _tmp6_;
			_tmp5_ = child;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, ABOUT_WIDGETS_TYPE_FIRMWARE_UPDATE_ROW, AboutWidgetsFirmwareUpdateRow));
			_g_object_unref0 (row);
			row = _tmp6_;
		}
		_tmp7_ = child;
		_tmp8_ = gtk_widget_get_next_sibling (_tmp7_);
		child = _tmp8_;
		_tmp9_ = row;
		if (_tmp9_ != NULL) {
			AboutWidgetsFirmwareUpdateRow* _tmp10_;
			FwupdDevice* _tmp11_;
			FwupdDevice* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp10_ = row;
			_tmp11_ = about_widgets_firmware_update_row_get_device (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = fwupd_device_get_id (_tmp12_);
			_tmp14_ = fwupd_device_get_id (device);
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				AboutWidgetsFirmwareUpdateRow* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				GtkListBox* _tmp19_;
				AboutWidgetsFirmwareUpdateRow* _tmp20_;
				_tmp15_ = row;
				_tmp16_ = about_widgets_firmware_update_row_get_is_updatable (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					guint _tmp18_;
					_tmp18_ = self->priv->num_updates;
					self->priv->num_updates = _tmp18_ - 1;
				}
				_tmp19_ = self->priv->update_list;
				_tmp20_ = row;
				gtk_list_box_remove (_tmp19_, (GtkWidget*) _tmp20_);
			}
		}
		_g_object_unref0 (row);
	}
	_tmp21_ = self->priv->update_list;
	gtk_list_box_invalidate_sort (_tmp21_);
}

static gint
about_firmware_view_compare_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                  AboutWidgetsFirmwareUpdateRow* row2,
                                  AboutFirmwareView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FwupdDevice* _tmp10_;
	FwupdDevice* _tmp11_;
	const gchar* _tmp12_;
	FwupdDevice* _tmp13_;
	FwupdDevice* _tmp14_;
	const gchar* _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp1_ = about_widgets_firmware_update_row_get_is_updatable (row1);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = about_widgets_firmware_update_row_get_is_updatable (row2);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	}
	_tmp6_ = about_widgets_firmware_update_row_get_is_updatable (row1);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = about_widgets_firmware_update_row_get_is_updatable (row2);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = 1;
		return result;
	}
	_tmp10_ = about_widgets_firmware_update_row_get_device (row1);
	_tmp11_ = _tmp10_;
	_tmp12_ = fwupd_device_get_name (_tmp11_);
	_tmp13_ = about_widgets_firmware_update_row_get_device (row2);
	_tmp14_ = _tmp13_;
	_tmp15_ = fwupd_device_get_name (_tmp14_);
	result = g_utf8_collate (_tmp12_, _tmp15_);
	return result;
}

static void
about_firmware_view_header_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                 AboutWidgetsFirmwareUpdateRow* row2,
                                 AboutFirmwareView* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row1 != NULL);
	if (row2 == NULL) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = about_widgets_firmware_update_row_get_is_updatable (row1);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteHeaderLabel* header = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GraniteHeaderLabel* _tmp5_;
		GraniteHeaderLabel* _tmp6_;
		GraniteHeaderLabel* _tmp7_;
		_tmp3_ = g_strdup_printf (g_dngettext (ABOUT_GETTEXT_PACKAGE, "%u Update Available", "%u Updates Available", (gulong) self->priv->num_updates), self->priv->num_updates);
		_tmp4_ = _tmp3_;
		_tmp5_ = granite_header_label_new (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		header = _tmp6_;
		_tmp7_ = header;
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp7_);
		_g_object_unref0 (header);
	} else {
		gboolean _tmp8_ = FALSE;
		if (row2 == NULL) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = about_widgets_firmware_update_row_get_is_updatable (row1);
			_tmp10_ = _tmp9_;
			_tmp11_ = about_widgets_firmware_update_row_get_is_updatable (row2);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp10_ != _tmp12_;
		}
		if (_tmp8_) {
			GraniteHeaderLabel* header = NULL;
			GraniteHeaderLabel* _tmp13_;
			GraniteHeaderLabel* _tmp14_;
			_tmp13_ = granite_header_label_new (_ ("Up to Date"));
			g_object_ref_sink (_tmp13_);
			header = _tmp13_;
			_tmp14_ = header;
			gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp14_);
			_g_object_unref0 (header);
		} else {
			gtk_list_box_row_set_header ((GtkListBoxRow*) row1, NULL);
		}
	}
}

static void
about_firmware_view_update_data_free (gpointer _data)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewUpdateData, _data_);
}

static void
about_firmware_view_update (AboutFirmwareView* self,
                            FwupdDevice* device,
                            FwupdRelease* release,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	AboutFirmwareViewUpdateData* _data_;
	AboutFirmwareView* _tmp0_;
	FwupdDevice* _tmp1_;
	FwupdRelease* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = _g_object_ref0 (release);
	_g_object_unref0 (_data_->release);
	_data_->release = _tmp2_;
	about_firmware_view_update_co (_data_);
}

static void
about_firmware_view_update_finish (AboutFirmwareView* self,
                                   GAsyncResult* _res_)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->device);
		_g_object_unref0 (_data6_->release);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->details_dialog);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
about_firmware_view_update_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_update_co (_data_);
}

static void
___lambda30_ (Block7Data* _data7_,
              gint response)
{
	Block6Data* _data6_;
	AboutFirmwareView* self;
	GraniteMessageDialog* _tmp0_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data7_->details_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		about_firmware_view_continue_update (self, _data6_->device, _data6_->release, NULL, NULL);
	} else {
		GtkStack* _tmp1_;
		AdwLeaflet* _tmp2_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = self->priv->deck;
		gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
		return;
	}
}

static void
____lambda30__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda30_ (self, response_id);
}

static gboolean
about_firmware_view_update_co (AboutFirmwareViewUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data6_->device);
	_data_->_data6_->device = _data_->device;
	_g_object_unref0 (_data_->_data6_->release);
	_data_->_data6_->release = _data_->release;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->progress_alert_view;
	_data_->_tmp1_ = fwupd_device_get_name (_data_->_data6_->device);
	_data_->_tmp2_ = g_strdup_printf (_ ("“%s” is being updated"), _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	granite_placeholder_set_title (_data_->_tmp0_, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->stack;
	_data_->_tmp5_ = _data_->self->priv->progress_alert_view;
	gtk_stack_set_visible_child (_data_->_tmp4_, (GtkWidget*) _data_->_tmp5_);
	_data_->_tmp6_ = fwupd_release_get_detach_caption (_data_->_data6_->release);
	_data_->detach_caption = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->detach_caption;
	if (_data_->_tmp7_ != NULL) {
		_data_->_data7_ = g_slice_new0 (Block7Data);
		_data_->_data7_->_ref_count_ = 1;
		_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
		_data_->_tmp8_ = fwupd_release_get_detach_image (_data_->_data6_->release);
		_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
		_data_->detach_image = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->detach_image;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = _data_->detach_image;
			_data_->_state_ = 1;
			about_firmware_view_download_file (_data_->self, _data_->_data6_->device, _data_->_tmp11_, about_firmware_view_update_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp12_ = about_firmware_view_download_file_finish (_data_->self, _data_->_res_);
			_g_free0 (_data_->detach_image);
			_data_->detach_image = _data_->_tmp12_;
		}
		_data_->_tmp13_ = _data_->detach_caption;
		_data_->_tmp14_ = _data_->detach_image;
		_data_->_tmp15_ = about_firmware_view_show_details_dialog (_data_->self, _data_->_data6_->device, _data_->_tmp13_, _data_->_tmp14_);
		_data_->_data7_->details_dialog = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->_data7_->details_dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp16_, "response", (GCallback) ____lambda30__gtk_dialog_response, block7_data_ref (_data_->_data7_), (GClosureNotify) block7_data_unref, 0);
		_data_->_tmp17_ = _data_->_data7_->details_dialog;
		gtk_window_present ((GtkWindow*) _data_->_tmp17_);
		_g_free0 (_data_->detach_image);
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
	} else {
		about_firmware_view_continue_update (_data_->self, _data_->_data6_->device, _data_->_data6_->release, NULL, NULL);
	}
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_firmware_view_continue_update_data_free (gpointer _data)
{
	AboutFirmwareViewContinueUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->release);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewContinueUpdateData, _data_);
}

static void
about_firmware_view_continue_update (AboutFirmwareView* self,
                                     FwupdDevice* device,
                                     FwupdRelease* release,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	AboutFirmwareViewContinueUpdateData* _data_;
	AboutFirmwareView* _tmp0_;
	FwupdDevice* _tmp1_;
	FwupdRelease* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewContinueUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_continue_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = _g_object_ref0 (release);
	_g_object_unref0 (_data_->release);
	_data_->release = _tmp2_;
	about_firmware_view_continue_update_co (_data_);
}

static void
about_firmware_view_continue_update_finish (AboutFirmwareView* self,
                                            GAsyncResult* _res_)
{
	AboutFirmwareViewContinueUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
about_firmware_view_continue_update_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	AboutFirmwareViewContinueUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_continue_update_co (_data_);
}

static gboolean
about_firmware_view_continue_update_co (AboutFirmwareViewContinueUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fwupd_release_get_locations (_data_->release);
	_data_->_tmp1_ = _g_ptr_array_ref0 (_data_->_tmp0_);
	_data_->locations = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->locations;
	_data_->_tmp4_ = vala_g_ptr_array_get_length (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ > 0) {
		_data_->_tmp6_ = _data_->locations;
		_data_->_tmp7_ = g_ptr_array_index (_data_->_tmp6_, (guint) 0);
		_data_->_tmp2_ = (const gchar*) _data_->_tmp7_;
	} else {
		_data_->_tmp2_ = "";
	}
	_data_->_state_ = 1;
	about_firmware_view_download_file (_data_->self, _data_->device, _data_->_tmp2_, about_firmware_view_continue_update_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = about_firmware_view_download_file_finish (_data_->self, _data_->_res_);
	_data_->path = _data_->_tmp8_;
	{
		_data_->install_flags = FWUPD_INSTALL_FLAG_NONE;
		_data_->_tmp10_ = _data_->self->priv->fwupd_client;
		_data_->_tmp11_ = fwupd_device_get_id (_data_->device);
		_data_->_state_ = 2;
		about_firmware_client_install (_data_->_tmp10_, _data_->_tmp11_, _data_->path, _data_->install_flags, about_firmware_view_continue_update_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp9_ = about_firmware_client_install_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->_tmp9_) {
			if (fwupd_device_has_flag (_data_->device, FWUPD_DEVICE_FLAG_NEEDS_REBOOT)) {
				about_firmware_view_show_reboot_dialog (_data_->self);
			} else {
				if (fwupd_device_has_flag (_data_->device, FWUPD_DEVICE_FLAG_NEEDS_SHUTDOWN)) {
					about_firmware_view_show_shutdown_dialog (_data_->self);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->path);
		_g_ptr_array_unref0 (_data_->locations);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->self->priv->stack;
	_data_->_tmp15_ = _data_->self->priv->deck;
	gtk_stack_set_visible_child (_data_->_tmp14_, (GtkWidget*) _data_->_tmp15_);
	about_firmware_view_update_list_view (_data_->self, NULL, NULL);
	_g_free0 (_data_->path);
	_g_ptr_array_unref0 (_data_->locations);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_firmware_view_download_file_data_free (gpointer _data)
{
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewDownloadFileData, _data_);
}

static void
about_firmware_view_download_file (AboutFirmwareView* self,
                                   FwupdDevice* device,
                                   const gchar* uri,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AboutFirmwareViewDownloadFileData* _data_;
	AboutFirmwareView* _tmp0_;
	FwupdDevice* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewDownloadFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_download_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	about_firmware_view_download_file_co (_data_);
}

static gchar*
about_firmware_view_download_file_finish (AboutFirmwareView* self,
                                          GAsyncResult* _res_)
{
	gchar* result;
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
___lambda29_ (AboutFirmwareView* self,
              gint64 current_num_bytes,
              gint64 total_num_bytes)
{
}

static void
____lambda29__gfile_progress_callback (gint64 current_num_bytes,
                                       gint64 total_num_bytes,
                                       gpointer self)
{
	___lambda29_ ((AboutFirmwareView*) self, current_num_bytes, total_num_bytes);
}

static void
about_firmware_view_download_file_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_download_file_co (_data_);
}

static gboolean
about_firmware_view_download_file_co (AboutFirmwareViewDownloadFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
	_data_->server_file = _data_->_tmp0_;
	_data_->_tmp1_ = g_get_tmp_dir ();
	_data_->_tmp2_ = _data_->server_file;
	_data_->_tmp3_ = g_file_get_basename (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_build_filename (_data_->_tmp1_, _data_->_tmp4_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_free0 (_data_->_tmp4_);
	_data_->path = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->path;
	_data_->_tmp8_ = g_file_new_for_path (_data_->_tmp7_);
	_data_->local_file = _data_->_tmp8_;
	{
		_data_->_tmp10_ = _data_->server_file;
		_data_->_tmp11_ = _data_->local_file;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->_tmp10_, _data_->_tmp11_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, ____lambda29__gfile_progress_callback, _data_->self, about_firmware_view_download_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = g_file_copy_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_result_ = _data_->_tmp9_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		_data_->_tmp14_ = g_strdup_printf ("Could not download file: %s", _data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_result_) {
		_data_->_tmp16_ = g_strdup_printf ("Download of %s was not successful", _data_->uri);
		_data_->_tmp17_ = _data_->_tmp16_;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp17_);
		_g_free0 (_data_->_tmp17_);
		_data_->result = NULL;
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->path;
	_g_object_unref0 (_data_->local_file);
	_g_object_unref0 (_data_->server_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
about_firmware_view_show_error_dialog (AboutFirmwareView* self,
                                       FwupdDevice* device,
                                       const gchar* secondary_text)
{
	GThemedIcon* gicon = NULL;
	GThemedIcon* _tmp0_;
	GPtrArray* icons = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	GraniteMessageDialog* message_dialog = NULL;
	GThemedIcon* _tmp8_;
	GThemedIcon* _tmp9_;
	GtkRoot* _tmp10_;
	GtkWindow* _tmp11_;
	GraniteMessageDialog* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (secondary_text != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	gicon = _tmp0_;
	_tmp1_ = fwupd_device_get_icons (device);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp3_ = icons;
	_tmp4_ = _tmp3_->pdata;
	_tmp4__length1 = _tmp3_->len;
	if (_tmp4_ != NULL) {
		GPtrArray* _tmp5_;
		gpointer* _tmp6_;
		gint _tmp6__length1;
		GThemedIcon* _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = _tmp5_->pdata;
		_tmp6__length1 = _tmp5_->len;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp6_, _tmp6__length1);
		_g_object_unref0 (gicon);
		gicon = _tmp7_;
	}
	_tmp8_ = gicon;
	_tmp9_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp10_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
	_tmp12_ = granite_message_dialog_new (_ ("Failed to install firmware release"), secondary_text, (GIcon*) _tmp8_, GTK_BUTTONS_CLOSE);
	granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	message_dialog = _tmp12_;
	g_signal_connect_object ((GtkDialog*) message_dialog, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) message_dialog, 0);
	gtk_window_present ((GtkWindow*) message_dialog);
	_g_object_unref0 (message_dialog);
	_g_ptr_array_unref0 (icons);
	_g_object_unref0 (gicon);
}

static GraniteMessageDialog*
about_firmware_view_show_details_dialog (AboutFirmwareView* self,
                                         FwupdDevice* device,
                                         const gchar* detach_caption,
                                         const gchar* detach_image)
{
	GThemedIcon* gicon = NULL;
	GThemedIcon* _tmp0_;
	GPtrArray* icons = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	GraniteMessageDialog* message_dialog = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GThemedIcon* _tmp11_;
	GThemedIcon* _tmp12_;
	GtkRoot* _tmp13_;
	GtkWindow* _tmp14_;
	GraniteMessageDialog* _tmp15_ = NULL;
	GraniteMessageDialog* _tmp16_;
	GtkButton* suggested_button = NULL;
	GraniteMessageDialog* _tmp17_;
	GtkWidget* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GraniteMessageDialog* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (detach_caption != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	gicon = _tmp0_;
	_tmp1_ = fwupd_device_get_icons (device);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp3_ = icons;
	_tmp4_ = _tmp3_->pdata;
	_tmp4__length1 = _tmp3_->len;
	if (_tmp4_ != NULL) {
		GPtrArray* _tmp5_;
		gpointer* _tmp6_;
		gint _tmp6__length1;
		GThemedIcon* _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = _tmp5_->pdata;
		_tmp6__length1 = _tmp5_->len;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp6_, _tmp6__length1);
		_g_object_unref0 (gicon);
		gicon = _tmp7_;
	}
	_tmp8_ = fwupd_device_get_name (device);
	_tmp9_ = g_strdup_printf (_ ("“%s” needs to manually be put in update mode"), _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gicon;
	_tmp12_ = (GThemedIcon*) g_themed_icon_new ("dialog-information");
	_tmp13_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_window_get_type (), GtkWindow));
	_tmp15_ = granite_message_dialog_new (_tmp10_, detach_caption, (GIcon*) _tmp11_, GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp15_, (GIcon*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp10_);
	message_dialog = _tmp16_;
	_tmp17_ = message_dialog;
	_tmp18_ = granite_dialog_add_button ((GraniteDialog*) _tmp17_, _ ("Continue"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp19_;
	_tmp20_ = suggested_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp20_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	if (detach_image != NULL) {
		GtkImage* custom_widget = NULL;
		GtkImage* _tmp21_;
		GraniteMessageDialog* _tmp22_;
		GtkBox* _tmp23_;
		GtkBox* _tmp24_;
		GtkImage* _tmp25_;
		_tmp21_ = (GtkImage*) gtk_image_new_from_file (detach_image);
		g_object_ref_sink (_tmp21_);
		custom_widget = _tmp21_;
		_tmp22_ = message_dialog;
		_tmp23_ = granite_message_dialog_get_custom_bin (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = custom_widget;
		gtk_box_append (_tmp24_, (GtkWidget*) _tmp25_);
		_g_object_unref0 (custom_widget);
	}
	result = message_dialog;
	_g_object_unref0 (suggested_button);
	_g_ptr_array_unref0 (icons);
	_g_object_unref0 (gicon);
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->message_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda31_ (Block8Data* _data8_,
             gint response)
{
	AboutFirmwareView* self;
	self = _data8_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		AboutLoginManager* _tmp0_;
		AboutLoginManager* _tmp1_;
		_tmp0_ = about_login_manager_get_instance ();
		_tmp1_ = _tmp0_;
		about_login_manager_reboot (_tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	gtk_window_destroy ((GtkWindow*) _data8_->message_dialog);
}

static void
___lambda31__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda31_ (self, response_id);
}

static void
about_firmware_view_show_reboot_dialog (AboutFirmwareView* self)
{
	Block8Data* _data8_;
	GThemedIcon* _tmp0_;
	GtkRoot* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GtkButton* suggested_button = NULL;
	GtkWidget* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("An update requires the system to restart to complete"), _ ("This will close all open applications and restart this device."), "application-x-firmware", GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp3_, (GIcon*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_data8_->message_dialog = _tmp3_;
	_tmp4_ = granite_dialog_add_button ((GraniteDialog*) _data8_->message_dialog, _ ("Restart"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp5_;
	gtk_widget_add_css_class ((GtkWidget*) suggested_button, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_data ((GtkDialog*) _data8_->message_dialog, "response", (GCallback) ___lambda31__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data8_->message_dialog);
	_g_object_unref0 (suggested_button);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->message_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda32_ (Block9Data* _data9_,
             gint response)
{
	AboutFirmwareView* self;
	self = _data9_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		AboutLoginManager* _tmp0_;
		AboutLoginManager* _tmp1_;
		_tmp0_ = about_login_manager_get_instance ();
		_tmp1_ = _tmp0_;
		about_login_manager_shutdown (_tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	gtk_window_destroy ((GtkWindow*) _data9_->message_dialog);
}

static void
___lambda32__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda32_ (self, response_id);
}

static void
about_firmware_view_show_shutdown_dialog (AboutFirmwareView* self)
{
	Block9Data* _data9_;
	GThemedIcon* _tmp0_;
	GtkRoot* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GtkButton* suggested_button = NULL;
	GtkWidget* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-shutdown");
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("An update requires the system to shut down to complete"), _ ("This will close all open applications and turn off this device."), "application-x-firmware", GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp3_, (GIcon*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_data9_->message_dialog = _tmp3_;
	_tmp4_ = granite_dialog_add_button ((GraniteDialog*) _data9_->message_dialog, _ ("Shut Down"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp5_;
	gtk_widget_add_css_class ((GtkWidget*) suggested_button, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_data ((GtkDialog*) _data9_->message_dialog, "response", (GCallback) ___lambda32__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data9_->message_dialog);
	_g_object_unref0 (suggested_button);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda33_ (Block10Data* _data10_,
             gint _result_)
{
	AboutFirmwareView* self;
	AboutLoginManager* login_manager = NULL;
	AboutLoginManager* _tmp0_;
	GError* _error_ = NULL;
	AboutLoginManager* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	AboutLoginManager* _tmp17_;
	self = _data10_->self;
	gtk_window_destroy ((GtkWindow*) _data10_->dialog);
	if (_result_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		return;
	}
	_tmp0_ = about_login_manager_get_instance ();
	login_manager = _tmp0_;
	_tmp1_ = login_manager;
	_tmp2_ = about_login_manager_set_reboot_to_firmware_setup (_tmp1_);
	_error_ = _tmp2_;
	_tmp3_ = _error_;
	if (_tmp3_ != NULL) {
		GraniteMessageDialog* message_dialog = NULL;
		GThemedIcon* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GtkRoot* _tmp7_;
		GtkWindow* _tmp8_;
		GraniteMessageDialog* _tmp9_ = NULL;
		GraniteMessageDialog* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		_tmp4_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
		_tmp5_ = _tmp4_;
		_tmp6_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp7_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
		_tmp9_ = granite_message_dialog_new (_ ("Unable to restart to firmware setup"), _ ("A system error prevented automatically restarting into firmware setup."), (GIcon*) _tmp5_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp9_, (GIcon*) _tmp6_);
		_g_object_unref0 (_tmp6_);
		gtk_window_set_modal ((GtkWindow*) _tmp9_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp9_, _tmp8_);
		_g_object_unref0 (_tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp5_);
		message_dialog = _tmp10_;
		_tmp11_ = message_dialog;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		granite_message_dialog_show_error_details (_tmp11_, _tmp13_);
		_tmp14_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp14_);
		_tmp15_ = message_dialog;
		_tmp16_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp15_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp16_, 0);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (_error_);
		_g_object_unref0 (login_manager);
		return;
	}
	_tmp17_ = login_manager;
	about_login_manager_reboot (_tmp17_);
	_g_error_free0 (_error_);
	_g_object_unref0 (login_manager);
}

static void
___lambda33__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda33_ (self, response_id);
}

static void
about_firmware_view_reboot_to_firmware_setup_clicked (AboutFirmwareView* self)
{
	Block10Data* _data10_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GtkRoot* _tmp3_;
	GtkWindow* _tmp4_;
	GraniteMessageDialog* _tmp5_ = NULL;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* continue_button = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = granite_message_dialog_new (_ ("Restart to firmware setup"), _ ("This will close all open applications, restart this device, and open t" \
"he firmware setup screen."), (GIcon*) _tmp1_, GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp5_, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	_data10_->dialog = _tmp6_;
	_tmp7_ = granite_dialog_add_button ((GraniteDialog*) _data10_->dialog, _ ("Restart"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	continue_button = _tmp8_;
	gtk_widget_add_css_class (continue_button, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_data ((GtkDialog*) _data10_->dialog, "response", (GCallback) ___lambda33__gtk_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data10_->dialog);
	_g_object_unref0 (continue_button);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
_about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	about_firmware_view_reboot_to_firmware_setup_clicked ((AboutFirmwareView*) self);
}

static void
_about_firmware_view_on_device_added_fwupd_client_device_added (FwupdClient* _sender,
                                                                FwupdDevice* _result_,
                                                                gpointer self)
{
	about_firmware_view_on_device_added ((AboutFirmwareView*) self, _sender, _result_);
}

static void
_about_firmware_view_on_device_removed_fwupd_client_device_removed (FwupdClient* _sender,
                                                                    FwupdDevice* _result_,
                                                                    gpointer self)
{
	about_firmware_view_on_device_removed ((AboutFirmwareView*) self, _sender, _result_);
}

static void
_about_firmware_view_show_release_gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	about_firmware_view_show_release ((AboutFirmwareView*) self, row);
}

static void
_about_firmware_view___lambda34_ (AboutFirmwareView* self,
                                  FwupdDevice* device,
                                  FwupdRelease* release)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	about_firmware_view_update (self, device, release, NULL, NULL);
}

static void
__about_firmware_view___lambda34__about_firmware_release_view_update (AboutFirmwareReleaseView* _sender,
                                                                      FwupdDevice* device,
                                                                      FwupdRelease* release,
                                                                      gpointer self)
{
	_about_firmware_view___lambda34_ ((AboutFirmwareView*) self, device, release);
}

static GObject *
about_firmware_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareView * self;
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GranitePlaceholder* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GranitePlaceholder* _tmp10_;
	GtkScrolledWindow* update_scrolled = NULL;
	GtkListBox* _tmp11_;
	GtkWidget* _tmp12_;
	GtkScrolledWindow* _tmp13_ = NULL;
	AboutFirmwareReleaseView* _tmp14_;
	AdwLeaflet* _tmp15_ = NULL;
	AdwLeaflet* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	AdwLeaflet* _tmp18_;
	AboutFirmwareReleaseView* _tmp19_;
	AdwLeaflet* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkStack* _tmp22_ = NULL;
	GtkStack* _tmp23_;
	AdwLeaflet* _tmp24_;
	GtkStack* _tmp25_;
	GranitePlaceholder* _tmp26_;
	GtkFrame* frame = NULL;
	GtkStack* _tmp27_;
	GtkWidget* _tmp28_;
	GtkFrame* _tmp29_ = NULL;
	GtkFrame* _tmp30_;
	AboutLoginManager* _tmp31_;
	AboutLoginManager* _tmp32_;
	gboolean _tmp33_;
	FwupdClient* _tmp36_;
	FwupdClient* _tmp37_;
	FwupdClient* _tmp38_;
	GtkListBox* _tmp39_;
	AboutFirmwareReleaseView* _tmp40_;
	parent_class = G_OBJECT_CLASS (about_firmware_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_VIEW, AboutFirmwareView);
	_tmp0_ = g_strdup (_ ("Do not unplug the device during the update."));
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("emblem-synchronized");
	_tmp2_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	granite_placeholder_set_icon (_tmp2_, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->progress_alert_view);
	self->priv->progress_alert_view = _tmp2_;
	_tmp3_ = g_strdup (_ ("Connecting to the firmware service and searching for updates."));
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("sync-synchronizing");
	_tmp5_ = granite_placeholder_new (_ ("Checking for Updates"));
	granite_placeholder_set_description (_tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	granite_placeholder_set_icon (_tmp5_, (GIcon*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->placeholder_alert_view);
	self->priv->placeholder_alert_view = _tmp5_;
	_tmp6_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp6_, TRUE);
	gtk_list_box_set_selection_mode (_tmp6_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->update_list);
	self->priv->update_list = _tmp6_;
	_tmp7_ = self->priv->update_list;
	gtk_list_box_set_sort_func (_tmp7_, (GtkListBoxSortFunc) about_firmware_view_compare_rows, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->update_list;
	gtk_list_box_set_header_func (_tmp8_, (GtkListBoxUpdateHeaderFunc) about_firmware_view_header_rows, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->update_list;
	_tmp10_ = self->priv->placeholder_alert_view;
	gtk_list_box_set_placeholder (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->update_list;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	update_scrolled = _tmp13_;
	_tmp14_ = about_firmware_release_view_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->firmware_release_view);
	self->priv->firmware_release_view = _tmp14_;
	_tmp15_ = (AdwLeaflet*) adw_leaflet_new ();
	adw_leaflet_set_can_navigate_back (_tmp15_, TRUE);
	adw_leaflet_set_can_unfold (_tmp15_, FALSE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->deck);
	self->priv->deck = _tmp15_;
	_tmp16_ = self->priv->deck;
	_tmp17_ = update_scrolled;
	adw_leaflet_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->deck;
	_tmp19_ = self->priv->firmware_release_view;
	adw_leaflet_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->deck;
	_tmp21_ = update_scrolled;
	adw_leaflet_set_visible_child (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp22_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp22_;
	_tmp23_ = self->priv->stack;
	_tmp24_ = self->priv->deck;
	gtk_stack_add_child (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->stack;
	_tmp26_ = self->priv->progress_alert_view;
	gtk_stack_add_child (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->stack;
	_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
	_tmp29_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp29_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	frame = _tmp29_;
	_tmp30_ = frame;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = about_login_manager_get_instance ();
	_tmp32_ = _tmp31_;
	_tmp33_ = about_login_manager_can_reboot_to_firmware_setup (_tmp32_);
	_g_object_unref0 (_tmp32_);
	if (_tmp33_) {
		GtkButton* reboot_to_firmware_setup_button = NULL;
		GtkButton* _tmp34_;
		GtkButton* _tmp35_;
		_tmp34_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Restart to Firmware Setup…"));
		reboot_to_firmware_setup_button = _tmp34_;
		_tmp35_ = reboot_to_firmware_setup_button;
		g_signal_connect_object (_tmp35_, "clicked", (GCallback) _about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked, self, 0);
		_g_object_unref0 (reboot_to_firmware_setup_button);
	}
	_tmp36_ = fwupd_client_new ();
	_g_object_unref0 (self->priv->fwupd_client);
	self->priv->fwupd_client = _tmp36_;
	_tmp37_ = self->priv->fwupd_client;
	g_signal_connect_object (_tmp37_, "device-added", (GCallback) _about_firmware_view_on_device_added_fwupd_client_device_added, self, 0);
	_tmp38_ = self->priv->fwupd_client;
	g_signal_connect_object (_tmp38_, "device-removed", (GCallback) _about_firmware_view_on_device_removed_fwupd_client_device_removed, self, 0);
	about_firmware_view_update_list_view (self, NULL, NULL);
	_tmp39_ = self->priv->update_list;
	g_signal_connect_object (_tmp39_, "row-activated", (GCallback) _about_firmware_view_show_release_gtk_list_box_row_activated, self, 0);
	_tmp40_ = self->priv->firmware_release_view;
	g_signal_connect_object (_tmp40_, "update", (GCallback) __about_firmware_view___lambda34__about_firmware_release_view_update, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (update_scrolled);
	return obj;
}

static void
about_firmware_view_class_init (AboutFirmwareViewClass * klass,
                                gpointer klass_data)
{
	about_firmware_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutFirmwareView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_firmware_view_finalize;
}

static void
about_firmware_view_instance_init (AboutFirmwareView * self,
                                   gpointer klass)
{
	self->priv = about_firmware_view_get_instance_private (self);
	self->priv->num_updates = (guint) 0;
}

static void
about_firmware_view_finalize (GObject * obj)
{
	AboutFirmwareView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_VIEW, AboutFirmwareView);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->deck);
	_g_object_unref0 (self->priv->firmware_release_view);
	_g_object_unref0 (self->priv->progress_alert_view);
	_g_object_unref0 (self->priv->placeholder_alert_view);
	_g_object_unref0 (self->priv->update_list);
	_g_object_unref0 (self->priv->fwupd_client);
	G_OBJECT_CLASS (about_firmware_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_firmware_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareView), 0, (GInstanceInitFunc) about_firmware_view_instance_init, NULL };
	GType about_firmware_view_type_id;
	about_firmware_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "AboutFirmwareView", &g_define_type_info, 0);
	AboutFirmwareView_private_offset = g_type_add_instance_private (about_firmware_view_type_id, sizeof (AboutFirmwareViewPrivate));
	return about_firmware_view_type_id;
}

GType
about_firmware_view_get_type (void)
{
	static volatile gsize about_firmware_view_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_view_type_id__once)) {
		GType about_firmware_view_type_id;
		about_firmware_view_type_id = about_firmware_view_get_type_once ();
		g_once_init_leave (&about_firmware_view_type_id__once, about_firmware_view_type_id);
	}
	return about_firmware_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

