
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_unixinfo.h"
#include "bin/default/librpc/gen_ndr/ndr_unixinfo_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
static PyTypeObject unixinfo_GetPWUidInfo_Type;
static PyTypeObject unixinfo_InterfaceType;
static PyTypeObject unixinfo_SidToUid_Type;
static PyTypeObject unixinfo_UidToSid_Type;
static PyTypeObject unixinfo_SidToGid_Type;
static PyTypeObject unixinfo_GidToSid_Type;
static PyTypeObject unixinfo_GetPWUid_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_unixinfo_GetPWUidInfo_get_status(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_unixinfo_GetPWUidInfo_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_unixinfo_GetPWUidInfo_get_homedir(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_homedir;
	if (object->homedir == NULL) {
		py_homedir = Py_None;
		Py_INCREF(py_homedir);
	} else {
		py_homedir = PyUnicode_Decode(object->homedir, strlen(object->homedir), "utf-8", "ignore");
	}
	return py_homedir;
}

static int py_unixinfo_GetPWUidInfo_set_homedir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->homedir");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->homedir = talloc_str;
	}
	return 0;
}

static PyObject *py_unixinfo_GetPWUidInfo_get_shell(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_shell;
	if (object->shell == NULL) {
		py_shell = Py_None;
		Py_INCREF(py_shell);
	} else {
		py_shell = PyUnicode_Decode(object->shell, strlen(object->shell), "utf-8", "ignore");
	}
	return py_shell;
}

static int py_unixinfo_GetPWUidInfo_set_shell(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->shell");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->shell = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_unixinfo_GetPWUidInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_unixinfo_GetPWUidInfo_get_status,
		.set = py_unixinfo_GetPWUidInfo_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "homedir"),
		.get = py_unixinfo_GetPWUidInfo_get_homedir,
		.set = py_unixinfo_GetPWUidInfo_set_homedir,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "shell"),
		.get = py_unixinfo_GetPWUidInfo_get_shell,
		.set = py_unixinfo_GetPWUidInfo_set_shell,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_GetPWUidInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct unixinfo_GetPWUidInfo, type);
}


static PyTypeObject unixinfo_GetPWUidInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.GetPWUidInfo",
	.tp_getset = py_unixinfo_GetPWUidInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_GetPWUidInfo_new,
};



static PyObject *py_unixinfo_SidToUid_in_get_sid(PyObject *obj, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->in.sid);
	return py_sid;
}

static int py_unixinfo_SidToUid_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_unixinfo_SidToUid_out_get_uid(PyObject *obj, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	if (object->out.uid == NULL) {
		Py_RETURN_NONE;
	}
	py_uid = PyLong_FromUnsignedLongLong(*object->out.uid);
	return py_uid;
}

static int py_unixinfo_SidToUid_out_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.uid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.uid");
		return -1;
	}
	object->out.uid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.uid);
	if (object->out.uid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_SidToUid_get_result(PyObject *obj, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_unixinfo_SidToUid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_unixinfo_SidToUid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_unixinfo_SidToUid_in_get_sid,
		.set = py_unixinfo_SidToUid_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_uid"),
		.get = py_unixinfo_SidToUid_out_get_uid,
		.set = py_unixinfo_SidToUid_out_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_unixinfo_SidToUid_get_result,
		.set = py_unixinfo_SidToUid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_SidToUid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct unixinfo_SidToUid, type);
	struct unixinfo_SidToUid *_self = (struct unixinfo_SidToUid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.uid = talloc_zero(mem_ctx, uint64_t);
	return self;
}

static PyObject *py_unixinfo_SidToUid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_unixinfo_SidToUid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToUid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_unixinfo_SidToUid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_SidToUid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_unixinfo_SidToUid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_SidToUid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_unixinfo_SidToUid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToUid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_unixinfo_SidToUid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_SidToUid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_SidToUid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_SidToUid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_SidToUid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToUid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_unixinfo.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToUid_ndr_print");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_unixinfo_SidToUid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_SidToUid_ndr_print(py_obj, args, kwargs, "unixinfo_SidToUid_in", NDR_IN);
}

static PyObject *py_unixinfo_SidToUid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_SidToUid_ndr_print(py_obj, args, kwargs, "unixinfo_SidToUid_out", NDR_OUT);
}

static PyMethodDef py_unixinfo_SidToUid_methods[] = {
	{ "opnum", (PyCFunction)py_unixinfo_SidToUid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"unixinfo.SidToUid.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToUid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject unixinfo_SidToUid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.SidToUid",
	.tp_getset = py_unixinfo_SidToUid_getsetters,
	.tp_methods = py_unixinfo_SidToUid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_SidToUid_new,
};

static bool pack_py_unixinfo_SidToUid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_SidToUid *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_SidToUid", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = *(struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_unixinfo_SidToUid_args_out(struct unixinfo_SidToUid *r, bool raise_result_exception)
{
	PyObject *py_uid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_uid = PyLong_FromUnsignedLongLong(*r->out.uid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_uid);
	}
	if (result_size == 1) {
		result = py_uid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_unixinfo_UidToSid_in_get_uid(PyObject *obj, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->in.uid);
	return py_uid;
}

static int py_unixinfo_UidToSid_in_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_UidToSid_out_get_sid(PyObject *obj, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->out.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->out.sid, object->out.sid);
	return py_sid;
}

static int py_unixinfo_UidToSid_out_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sid");
		return -1;
	}
	object->out.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sid);
	if (object->out.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_unixinfo_UidToSid_get_result(PyObject *obj, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_unixinfo_UidToSid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_unixinfo_UidToSid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_uid"),
		.get = py_unixinfo_UidToSid_in_get_uid,
		.set = py_unixinfo_UidToSid_in_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "out_sid"),
		.get = py_unixinfo_UidToSid_out_get_sid,
		.set = py_unixinfo_UidToSid_out_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_unixinfo_UidToSid_get_result,
		.set = py_unixinfo_UidToSid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_UidToSid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct unixinfo_UidToSid, type);
	struct unixinfo_UidToSid *_self = (struct unixinfo_UidToSid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.sid = talloc_zero(mem_ctx, struct dom_sid);
	return self;
}

static PyObject *py_unixinfo_UidToSid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_unixinfo_UidToSid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_UidToSid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_unixinfo_UidToSid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_UidToSid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_unixinfo_UidToSid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_UidToSid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_unixinfo_UidToSid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_UidToSid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_unixinfo_UidToSid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_UidToSid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_UidToSid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_UidToSid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_UidToSid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_UidToSid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_unixinfo.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_UidToSid_ndr_print");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_unixinfo_UidToSid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_UidToSid_ndr_print(py_obj, args, kwargs, "unixinfo_UidToSid_in", NDR_IN);
}

static PyObject *py_unixinfo_UidToSid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_UidToSid_ndr_print(py_obj, args, kwargs, "unixinfo_UidToSid_out", NDR_OUT);
}

static PyMethodDef py_unixinfo_UidToSid_methods[] = {
	{ "opnum", (PyCFunction)py_unixinfo_UidToSid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"unixinfo.UidToSid.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_UidToSid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject unixinfo_UidToSid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.UidToSid",
	.tp_getset = py_unixinfo_UidToSid_getsetters,
	.tp_methods = py_unixinfo_UidToSid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_UidToSid_new,
};

static bool pack_py_unixinfo_UidToSid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_UidToSid *r)
{
	PyObject *py_uid;
	const char *kwnames[] = {
		"uid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_UidToSid", discard_const_p(char *, kwnames), &py_uid)) {
		return false;
	}

	if (py_uid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.uid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.uid));
		if (PyLong_Check(py_uid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_uid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_unixinfo_UidToSid_args_out(struct unixinfo_UidToSid *r, bool raise_result_exception)
{
	PyObject *py_sid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sid = pytalloc_reference_ex(dom_sid_Type, r->out.sid, r->out.sid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sid);
	}
	if (result_size == 1) {
		result = py_sid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_unixinfo_SidToGid_in_get_sid(PyObject *obj, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->in.sid);
	return py_sid;
}

static int py_unixinfo_SidToGid_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_unixinfo_SidToGid_out_get_gid(PyObject *obj, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	if (object->out.gid == NULL) {
		Py_RETURN_NONE;
	}
	py_gid = PyLong_FromUnsignedLongLong(*object->out.gid);
	return py_gid;
}

static int py_unixinfo_SidToGid_out_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.gid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.gid");
		return -1;
	}
	object->out.gid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.gid);
	if (object->out.gid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_SidToGid_get_result(PyObject *obj, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_unixinfo_SidToGid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_unixinfo_SidToGid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_unixinfo_SidToGid_in_get_sid,
		.set = py_unixinfo_SidToGid_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_gid"),
		.get = py_unixinfo_SidToGid_out_get_gid,
		.set = py_unixinfo_SidToGid_out_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_unixinfo_SidToGid_get_result,
		.set = py_unixinfo_SidToGid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_SidToGid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct unixinfo_SidToGid, type);
	struct unixinfo_SidToGid *_self = (struct unixinfo_SidToGid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.gid = talloc_zero(mem_ctx, uint64_t);
	return self;
}

static PyObject *py_unixinfo_SidToGid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_unixinfo_SidToGid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToGid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_unixinfo_SidToGid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_SidToGid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_unixinfo_SidToGid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_SidToGid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_unixinfo_SidToGid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToGid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_unixinfo_SidToGid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_SidToGid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_SidToGid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_SidToGid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_SidToGid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_SidToGid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_unixinfo.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_SidToGid_ndr_print");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_unixinfo_SidToGid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_SidToGid_ndr_print(py_obj, args, kwargs, "unixinfo_SidToGid_in", NDR_IN);
}

static PyObject *py_unixinfo_SidToGid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_SidToGid_ndr_print(py_obj, args, kwargs, "unixinfo_SidToGid_out", NDR_OUT);
}

static PyMethodDef py_unixinfo_SidToGid_methods[] = {
	{ "opnum", (PyCFunction)py_unixinfo_SidToGid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"unixinfo.SidToGid.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_SidToGid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject unixinfo_SidToGid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.SidToGid",
	.tp_getset = py_unixinfo_SidToGid_getsetters,
	.tp_methods = py_unixinfo_SidToGid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_SidToGid_new,
};

static bool pack_py_unixinfo_SidToGid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_SidToGid *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_SidToGid", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = *(struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_unixinfo_SidToGid_args_out(struct unixinfo_SidToGid *r, bool raise_result_exception)
{
	PyObject *py_gid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_gid = PyLong_FromUnsignedLongLong(*r->out.gid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_gid);
	}
	if (result_size == 1) {
		result = py_gid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_unixinfo_GidToSid_in_get_gid(PyObject *obj, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	py_gid = PyLong_FromUnsignedLongLong(object->in.gid);
	return py_gid;
}

static int py_unixinfo_GidToSid_in_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_GidToSid_out_get_sid(PyObject *obj, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->out.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->out.sid, object->out.sid);
	return py_sid;
}

static int py_unixinfo_GidToSid_out_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sid");
		return -1;
	}
	object->out.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sid);
	if (object->out.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_unixinfo_GidToSid_get_result(PyObject *obj, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_unixinfo_GidToSid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_unixinfo_GidToSid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_gid"),
		.get = py_unixinfo_GidToSid_in_get_gid,
		.set = py_unixinfo_GidToSid_in_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "out_sid"),
		.get = py_unixinfo_GidToSid_out_get_sid,
		.set = py_unixinfo_GidToSid_out_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_unixinfo_GidToSid_get_result,
		.set = py_unixinfo_GidToSid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_GidToSid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct unixinfo_GidToSid, type);
	struct unixinfo_GidToSid *_self = (struct unixinfo_GidToSid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.sid = talloc_zero(mem_ctx, struct dom_sid);
	return self;
}

static PyObject *py_unixinfo_GidToSid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_unixinfo_GidToSid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GidToSid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_unixinfo_GidToSid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_GidToSid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_unixinfo_GidToSid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_GidToSid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_unixinfo_GidToSid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GidToSid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_unixinfo_GidToSid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_GidToSid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_GidToSid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_GidToSid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_GidToSid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GidToSid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_unixinfo.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GidToSid_ndr_print");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_unixinfo_GidToSid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_GidToSid_ndr_print(py_obj, args, kwargs, "unixinfo_GidToSid_in", NDR_IN);
}

static PyObject *py_unixinfo_GidToSid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_GidToSid_ndr_print(py_obj, args, kwargs, "unixinfo_GidToSid_out", NDR_OUT);
}

static PyMethodDef py_unixinfo_GidToSid_methods[] = {
	{ "opnum", (PyCFunction)py_unixinfo_GidToSid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"unixinfo.GidToSid.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GidToSid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject unixinfo_GidToSid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.GidToSid",
	.tp_getset = py_unixinfo_GidToSid_getsetters,
	.tp_methods = py_unixinfo_GidToSid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_GidToSid_new,
};

static bool pack_py_unixinfo_GidToSid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_GidToSid *r)
{
	PyObject *py_gid;
	const char *kwnames[] = {
		"gid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_GidToSid", discard_const_p(char *, kwnames), &py_gid)) {
		return false;
	}

	if (py_gid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.gid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.gid));
		if (PyLong_Check(py_gid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_gid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_unixinfo_GidToSid_args_out(struct unixinfo_GidToSid *r, bool raise_result_exception)
{
	PyObject *py_sid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sid = pytalloc_reference_ex(dom_sid_Type, r->out.sid, r->out.sid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sid);
	}
	if (result_size == 1) {
		result = py_sid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_unixinfo_GetPWUid_in_get_count(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->in.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.count));
	return py_count;
}

static int py_unixinfo_GetPWUid_in_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.count");
		return -1;
	}
	object->in.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.count);
	if (object->in.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_GetPWUid_out_get_count(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->out.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.count));
	return py_count;
}

static int py_unixinfo_GetPWUid_out_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.count");
		return -1;
	}
	object->out.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.count);
	if (object->out.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_unixinfo_GetPWUid_in_get_uids(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(obj);
	PyObject *py_uids;
	py_uids = PyList_New(*object->in.count);
	if (py_uids == NULL) {
		return NULL;
	}
	{
		int uids_cntr_0;
		for (uids_cntr_0 = 0; uids_cntr_0 < (*object->in.count); uids_cntr_0++) {
			PyObject *py_uids_0;
			py_uids_0 = PyLong_FromUnsignedLongLong((object->in.uids)[uids_cntr_0]);
			PyList_SetItem(py_uids, uids_cntr_0, py_uids_0);
		}
	}
	return py_uids;
}

static int py_unixinfo_GetPWUid_in_set_uids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.uids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int uids_cntr_0;
		object->in.uids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.uids, PyList_GET_SIZE(value));
		if (!object->in.uids) { return -1; }
		talloc_set_name_const(object->in.uids, "ARRAY: object->in.uids");
		for (uids_cntr_0 = 0; uids_cntr_0 < PyList_GET_SIZE(value); uids_cntr_0++) {
			if (PyList_GET_ITEM(value, uids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.uids)[uids_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.uids)[uids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, uids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, uids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.uids)[uids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_unixinfo_GetPWUid_out_get_infos(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(obj);
	PyObject *py_infos;
	py_infos = PyList_New(*object->out.count);
	if (py_infos == NULL) {
		return NULL;
	}
	{
		int infos_cntr_0;
		for (infos_cntr_0 = 0; infos_cntr_0 < (*object->out.count); infos_cntr_0++) {
			PyObject *py_infos_0;
			py_infos_0 = pytalloc_reference_ex(&unixinfo_GetPWUidInfo_Type, object->out.infos, &(object->out.infos)[infos_cntr_0]);
			PyList_SetItem(py_infos, infos_cntr_0, py_infos_0);
		}
	}
	return py_infos;
}

static int py_unixinfo_GetPWUid_out_set_infos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.infos");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int infos_cntr_0;
		object->out.infos = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.infos, PyList_GET_SIZE(value));
		if (!object->out.infos) { return -1; }
		talloc_set_name_const(object->out.infos, "ARRAY: object->out.infos");
		for (infos_cntr_0 = 0; infos_cntr_0 < PyList_GET_SIZE(value); infos_cntr_0++) {
			if (PyList_GET_ITEM(value, infos_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.infos)[infos_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&unixinfo_GetPWUidInfo_Type, PyList_GET_ITEM(value, infos_cntr_0), return -1;);
			if (talloc_reference(object->out.infos, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, infos_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.infos)[infos_cntr_0] = *(struct unixinfo_GetPWUidInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, infos_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_unixinfo_GetPWUid_get_result(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_unixinfo_GetPWUid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_unixinfo_GetPWUid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_count"),
		.get = py_unixinfo_GetPWUid_in_get_count,
		.set = py_unixinfo_GetPWUid_in_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_count"),
		.get = py_unixinfo_GetPWUid_out_get_count,
		.set = py_unixinfo_GetPWUid_out_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_uids"),
		.get = py_unixinfo_GetPWUid_in_get_uids,
		.set = py_unixinfo_GetPWUid_in_set_uids,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "out_infos"),
		.get = py_unixinfo_GetPWUid_out_get_infos,
		.set = py_unixinfo_GetPWUid_out_set_infos,
		.doc = discard_const_p(char, "PIDL-generated element of base type unixinfo_GetPWUidInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_unixinfo_GetPWUid_get_result,
		.set = py_unixinfo_GetPWUid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_unixinfo_GetPWUid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct unixinfo_GetPWUid, type);
	struct unixinfo_GetPWUid *_self = (struct unixinfo_GetPWUid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.count = talloc_zero(mem_ctx, uint32_t);
	_self->out.count = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_unixinfo_GetPWUid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_unixinfo_GetPWUid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GetPWUid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_unixinfo_GetPWUid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_GetPWUid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_unixinfo_GetPWUid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_unixinfo_GetPWUid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_unixinfo_GetPWUid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_unixinfo.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GetPWUid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_unixinfo_GetPWUid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_GetPWUid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_GetPWUid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_unixinfo_GetPWUid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_unixinfo_GetPWUid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct unixinfo_GetPWUid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_unixinfo.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_unixinfo_GetPWUid_ndr_print");
		return NULL;
	}
	call = &ndr_table_unixinfo.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_unixinfo_GetPWUid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_GetPWUid_ndr_print(py_obj, args, kwargs, "unixinfo_GetPWUid_in", NDR_IN);
}

static PyObject *py_unixinfo_GetPWUid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_unixinfo_GetPWUid_ndr_print(py_obj, args, kwargs, "unixinfo_GetPWUid_out", NDR_OUT);
}

static PyMethodDef py_unixinfo_GetPWUid_methods[] = {
	{ "opnum", (PyCFunction)py_unixinfo_GetPWUid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"unixinfo.GetPWUid.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_unixinfo_GetPWUid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject unixinfo_GetPWUid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.GetPWUid",
	.tp_getset = py_unixinfo_GetPWUid_getsetters,
	.tp_methods = py_unixinfo_GetPWUid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_GetPWUid_new,
};

static bool pack_py_unixinfo_GetPWUid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_GetPWUid *r)
{
	PyObject *py_uids;
	const char *kwnames[] = {
		"uids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_GetPWUid", discard_const_p(char *, kwnames), &py_uids)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_uids, return false;);
	r->in.count = talloc_ptrtype(r, r->in.count);
	if (r->in.count == NULL) {
		PyErr_NoMemory();
		return false;
	}
	*r->in.count = PyList_GET_SIZE(py_uids);
	if (py_uids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.uids");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_uids, return false;);
	{
		int uids_cntr_0;
		r->in.uids = talloc_array_ptrtype(r, r->in.uids, PyList_GET_SIZE(py_uids));
		if (!r->in.uids) { return false; }
		talloc_set_name_const(r->in.uids, "ARRAY: r->in.uids");
		for (uids_cntr_0 = 0; uids_cntr_0 < PyList_GET_SIZE(py_uids); uids_cntr_0++) {
			if (PyList_GET_ITEM(py_uids, uids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.uids)[uids_cntr_0]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.uids)[uids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(py_uids, uids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_uids, uids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.uids)[uids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	return true;
}

static PyObject *unpack_py_unixinfo_GetPWUid_args_out(struct unixinfo_GetPWUid *r, bool raise_result_exception)
{
	PyObject *py_infos = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_infos = PyList_New(*r->out.count);
	if (py_infos == NULL) {
		return NULL;
	}
	{
		int infos_cntr_0;
		for (infos_cntr_0 = 0; infos_cntr_0 < (*r->out.count); infos_cntr_0++) {
			PyObject *py_infos_0;
			py_infos_0 = pytalloc_reference_ex(&unixinfo_GetPWUidInfo_Type, r->out.infos, &(r->out.infos)[infos_cntr_0]);
			PyList_SetItem(py_infos, infos_cntr_0, py_infos_0);
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_infos);
	}
	if (result_size == 1) {
		result = py_infos;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_unixinfo_methods[] = {
	{
		.name = "SidToUid",
		.doc = "S.SidToUid(sid) -> uid",
		.call = (py_dcerpc_call_fn)dcerpc_unixinfo_SidToUid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_unixinfo_SidToUid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_unixinfo_SidToUid_args_out,
		.opnum = 0,
		.table = &ndr_table_unixinfo,
	},
	{
		.name = "UidToSid",
		.doc = "S.UidToSid(uid) -> sid",
		.call = (py_dcerpc_call_fn)dcerpc_unixinfo_UidToSid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_unixinfo_UidToSid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_unixinfo_UidToSid_args_out,
		.opnum = 1,
		.table = &ndr_table_unixinfo,
	},
	{
		.name = "SidToGid",
		.doc = "S.SidToGid(sid) -> gid",
		.call = (py_dcerpc_call_fn)dcerpc_unixinfo_SidToGid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_unixinfo_SidToGid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_unixinfo_SidToGid_args_out,
		.opnum = 2,
		.table = &ndr_table_unixinfo,
	},
	{
		.name = "GidToSid",
		.doc = "S.GidToSid(gid) -> sid",
		.call = (py_dcerpc_call_fn)dcerpc_unixinfo_GidToSid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_unixinfo_GidToSid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_unixinfo_GidToSid_args_out,
		.opnum = 3,
		.table = &ndr_table_unixinfo,
	},
	{
		.name = "GetPWUid",
		.doc = "S.GetPWUid(uids) -> infos",
		.call = (py_dcerpc_call_fn)dcerpc_unixinfo_GetPWUid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_unixinfo_GetPWUid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_unixinfo_GetPWUid_args_out,
		.opnum = 4,
		.table = &ndr_table_unixinfo,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_unixinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_unixinfo);
}

#define PY_DOC_UNIXINFO "Unixinfo specific stuff"
static PyTypeObject unixinfo_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.unixinfo",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "unixinfo(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A unixinfo client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_UNIXINFO,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_unixinfo_new,
};

static PyObject *syntax_unixinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_unixinfo.syntax_id);
}

#define PY_DOC_UNIXINFO_SYNTAX "Unixinfo specific stuff"
static PyTypeObject unixinfo_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "unixinfo.unixinfo_abstract_syntax",
	.tp_doc = "unixinfo_abstract_syntax()\n"PY_DOC_UNIXINFO_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_unixinfo_new,
};

static PyMethodDef unixinfo_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "unixinfo",
	.m_doc = "unixinfo DCE/RPC",
	.m_size = -1,
	.m_methods = unixinfo_methods,
};
MODULE_INIT_FUNC(unixinfo)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	unixinfo_GetPWUidInfo_Type.tp_base = BaseObject_Type;
	unixinfo_GetPWUidInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_SidToUid_Type.tp_base = BaseObject_Type;
	unixinfo_SidToUid_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_UidToSid_Type.tp_base = BaseObject_Type;
	unixinfo_UidToSid_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_SidToGid_Type.tp_base = BaseObject_Type;
	unixinfo_SidToGid_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_GidToSid_Type.tp_base = BaseObject_Type;
	unixinfo_GidToSid_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_GetPWUid_Type.tp_base = BaseObject_Type;
	unixinfo_GetPWUid_Type.tp_basicsize = pytalloc_BaseObject_size();

	unixinfo_InterfaceType.tp_base = ClientConnection_Type;

	unixinfo_SyntaxType.tp_base = ndr_syntax_id_Type;
	unixinfo_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&unixinfo_GetPWUidInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_SidToUid_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_UidToSid_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_SidToGid_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_GidToSid_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_GetPWUid_Type) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&unixinfo_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&unixinfo_InterfaceType, py_ndr_unixinfo_methods))
		return NULL;

#ifdef PY_GETPWUIDINFO_PATCH
	PY_GETPWUIDINFO_PATCH(&unixinfo_GetPWUidInfo_Type);
#endif
#ifdef PY_SIDTOUID_PATCH
	PY_SIDTOUID_PATCH(&unixinfo_SidToUid_Type);
#endif
#ifdef PY_UIDTOSID_PATCH
	PY_UIDTOSID_PATCH(&unixinfo_UidToSid_Type);
#endif
#ifdef PY_SIDTOGID_PATCH
	PY_SIDTOGID_PATCH(&unixinfo_SidToGid_Type);
#endif
#ifdef PY_GIDTOSID_PATCH
	PY_GIDTOSID_PATCH(&unixinfo_GidToSid_Type);
#endif
#ifdef PY_GETPWUID_PATCH
	PY_GETPWUID_PATCH(&unixinfo_GetPWUid_Type);
#endif
#ifdef PY_UNIXINFO_PATCH
	PY_UNIXINFO_PATCH(&unixinfo_InterfaceType);
#endif
#ifdef PY_UNIXINFO_ABSTRACT_SYNTAX_PATCH
	PY_UNIXINFO_ABSTRACT_SYNTAX_PATCH(&unixinfo_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&unixinfo_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	Py_INCREF((PyObject *)(void *)&unixinfo_GetPWUidInfo_Type);
	PyModule_AddObject(m, "GetPWUidInfo", (PyObject *)(void *)&unixinfo_GetPWUidInfo_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_SidToUid_Type);
	PyModule_AddObject(m, "SidToUid", (PyObject *)(void *)&unixinfo_SidToUid_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_UidToSid_Type);
	PyModule_AddObject(m, "UidToSid", (PyObject *)(void *)&unixinfo_UidToSid_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_SidToGid_Type);
	PyModule_AddObject(m, "SidToGid", (PyObject *)(void *)&unixinfo_SidToGid_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_GidToSid_Type);
	PyModule_AddObject(m, "GidToSid", (PyObject *)(void *)&unixinfo_GidToSid_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_GetPWUid_Type);
	PyModule_AddObject(m, "GetPWUid", (PyObject *)(void *)&unixinfo_GetPWUid_Type);
	Py_INCREF((PyObject *)(void *)&unixinfo_InterfaceType);
	PyModule_AddObject(m, "unixinfo", (PyObject *)(void *)&unixinfo_InterfaceType);
	Py_INCREF((PyObject *)(void *)&unixinfo_SyntaxType);
	PyModule_AddObject(m, "unixinfo_abstract_syntax", (PyObject *)(void *)&unixinfo_SyntaxType);
	Py_INCREF((PyObject *)(void *)&unixinfo_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&unixinfo_SyntaxType);
#ifdef PY_MOD_UNIXINFO_PATCH
	PY_MOD_UNIXINFO_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
