// For license of this file, see <project-root-folder>/LICENSE.md.

#include "gui/reusable/texteditwithstatus.h"

#include "gui/reusable/plaintoolbutton.h"

#include <QHBoxLayout>
#include <QLineEdit>

TextEditWithStatus::TextEditWithStatus(QWidget* parent) : WidgetWithStatus(parent) {
  m_wdgInput = new QPlainTextEdit(this);
  setFocusProxy(m_wdgInput);

  // Set correct size for the tool button.
  const int txt_input_height = QLineEdit().sizeHint().height();

  m_btnStatus->setFixedSize(txt_input_height, txt_input_height);

  // Compose the layout.
  m_layout->addWidget(m_wdgInput);
  m_layout->addWidget(m_btnStatus, 0, Qt::AlignmentFlag::AlignTop);
}

void TextEditWithStatus::setText(StatusType status, const QString& text) {
  textEdit()->setPlainText(text);
  WidgetWithStatus::setStatus(status, text);
}
