/* Generated by wayland-scanner 1.24.0 */

#ifndef HYPRLAND_TOPLEVEL_EXPORT_V1_CLIENT_PROTOCOL_H
#define HYPRLAND_TOPLEVEL_EXPORT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_hyprland_toplevel_export_v1 The hyprland_toplevel_export_v1 protocol
 * capturing the contents of toplevel windows
 *
 * @section page_desc_hyprland_toplevel_export_v1 Description
 *
 * This protocol allows clients to ask for exporting another toplevel's
 * surface(s) to a buffer.
 *
 * Particularly useful for sharing a single window.
 *
 * @section page_ifaces_hyprland_toplevel_export_v1 Interfaces
 * - @subpage page_iface_hyprland_toplevel_export_manager_v1 - manager to inform clients and begin capturing
 * - @subpage page_iface_hyprland_toplevel_export_frame_v1 - a frame ready for copy
 * @section page_copyright_hyprland_toplevel_export_v1 Copyright
 * <pre>
 *
 * Copyright © 2022 Vaxry
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_toplevel_export_frame_v1;
struct hyprland_toplevel_export_manager_v1;
struct wl_buffer;
struct zwlr_foreign_toplevel_handle_v1;

#ifndef HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_INTERFACE
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_toplevel_export_manager_v1 hyprland_toplevel_export_manager_v1
 * @section page_iface_hyprland_toplevel_export_manager_v1_desc Description
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 * @section page_iface_hyprland_toplevel_export_manager_v1_api API
 * See @ref iface_hyprland_toplevel_export_manager_v1.
 */
/**
 * @defgroup iface_hyprland_toplevel_export_manager_v1 The hyprland_toplevel_export_manager_v1 interface
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 */
extern const struct wl_interface hyprland_toplevel_export_manager_v1_interface;
#endif
#ifndef HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_INTERFACE
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_INTERFACE
/**
 * @page page_iface_hyprland_toplevel_export_frame_v1 hyprland_toplevel_export_frame_v1
 * @section page_iface_hyprland_toplevel_export_frame_v1_desc Description
 *
 * This object represents a single frame.
 *
 * When created, a series of buffer events will be sent, each representing a
 * supported buffer type. The "buffer_done" event is sent afterwards to
 * indicate that all supported buffer types have been enumerated. The client
 * will then be able to send a "copy" request. If the capture is successful,
 * the compositor will send a "flags" followed by a "ready" event.
 *
 * wl_shm buffers are always supported, ie. the "buffer" event is guaranteed to be sent.
 *
 * If the capture failed, the "failed" event is sent. This can happen anytime
 * before the "ready" event.
 *
 * Once either a "ready" or a "failed" event is received, the client should
 * destroy the frame.
 * @section page_iface_hyprland_toplevel_export_frame_v1_api API
 * See @ref iface_hyprland_toplevel_export_frame_v1.
 */
/**
 * @defgroup iface_hyprland_toplevel_export_frame_v1 The hyprland_toplevel_export_frame_v1 interface
 *
 * This object represents a single frame.
 *
 * When created, a series of buffer events will be sent, each representing a
 * supported buffer type. The "buffer_done" event is sent afterwards to
 * indicate that all supported buffer types have been enumerated. The client
 * will then be able to send a "copy" request. If the capture is successful,
 * the compositor will send a "flags" followed by a "ready" event.
 *
 * wl_shm buffers are always supported, ie. the "buffer" event is guaranteed to be sent.
 *
 * If the capture failed, the "failed" event is sent. This can happen anytime
 * before the "ready" event.
 *
 * Once either a "ready" or a "failed" event is received, the client should
 * destroy the frame.
 */
extern const struct wl_interface hyprland_toplevel_export_frame_v1_interface;
#endif

#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL 0
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_DESTROY 1
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL_WITH_WLR_TOPLEVEL_HANDLE 2


/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL_WITH_WLR_TOPLEVEL_HANDLE_SINCE_VERSION 2

/** @ingroup iface_hyprland_toplevel_export_manager_v1 */
static inline void
hyprland_toplevel_export_manager_v1_set_user_data(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_toplevel_export_manager_v1, user_data);
}

/** @ingroup iface_hyprland_toplevel_export_manager_v1 */
static inline void *
hyprland_toplevel_export_manager_v1_get_user_data(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_toplevel_export_manager_v1);
}

static inline uint32_t
hyprland_toplevel_export_manager_v1_get_version(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_manager_v1);
}

/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 *
 * Capture the next frame of a toplevel. (window)
 *
 * The captured frame will not contain any server-side decorations and will
 * ignore the compositor-set geometry, like e.g. rounded corners.
 *
 * It will contain all the subsurfaces and popups, however the latter will be clipped
 * to the geometry of the base surface.
 *
 * The handle parameter refers to the address of the window as seen in `hyprctl clients`.
 * For example, for d161e7b0 it would be 3512854448.
 */
static inline struct hyprland_toplevel_export_frame_v1 *
hyprland_toplevel_export_manager_v1_capture_toplevel(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1, int32_t overlay_cursor, uint32_t handle)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_export_manager_v1,
			 HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL, &hyprland_toplevel_export_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_manager_v1), 0, NULL, overlay_cursor, handle);

	return (struct hyprland_toplevel_export_frame_v1 *) frame;
}

/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 *
 * All objects created by the manager will still remain valid, until their
 * appropriate destroy request has been called.
 */
static inline void
hyprland_toplevel_export_manager_v1_destroy(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_export_manager_v1,
			 HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_hyprland_toplevel_export_manager_v1
 *
 * Same as capture_toplevel, but with a zwlr_foreign_toplevel_handle_v1 handle.
 */
static inline struct hyprland_toplevel_export_frame_v1 *
hyprland_toplevel_export_manager_v1_capture_toplevel_with_wlr_toplevel_handle(struct hyprland_toplevel_export_manager_v1 *hyprland_toplevel_export_manager_v1, int32_t overlay_cursor, struct zwlr_foreign_toplevel_handle_v1 *handle)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_export_manager_v1,
			 HYPRLAND_TOPLEVEL_EXPORT_MANAGER_V1_CAPTURE_TOPLEVEL_WITH_WLR_TOPLEVEL_HANDLE, &hyprland_toplevel_export_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_manager_v1), 0, NULL, overlay_cursor, handle);

	return (struct hyprland_toplevel_export_frame_v1 *) frame;
}

#ifndef HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_ERROR_ENUM
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_ERROR_ENUM
enum hyprland_toplevel_export_frame_v1_error {
	/**
	 * the object has already been used to copy a wl_buffer
	 */
	HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_ERROR_ALREADY_USED = 0,
	/**
	 * buffer attributes are invalid
	 */
	HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_ERROR_INVALID_BUFFER = 1,
};
#endif /* HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_ERROR_ENUM */

#ifndef HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FLAGS_ENUM
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FLAGS_ENUM
enum hyprland_toplevel_export_frame_v1_flags {
	/**
	 * contents are y-inverted
	 */
	HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FLAGS_Y_INVERT = 1,
};
#endif /* HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FLAGS_ENUM */

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 * @struct hyprland_toplevel_export_frame_v1_listener
 */
struct hyprland_toplevel_export_frame_v1_listener {
	/**
	 * wl_shm buffer information
	 *
	 * Provides information about wl_shm buffer parameters that need
	 * to be used for this frame. This event is sent once after the
	 * frame is created if wl_shm buffers are supported.
	 * @param format buffer format
	 * @param width buffer width
	 * @param height buffer height
	 * @param stride buffer stride
	 */
	void (*buffer)(void *data,
		       struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
		       uint32_t format,
		       uint32_t width,
		       uint32_t height,
		       uint32_t stride);
	/**
	 * carries the coordinates of the damaged region
	 *
	 * This event is sent right before the ready event when
	 * ignore_damage was not set. It may be generated multiple times
	 * for each copy request.
	 *
	 * The arguments describe a box around an area that has changed
	 * since the last copy request that was derived from the current
	 * screencopy manager instance.
	 *
	 * The union of all regions received between the call to copy and a
	 * ready event is the total damage since the prior ready event.
	 * @param x damaged x coordinates
	 * @param y damaged y coordinates
	 * @param width current width
	 * @param height current height
	 */
	void (*damage)(void *data,
		       struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
		       uint32_t x,
		       uint32_t y,
		       uint32_t width,
		       uint32_t height);
	/**
	 * frame flags
	 *
	 * Provides flags about the frame. This event is sent once before
	 * the "ready" event.
	 * @param flags frame flags
	 */
	void (*flags)(void *data,
		      struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
		      uint32_t flags);
	/**
	 * indicates frame is available for reading
	 *
	 * Called as soon as the frame is copied, indicating it is
	 * available for reading. This event includes the time at which
	 * presentation happened at.
	 *
	 * The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec
	 * triples, each component being an unsigned 32-bit value. Whole
	 * seconds are in tv_sec which is a 64-bit value combined from
	 * tv_sec_hi and tv_sec_lo, and the additional fractional part in
	 * tv_nsec as nanoseconds. Hence, for valid timestamps tv_nsec must
	 * be in [0, 999999999]. The seconds part may have an arbitrary
	 * offset at start.
	 *
	 * After receiving this event, the client should destroy the
	 * object.
	 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
	 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
	 * @param tv_nsec nanoseconds part of the timestamp
	 */
	void (*ready)(void *data,
		      struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
		      uint32_t tv_sec_hi,
		      uint32_t tv_sec_lo,
		      uint32_t tv_nsec);
	/**
	 * frame copy failed
	 *
	 * This event indicates that the attempted frame copy has failed.
	 *
	 * After receiving this event, the client should destroy the
	 * object.
	 */
	void (*failed)(void *data,
		       struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1);
	/**
	 * linux-dmabuf buffer information
	 *
	 * Provides information about linux-dmabuf buffer parameters that
	 * need to be used for this frame. This event is sent once after
	 * the frame is created if linux-dmabuf buffers are supported.
	 * @param format fourcc pixel format
	 * @param width buffer width
	 * @param height buffer height
	 */
	void (*linux_dmabuf)(void *data,
			     struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
			     uint32_t format,
			     uint32_t width,
			     uint32_t height);
	/**
	 * all buffer types reported
	 *
	 * This event is sent once after all buffer events have been
	 * sent.
	 *
	 * The client should proceed to create a buffer of one of the
	 * supported types, and send a "copy" request.
	 */
	void (*buffer_done)(void *data,
			    struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1);
};

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
static inline int
hyprland_toplevel_export_frame_v1_add_listener(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1,
					       const struct hyprland_toplevel_export_frame_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) hyprland_toplevel_export_frame_v1,
				     (void (**)(void)) listener, data);
}

#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_COPY 0
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_DESTROY 1

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_DAMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_LINUX_DMABUF_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_BUFFER_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_COPY_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 */
#define HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_toplevel_export_frame_v1 */
static inline void
hyprland_toplevel_export_frame_v1_set_user_data(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_toplevel_export_frame_v1, user_data);
}

/** @ingroup iface_hyprland_toplevel_export_frame_v1 */
static inline void *
hyprland_toplevel_export_frame_v1_get_user_data(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_toplevel_export_frame_v1);
}

static inline uint32_t
hyprland_toplevel_export_frame_v1_get_version(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_frame_v1);
}

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 *
 * Copy the frame to the supplied buffer. The buffer must have the
 * correct size, see hyprland_toplevel_export_frame_v1.buffer and
 * hyprland_toplevel_export_frame_v1.linux_dmabuf. The buffer needs to have a
 * supported format.
 *
 * If the frame is successfully copied, a "flags" and a "ready" event is
 * sent. Otherwise, a "failed" event is sent.
 *
 * This event will wait for appropriate damage to be copied, unless the ignore_damage
 * arg is set to a non-zero value.
 */
static inline void
hyprland_toplevel_export_frame_v1_copy(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1, struct wl_buffer *buffer, int32_t ignore_damage)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_export_frame_v1,
			 HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_COPY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_frame_v1), 0, buffer, ignore_damage);
}

/**
 * @ingroup iface_hyprland_toplevel_export_frame_v1
 *
 * Destroys the frame. This request can be sent at any time by the client.
 */
static inline void
hyprland_toplevel_export_frame_v1_destroy(struct hyprland_toplevel_export_frame_v1 *hyprland_toplevel_export_frame_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_export_frame_v1,
			 HYPRLAND_TOPLEVEL_EXPORT_FRAME_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_export_frame_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
