/* theme-selector-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from theme-selector-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2025 Will Warner
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgnome-games-support.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <gtk/gtk.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_THEME_SELECTOR_DIALOG_0_PROPERTY,
	GAMES_THEME_SELECTOR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_theme_selector_dialog_properties[GAMES_THEME_SELECTOR_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesThemeSelectorDialogPrivate {
	gchar** theme_names;
	gint theme_names_length1;
	gint _theme_names_size_;
	AdwBin* theme_bin;
	GtkButton* prev_button;
	GtkButton* next_button;
};

struct _Block1Data {
	int _ref_count_;
	GamesThemeSelectorDialog* self;
	GamesThemeSelectorDialogChangeThemeFunc theme_update;
	gpointer theme_update_target;
};

static gint GamesThemeSelectorDialog_private_offset;
static gpointer games_theme_selector_dialog_parent_class = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void __lambda4_ (Block1Data* _data1_);
static void games_theme_selector_dialog_update (GamesThemeSelectorDialog* self,
                                         GamesThemeSelectorDialogChangeThemeFunc theme_update,
                                         gpointer theme_update_target);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda5_ (Block1Data* _data1_);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void games_theme_selector_dialog_finalize (GObject * obj);
static GType games_theme_selector_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_theme_selector_dialog_get_instance_private (GamesThemeSelectorDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesThemeSelectorDialog_private_offset);
}

/**
     * Creates a new ThemeSelectorDialog
     *
     * `theme_names` contains the name of each theme in your game.
     * If `theme_names` is empty, the dialog will break.
     *
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesThemeSelectorDialog* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda4_ (Block1Data* _data1_)
{
	GamesThemeSelectorDialog* self;
	guint _tmp0_;
	self = _data1_->self;
	self->active_index = self->active_index + 1;
	_tmp0_ = self->active_index;
	games_theme_selector_dialog_update (self, _data1_->theme_update, _data1_->theme_update_target);
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ (self);
}

static void
__lambda5_ (Block1Data* _data1_)
{
	GamesThemeSelectorDialog* self;
	guint _tmp0_;
	self = _data1_->self;
	self->active_index = self->active_index - 1;
	_tmp0_ = self->active_index;
	games_theme_selector_dialog_update (self, _data1_->theme_update, _data1_->theme_update_target);
}

static void
___lambda5__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda5_ (self);
}

GamesThemeSelectorDialog*
games_theme_selector_dialog_construct (GType object_type,
                                       gchar** theme_names,
                                       gint theme_names_length1,
                                       const gchar* active_theme,
                                       GtkWidget* theme_preview,
                                       GamesThemeSelectorDialogChangeThemeFunc theme_update,
                                       gpointer theme_update_target)
{
	GamesThemeSelectorDialog * self = NULL;
	Block1Data* _data1_;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp4_;
	AdwToolbarView* toolbar = NULL;
	AdwToolbarView* _tmp5_;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp6_;
	GtkBox* buttons_box = NULL;
	GtkBox* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	AdwBin* _tmp16_;
	AdwBin* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	AdwBin* _tmp20_;
	g_return_val_if_fail (active_theme != NULL, NULL);
	g_return_val_if_fail (theme_preview != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->theme_update = theme_update;
	_data1_->theme_update_target = theme_update_target;
	self = (GamesThemeSelectorDialog*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = (theme_names != NULL) ? _vala_array_dup1 (theme_names, theme_names_length1) : theme_names;
	_tmp0__length1 = theme_names_length1;
	self->priv->theme_names = (_vala_array_free (self->priv->theme_names, self->priv->theme_names_length1, (GDestroyNotify) g_free), NULL);
	self->priv->theme_names = _tmp0_;
	self->priv->theme_names_length1 = _tmp0__length1;
	self->priv->_theme_names_size_ = self->priv->theme_names_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) theme_names_length1))) {
					break;
				}
				_tmp3_ = theme_names[i];
				if (g_strcmp0 (_tmp3_, active_theme) == 0) {
					self->active_index = i;
				}
			}
		}
	}
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	_tmp5_ = (AdwToolbarView*) adw_toolbar_view_new ();
	g_object_ref_sink (_tmp5_);
	toolbar = _tmp5_;
	_tmp6_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp6_);
	headerbar = _tmp6_;
	adw_dialog_set_title ((AdwDialog*) self, "Select Theme");
	adw_header_bar_set_show_start_title_buttons (headerbar, TRUE);
	adw_header_bar_set_show_end_title_buttons (headerbar, TRUE);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	buttons_box = _tmp7_;
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic");
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->prev_button);
	self->priv->prev_button = _tmp8_;
	_tmp9_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->next_button);
	self->priv->next_button = _tmp9_;
	_tmp10_ = self->priv->prev_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, "Previous");
	_tmp11_ = self->priv->next_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, "Next");
	_tmp12_ = self->priv->next_button;
	g_signal_connect_data (_tmp12_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp13_ = self->priv->prev_button;
	g_signal_connect_data (_tmp13_, "clicked", (GCallback) ___lambda5__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp14_ = self->priv->prev_button;
	gtk_box_append (buttons_box, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->next_button;
	gtk_box_append (buttons_box, (GtkWidget*) _tmp15_);
	adw_header_bar_pack_start (headerbar, (GtkWidget*) buttons_box);
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) toolbar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) toolbar, builder, (GObject*) headerbar, "top");
	adw_dialog_set_child ((AdwDialog*) self, (GtkWidget*) toolbar);
	_tmp16_ = (AdwBin*) adw_bin_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->theme_bin);
	self->priv->theme_bin = _tmp16_;
	_tmp17_ = self->priv->theme_bin;
	adw_bin_set_child (_tmp17_, theme_preview);
	_tmp18_ = self->priv->next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, self->active_index < ((guint) (theme_names_length1 - 1)));
	_tmp19_ = self->priv->prev_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, self->active_index > ((guint) 0));
	_tmp20_ = self->priv->theme_bin;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) toolbar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) toolbar, builder, (GObject*) _tmp20_, NULL);
	_g_object_unref0 (buttons_box);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (builder);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

GamesThemeSelectorDialog*
games_theme_selector_dialog_new (gchar** theme_names,
                                 gint theme_names_length1,
                                 const gchar* active_theme,
                                 GtkWidget* theme_preview,
                                 GamesThemeSelectorDialogChangeThemeFunc theme_update,
                                 gpointer theme_update_target)
{
	return games_theme_selector_dialog_construct (GAMES_TYPE_THEME_SELECTOR_DIALOG, theme_names, theme_names_length1, active_theme, theme_preview, theme_update, theme_update_target);
}

static void
games_theme_selector_dialog_update (GamesThemeSelectorDialog* self,
                                    GamesThemeSelectorDialogChangeThemeFunc theme_update,
                                    gpointer theme_update_target)
{
	AdwBin* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkButton* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GtkButton* _tmp5_;
	GtkWidget* new_preview = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	AdwBin* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	AdwBin* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->theme_bin;
	_tmp1_ = adw_bin_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (((theme_update != NULL) && (_tmp2_ != NULL)) && (self->active_index != ((guint) -1)), "(theme_update != null) && (theme_bin.child != null) && (active_index != -1)");
	_tmp3_ = self->priv->next_button;
	_tmp4_ = self->priv->theme_names;
	_tmp4__length1 = self->priv->theme_names_length1;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, self->active_index < ((guint) (_tmp4__length1 - 1)));
	_tmp5_ = self->priv->prev_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, self->active_index > ((guint) 0));
	_tmp6_ = self->priv->theme_names;
	_tmp6__length1 = self->priv->theme_names_length1;
	_tmp7_ = _tmp6_[self->active_index];
	_tmp8_ = self->priv->theme_bin;
	_tmp9_ = adw_bin_get_child (_tmp8_);
	_tmp10_ = theme_update (_tmp7_, _tmp9_, theme_update_target);
	new_preview = _tmp10_;
	_tmp11_ = self->priv->theme_bin;
	adw_bin_set_child (_tmp11_, new_preview);
	_g_object_unref0 (new_preview);
}

static void
games_theme_selector_dialog_class_init (GamesThemeSelectorDialogClass * klass,
                                        gpointer klass_data)
{
	games_theme_selector_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesThemeSelectorDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_theme_selector_dialog_finalize;
}

static void
games_theme_selector_dialog_instance_init (GamesThemeSelectorDialog * self,
                                           gpointer klass)
{
	self->priv = games_theme_selector_dialog_get_instance_private (self);
	self->active_index = (guint) -1;
}

static void
games_theme_selector_dialog_finalize (GObject * obj)
{
	GamesThemeSelectorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_THEME_SELECTOR_DIALOG, GamesThemeSelectorDialog);
	self->priv->theme_names = (_vala_array_free (self->priv->theme_names, self->priv->theme_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->theme_bin);
	_g_object_unref0 (self->priv->prev_button);
	_g_object_unref0 (self->priv->next_button);
	G_OBJECT_CLASS (games_theme_selector_dialog_parent_class)->finalize (obj);
}

static GType
games_theme_selector_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesThemeSelectorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_theme_selector_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesThemeSelectorDialog), 0, (GInstanceInitFunc) games_theme_selector_dialog_instance_init, NULL };
	GType games_theme_selector_dialog_type_id;
	games_theme_selector_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GamesThemeSelectorDialog", &g_define_type_info, 0);
	GamesThemeSelectorDialog_private_offset = g_type_add_instance_private (games_theme_selector_dialog_type_id, sizeof (GamesThemeSelectorDialogPrivate));
	return games_theme_selector_dialog_type_id;
}

GType
games_theme_selector_dialog_get_type (void)
{
	static volatile gsize games_theme_selector_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_theme_selector_dialog_type_id__once)) {
		GType games_theme_selector_dialog_type_id;
		games_theme_selector_dialog_type_id = games_theme_selector_dialog_get_type_once ();
		g_once_init_leave (&games_theme_selector_dialog_type_id__once, games_theme_selector_dialog_type_id);
	}
	return games_theme_selector_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

