// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PeerConnectionInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PeerConnectionInfoDataView> {
  using Data = ::blink::mojom::internal::PeerConnectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class DeviceThermalState : int32_t {
  
  kUnknown = 0,
  
  kNominal = 1,
  
  kFair = 2,
  
  kSerious = 3,
  
  kCritical = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DeviceThermalState value);
inline bool IsKnownEnumValue(DeviceThermalState value) {
  return internal::DeviceThermalState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PeerConnectionManagerInterfaceBase {};

using PeerConnectionManagerPtrDataView =
    mojo::InterfacePtrDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerRequestDataView =
    mojo::InterfaceRequestDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PeerConnectionManagerInterfaceBase>;
class PeerConnectionTrackerHostInterfaceBase {};

using PeerConnectionTrackerHostPtrDataView =
    mojo::InterfacePtrDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostRequestDataView =
    mojo::InterfaceRequestDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PeerConnectionTrackerHostInterfaceBase>;


class PeerConnectionInfoDataView {
 public:
  PeerConnectionInfoDataView() {}

  PeerConnectionInfoDataView(
      internal::PeerConnectionInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t lid() const {
    return data_->lid;
  }
  inline void GetRtcConfigurationDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRtcConfiguration(UserType* output) {
    
    auto* pointer = data_->rtc_configuration.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConstraintsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConstraints(UserType* output) {
    
    auto* pointer = data_->constraints.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::PeerConnectionInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::DeviceThermalState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DeviceThermalState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::DeviceThermalState, ::blink::mojom::DeviceThermalState> {
  static ::blink::mojom::DeviceThermalState ToMojom(::blink::mojom::DeviceThermalState input) { return input; }
  static bool FromMojom(::blink::mojom::DeviceThermalState input, ::blink::mojom::DeviceThermalState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeviceThermalState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DeviceThermalState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::DeviceThermalState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PeerConnectionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PeerConnectionInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PeerConnectionInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->lid = Traits::lid(input);
    decltype(Traits::rtc_configuration(input)) in_rtc_configuration = Traits::rtc_configuration(input);
    typename decltype((*output)->rtc_configuration)::BaseType::BufferWriter
        rtc_configuration_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_rtc_configuration, buffer, &rtc_configuration_writer, context);
    (*output)->rtc_configuration.Set(
        rtc_configuration_writer.is_null() ? nullptr : rtc_configuration_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->rtc_configuration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rtc_configuration in PeerConnectionInfo struct");
    decltype(Traits::constraints(input)) in_constraints = Traits::constraints(input);
    typename decltype((*output)->constraints)::BaseType::BufferWriter
        constraints_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_constraints, buffer, &constraints_writer, context);
    (*output)->constraints.Set(
        constraints_writer.is_null() ? nullptr : constraints_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->constraints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null constraints in PeerConnectionInfo struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PeerConnectionInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::PeerConnectionInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PeerConnectionInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void PeerConnectionInfoDataView::GetRtcConfigurationDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rtc_configuration.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void PeerConnectionInfoDataView::GetConstraintsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->constraints.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void PeerConnectionInfoDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_SHARED_H_