// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class FetchAPIRequestHeadersDataView;

class FetchAPIDataElementDataView;

class FetchAPIRequestBodyDataView;

class FetchAPIRequestDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestHeadersDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequestHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIDataElementDataView> {
  using Data = ::blink::mojom::internal::FetchAPIDataElement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestBodyDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class RequestContextType : int32_t {
  
  UNSPECIFIED = 0,
  
  AUDIO = 1,
  
  BEACON = 2,
  
  CSP_REPORT = 3,
  
  DOWNLOAD = 4,
  
  EMBED = 5,
  
  EVENT_SOURCE = 6,
  
  FAVICON = 7,
  
  FETCH = 8,
  
  FONT = 9,
  
  FORM = 10,
  
  FRAME = 11,
  
  HYPERLINK = 12,
  
  IFRAME = 13,
  
  IMAGE = 14,
  
  IMAGE_SET = 15,
  
  IMPORT = 16,
  
  INTERNAL = 17,
  
  LOCATION = 18,
  
  MANIFEST = 19,
  
  OBJECT = 20,
  
  PING = 21,
  
  PLUGIN = 22,
  
  PREFETCH = 23,
  
  SCRIPT = 24,
  
  SERVICE_WORKER = 25,
  
  SHARED_WORKER = 26,
  
  SUBRESOURCE = 27,
  
  STYLE = 28,
  
  TRACK = 29,
  
  VIDEO = 30,
  
  WORKER = 31,
  
  XML_HTTP_REQUEST = 32,
  
  XSLT = 33,
  kMinValue = 0,
  kMaxValue = 33,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RequestContextType value);
inline bool IsKnownEnumValue(RequestContextType value) {
  return internal::RequestContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FetchCacheMode : int32_t {
  
  kDefault = 0,
  
  kNoStore = 1,
  
  kBypassCache = 2,
  
  kValidateCache = 3,
  
  kForceCache = 4,
  
  kOnlyIfCached = 5,
  
  kUnspecifiedOnlyIfCachedStrict = 6,
  
  kUnspecifiedForceCacheMiss = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FetchCacheMode value);
inline bool IsKnownEnumValue(FetchCacheMode value) {
  return internal::FetchCacheMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FetchImportanceMode : int32_t {
  
  kImportanceLow = 0,
  
  kImportanceAuto = 1,
  
  kImportanceHigh = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FetchImportanceMode value);
inline bool IsKnownEnumValue(FetchImportanceMode value) {
  return internal::FetchImportanceMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FetchAPIRequestHeadersDataView {
 public:
  FetchAPIRequestHeadersDataView() {}

  FetchAPIRequestHeadersDataView(
      internal::FetchAPIRequestHeaders_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::FetchAPIRequestHeaders_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FetchAPIDataElementDataView {
 public:
  FetchAPIDataElementDataView() {}

  FetchAPIDataElementDataView(
      internal::FetchAPIDataElement_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::DataElementType>(
        data_value, output);
  }

  ::network::mojom::DataElementType type() const {
    return static_cast<::network::mojom::DataElementType>(data_->type);
  }
  inline void GetBufDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBuf(UserType* output) {
    
    auto* pointer = data_->buf.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
  inline void GetBlobUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlobUuid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `blob_uuid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlobUuid` instead "
    "of `ReadBlobUuid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob_uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
            &data_->data_pipe_getter, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeChunkedDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
            &data_->chunked_data_pipe_getter, &result, context_);
    DCHECK(ret);
    return result;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetExpectedModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExpectedModificationTime(UserType* output) {
    
    auto* pointer = data_->expected_modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
 private:
  internal::FetchAPIDataElement_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FetchAPIRequestBodyDataView {
 public:
  FetchAPIRequestBodyDataView() {}

  FetchAPIRequestBodyDataView(
      internal::FetchAPIRequestBody_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<FetchAPIDataElementDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FetchAPIDataElementDataView>>(
        pointer, output, context_);
  }
  uint64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
 private:
  internal::FetchAPIRequestBody_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FetchAPIRequestDataView {
 public:
  FetchAPIRequestDataView() {}

  FetchAPIRequestDataView(
      internal::FetchAPIRequest_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::network::mojom::RequestMode>(
        data_value, output);
  }

  ::network::mojom::RequestMode mode() const {
    return static_cast<::network::mojom::RequestMode>(data_->mode);
  }
  bool is_main_resource_load() const {
    return data_->is_main_resource_load;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }

  ::network::mojom::RequestDestination destination() const {
    return static_cast<::network::mojom::RequestDestination>(data_->destination);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameType(UserType* output) const {
    auto data_value = data_->frame_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextFrameType>(
        data_value, output);
  }

  ::blink::mojom::RequestContextFrameType frame_type() const {
    return static_cast<::blink::mojom::RequestContextFrameType>(data_->frame_type);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetHeadersDataView(
      FetchAPIRequestHeadersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestHeadersDataView>(
        pointer, output, context_);
  }
  inline void GetBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, context_);
  }
  inline void GetBodyDataView(
      FetchAPIRequestBodyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIRequestBodyDataView, UserType>(),
    "Attempting to read the optional `body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBody` instead "
    "of `ReadBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestBodyDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ReferrerDataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCredentialsMode(UserType* output) const {
    auto data_value = data_->credentials_mode;
    return mojo::internal::Deserialize<::network::mojom::CredentialsMode>(
        data_value, output);
  }

  ::network::mojom::CredentialsMode credentials_mode() const {
    return static_cast<::network::mojom::CredentialsMode>(data_->credentials_mode);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCacheMode(UserType* output) const {
    auto data_value = data_->cache_mode;
    return mojo::internal::Deserialize<::blink::mojom::FetchCacheMode>(
        data_value, output);
  }

  FetchCacheMode cache_mode() const {
    return static_cast<FetchCacheMode>(data_->cache_mode);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectMode(UserType* output) const {
    auto data_value = data_->redirect_mode;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }

  ::network::mojom::RedirectMode redirect_mode() const {
    return static_cast<::network::mojom::RedirectMode>(data_->redirect_mode);
  }
  inline void GetIntegrityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIntegrity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `integrity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntegrity` instead "
    "of `ReadIntegrity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->integrity.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }

  ::network::mojom::RequestPriority priority() const {
    return static_cast<::network::mojom::RequestPriority>(data_->priority);
  }
  inline void GetFetchWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFetchWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `fetch_window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchWindowId` instead "
    "of `ReadFetchWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  bool keepalive() const {
    return data_->keepalive;
  }
  bool is_reload() const {
    return data_->is_reload;
  }
  bool is_history_navigation() const {
    return data_->is_history_navigation;
  }
 private:
  internal::FetchAPIRequest_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::RequestContextType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RequestContextType> {};

template <>
struct hash<::blink::mojom::FetchCacheMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FetchCacheMode> {};

template <>
struct hash<::blink::mojom::FetchImportanceMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FetchImportanceMode> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::RequestContextType, ::blink::mojom::RequestContextType> {
  static ::blink::mojom::RequestContextType ToMojom(::blink::mojom::RequestContextType input) { return input; }
  static bool FromMojom(::blink::mojom::RequestContextType input, ::blink::mojom::RequestContextType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RequestContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RequestContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::RequestContextType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::FetchCacheMode, ::blink::mojom::FetchCacheMode> {
  static ::blink::mojom::FetchCacheMode ToMojom(::blink::mojom::FetchCacheMode input) { return input; }
  static bool FromMojom(::blink::mojom::FetchCacheMode input, ::blink::mojom::FetchCacheMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchCacheMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FetchCacheMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::FetchCacheMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::FetchImportanceMode, ::blink::mojom::FetchImportanceMode> {
  static ::blink::mojom::FetchImportanceMode ToMojom(::blink::mojom::FetchImportanceMode input) { return input; }
  static bool FromMojom(::blink::mojom::FetchImportanceMode input, ::blink::mojom::FetchImportanceMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchImportanceMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FetchImportanceMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::FetchImportanceMode>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestHeadersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FetchAPIRequestHeaders_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    typename decltype((*output)->headers)::BaseType::BufferWriter
        headers_writer;
    const mojo::internal::ContainerValidateParams headers_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_headers, buffer, &headers_writer, &headers_validate_params,
        context);
    (*output)->headers.Set(
        headers_writer.is_null() ? nullptr : headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequestHeaders struct");
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequestHeaders_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestHeadersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIDataElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIDataElementDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FetchAPIDataElement_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::DataElementType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::buf(input)) in_buf = Traits::buf(input);
    typename decltype((*output)->buf)::BaseType::BufferWriter
        buf_writer;
    const mojo::internal::ContainerValidateParams buf_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_buf, buffer, &buf_writer, &buf_validate_params,
        context);
    (*output)->buf.Set(
        buf_writer.is_null() ? nullptr : buf_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->buf.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buf in FetchAPIDataElement struct");
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in FetchAPIDataElement struct");
    decltype(Traits::blob_uuid(input)) in_blob_uuid = Traits::blob_uuid(input);
    typename decltype((*output)->blob_uuid)::BaseType::BufferWriter
        blob_uuid_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_blob_uuid, buffer, &blob_uuid_writer, context);
    (*output)->blob_uuid.Set(
        blob_uuid_writer.is_null() ? nullptr : blob_uuid_writer.data());
    decltype(Traits::data_pipe_getter(input)) in_data_pipe_getter = Traits::data_pipe_getter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
        in_data_pipe_getter, &(*output)->data_pipe_getter, context);
    decltype(Traits::chunked_data_pipe_getter(input)) in_chunked_data_pipe_getter = Traits::chunked_data_pipe_getter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
        in_chunked_data_pipe_getter, &(*output)->chunked_data_pipe_getter, context);
    (*output)->offset = Traits::offset(input);
    (*output)->length = Traits::length(input);
    decltype(Traits::expected_modification_time(input)) in_expected_modification_time = Traits::expected_modification_time(input);
    typename decltype((*output)->expected_modification_time)::BaseType::BufferWriter
        expected_modification_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expected_modification_time, buffer, &expected_modification_time_writer, context);
    (*output)->expected_modification_time.Set(
        expected_modification_time_writer.is_null() ? nullptr : expected_modification_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->expected_modification_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expected_modification_time in FetchAPIDataElement struct");
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIDataElement_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIDataElementDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestBodyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FetchAPIRequestBody_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    typename decltype((*output)->elements)::BaseType::BufferWriter
        elements_writer;
    const mojo::internal::ContainerValidateParams elements_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FetchAPIDataElementDataView>>(
        in_elements, buffer, &elements_writer, &elements_validate_params,
        context);
    (*output)->elements.Set(
        elements_writer.is_null() ? nullptr : elements_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->elements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in FetchAPIRequestBody struct");
    (*output)->identifier = Traits::identifier(input);
    (*output)->contains_sensitive_info = Traits::contains_sensitive_info(input);
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequestBody_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestBodyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FetchAPIRequest_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::RequestMode>(
        Traits::mode(input), &(*output)->mode);
    (*output)->is_main_resource_load = Traits::is_main_resource_load(input);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::destination(input), &(*output)->destination);
    mojo::internal::Serialize<::blink::mojom::RequestContextFrameType>(
        Traits::frame_type(input), &(*output)->frame_type);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in FetchAPIRequest struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    typename decltype((*output)->method)::BaseType::BufferWriter
        method_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, buffer, &method_writer, context);
    (*output)->method.Set(
        method_writer.is_null() ? nullptr : method_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in FetchAPIRequest struct");
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    typename decltype((*output)->headers)::BaseType::BufferWriter
        headers_writer;
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestHeadersDataView>(
        in_headers, buffer, &headers_writer, context);
    (*output)->headers.Set(
        headers_writer.is_null() ? nullptr : headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequest struct");
    decltype(Traits::blob(input)) in_blob = Traits::blob(input);
    typename decltype((*output)->blob)::BaseType::BufferWriter
        blob_writer;
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
        in_blob, buffer, &blob_writer, context);
    (*output)->blob.Set(
        blob_writer.is_null() ? nullptr : blob_writer.data());
    decltype(Traits::body(input)) in_body = Traits::body(input);
    typename decltype((*output)->body)::BaseType::BufferWriter
        body_writer;
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestBodyDataView>(
        in_body, buffer, &body_writer, context);
    (*output)->body.Set(
        body_writer.is_null() ? nullptr : body_writer.data());
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    mojo::internal::Serialize<::network::mojom::CredentialsMode>(
        Traits::credentials_mode(input), &(*output)->credentials_mode);
    mojo::internal::Serialize<::blink::mojom::FetchCacheMode>(
        Traits::cache_mode(input), &(*output)->cache_mode);
    mojo::internal::Serialize<::network::mojom::RedirectMode>(
        Traits::redirect_mode(input), &(*output)->redirect_mode);
    decltype(Traits::integrity(input)) in_integrity = Traits::integrity(input);
    typename decltype((*output)->integrity)::BaseType::BufferWriter
        integrity_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_integrity, buffer, &integrity_writer, context);
    (*output)->integrity.Set(
        integrity_writer.is_null() ? nullptr : integrity_writer.data());
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::priority(input), &(*output)->priority);
    decltype(Traits::fetch_window_id(input)) in_fetch_window_id = Traits::fetch_window_id(input);
    typename decltype((*output)->fetch_window_id)::BaseType::BufferWriter
        fetch_window_id_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_fetch_window_id, buffer, &fetch_window_id_writer, context);
    (*output)->fetch_window_id.Set(
        fetch_window_id_writer.is_null() ? nullptr : fetch_window_id_writer.data());
    (*output)->keepalive = Traits::keepalive(input);
    (*output)->is_reload = Traits::is_reload(input);
    (*output)->is_history_navigation = Traits::is_history_navigation(input);
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequest_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void FetchAPIRequestHeadersDataView::GetHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, context_);
}


inline void FetchAPIDataElementDataView::GetBufDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->buf.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void FetchAPIDataElementDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}
inline void FetchAPIDataElementDataView::GetBlobUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->blob_uuid.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void FetchAPIDataElementDataView::GetExpectedModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expected_modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}


inline void FetchAPIRequestBodyDataView::GetElementsDataView(
    mojo::ArrayDataView<FetchAPIDataElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<FetchAPIDataElementDataView>(pointer, context_);
}


inline void FetchAPIRequestDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetHeadersDataView(
    FetchAPIRequestHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = FetchAPIRequestHeadersDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetBodyDataView(
    FetchAPIRequestBodyDataView* output) {
  auto pointer = data_->body.Get();
  *output = FetchAPIRequestBodyDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetIntegrityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->integrity.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void FetchAPIRequestDataView::GetFetchWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->fetch_window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_